/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.domain;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TestResult {
    UNDEFINED(0, false, "Undefined"),
    SUCCESS(1, true, "Passing"),
    PENDING(2, false, "Pending"),
    IGNORED(2, false, "Ignored"),
    SKIPPED(2, false, "Skipped"),
    ABORTED(2, false, "Aborted"),
    FAILURE(3, true, "Failing"),
    ERROR(4, true, "Broken"),
    COMPROMISED(5, true, "Compromised"),
    UNSUCCESSFUL(6, true, "Unsuccessful");

    private final int priority;
    private final boolean executedResultsCount;
    private final String adjective;
    private static Logger logger;
    private static final Map<TestResult, Set<TestResult>> AS_SETS;

    private TestResult(int priority, boolean executedResultsCount, String adjective) {
        this.priority = priority;
        this.executedResultsCount = executedResultsCount;
        this.adjective = adjective;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean overrides(TestResult result) {
        return this.priority > result.priority;
    }

    public boolean isMoreSevereThan(TestResult otherResult) {
        return this.ordinal() > otherResult.ordinal();
    }

    public boolean isLessSevereThan(TestResult otherResult) {
        return this.ordinal() < otherResult.ordinal();
    }

    public String getLabel() {
        return this.adjective + " tests";
    }

    public static boolean existsWithName(String expectedResult) {
        try {
            TestResult.valueOf(expectedResult);
        }
        catch (IllegalArgumentException noMatchingEnumValue) {
            logger.warn("No matching test result value found for {}", (Object)expectedResult);
            return false;
        }
        return true;
    }

    public boolean isAtLeast(TestResult minimumTestResult) {
        return this.priority >= minimumTestResult.priority;
    }

    public boolean executedResultsCount() {
        return this.executedResultsCount;
    }

    public String getAdjective() {
        return this.adjective;
    }

    public boolean isUnsuccessful() {
        return this == FAILURE || this == ERROR || this == COMPROMISED;
    }

    public boolean isEqualTo(String name) {
        return this.name().equalsIgnoreCase(name) || this.adjective.equalsIgnoreCase(name);
    }

    public Set<TestResult> expanded() {
        return AS_SETS.get((Object)this);
    }

    static {
        logger = LoggerFactory.getLogger((String)"net.thucydides.model.model.TestResult");
        AS_SETS = new HashMap<TestResult, Set<TestResult>>();
        for (TestResult value : TestResult.values()) {
            HashSet<TestResult> resultAsSet = new HashSet<TestResult>();
            resultAsSet.add(value);
            AS_SETS.put(value, resultAsSet);
        }
        HashSet<TestResult> unsuccessful = new HashSet<TestResult>();
        unsuccessful.add(FAILURE);
        unsuccessful.add(ERROR);
        unsuccessful.add(COMPROMISED);
        AS_SETS.put(UNSUCCESSFUL, unsuccessful);
    }
}

