/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.reports.styling;

import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.util.EnvironmentVariables;

public class TagStylist {
    private static final String BACKGROUND_STYLE = "background:%s;";
    private static final String BACKGROUND_AND_COLOR_STYLE = "background:%s; color:%s;";
    private static final String DEFAULT_COLOR_STYLE = "default";
    private static final String TAG_COLOR_PREFIX = "tag.color.for";
    private final Map<String, String> backgroundColorsByType;
    private final Map<String, String> foregroundColorsByType;

    private TagStylist(EnvironmentVariables environmentVariables) {
        Properties tagColorProperties = environmentVariables.getPropertiesWithPrefix(TAG_COLOR_PREFIX);
        this.backgroundColorsByType = new HashMap<String, String>();
        tagColorProperties.keySet().forEach(key -> {
            Optional<String> backgroundColor = this.backgroundColorIn(tagColorProperties.get(key));
            backgroundColor.ifPresent(color -> this.backgroundColorsByType.put(this.tagTypeFrom(key), (String)color));
        });
        this.foregroundColorsByType = new HashMap<String, String>();
        tagColorProperties.keySet().forEach(key -> {
            Optional<String> foregroundColor = this.foregroundColorIn(tagColorProperties.get(key));
            foregroundColor.ifPresent(color -> this.foregroundColorsByType.put(this.tagTypeFrom(key), (String)color));
        });
    }

    private Optional<String> backgroundColorIn(Object value) {
        List<String> colors = this.definedColorsIn(value);
        if (colors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(colors.get(0));
    }

    private List<String> definedColorsIn(Object value) {
        return Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)value.toString());
    }

    private Optional<String> foregroundColorIn(Object value) {
        List colors = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)value.toString());
        if (colors.size() <= 1) {
            return Optional.empty();
        }
        return Optional.of((String)colors.get(1));
    }

    private String tagTypeFrom(Object key) {
        return key.toString().replace("tag.color.for.", "");
    }

    public static TagStylist from(EnvironmentVariables environmentVariables) {
        return new TagStylist(environmentVariables);
    }

    public String tagStyleFor(TestTag tag) {
        if (tag == null) {
            return "";
        }
        String backgroundColor = this.backgroundColorsByType.getOrDefault(tag.getType(), DEFAULT_COLOR_STYLE);
        String foregroundColor = this.foregroundColorsByType.getOrDefault(tag.getType(), DEFAULT_COLOR_STYLE);
        if (this.foregroundColorsByType.containsKey(tag.getType())) {
            return String.format(BACKGROUND_AND_COLOR_STYLE, backgroundColor, foregroundColor);
        }
        return String.format(BACKGROUND_STYLE, backgroundColor);
    }
}

