/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.questions.QuestionForName;
import net.serenitybdd.screenplay.questions.QuestionForNames;
import net.serenitybdd.screenplay.targets.Target;
import org.openqa.selenium.By;

public class CSSValue {
    public static Question<String> of(Target target, String attributeName) {
        return Question.about((String)(attributeName + " CSS value of " + target.getName())).answeredBy(actor -> CSSValue.matches((List<WebElementFacade>)target.resolveAllFor(actor), attributeName));
    }

    public static Question<String> of(By byLocator, String attributeName) {
        return Question.about((String)(attributeName + " CSS value of element located by " + byLocator)).answeredBy(actor -> CSSValue.matches((List<WebElementFacade>)BrowseTheWeb.as(actor).findAll(byLocator), attributeName));
    }

    public static Question<String> of(String locator, String attributeName) {
        return Question.about((String)(attributeName + " CSS value of " + locator)).answeredBy(actor -> CSSValue.matches((List<WebElementFacade>)BrowseTheWeb.as(actor).findAll(locator, new Object[0]), attributeName));
    }

    public static Question<Collection<String>> ofEach(Target target, String attributeName) {
        return Question.about((String)(attributeName + " CSS value of each" + target.getName())).answeredBy(actor -> target.resolveAllFor(actor).stream().map(element -> CSSValue.matches(Collections.singletonList(element), attributeName)).collect(Collectors.toList()));
    }

    public static Question<Collection<String>> ofEach(By byLocator, String attributeName) {
        return Question.about((String)(attributeName + " CSS value of each" + byLocator)).answeredBy(actor -> BrowseTheWeb.as(actor).findAll(byLocator).stream().map(element -> CSSValue.matches(Collections.singletonList(element), attributeName)).collect(Collectors.toList()));
    }

    public static Question<Collection<String>> ofEach(String locator, String attributeName) {
        return Question.about((String)(attributeName + " CSS value of " + locator)).answeredBy(actor -> BrowseTheWeb.as(actor).findAll(locator, new Object[0]).stream().map(element -> CSSValue.matches(Collections.singletonList(element), attributeName)).collect(Collectors.toList()));
    }

    public static QuestionForName of(Target target) {
        return name -> CSSValue.of(target, name);
    }

    public static QuestionForName of(By byLocator) {
        return name -> CSSValue.of(byLocator, name);
    }

    public static QuestionForName of(String locator) {
        return name -> CSSValue.of(locator, name);
    }

    public static QuestionForNames ofEach(Target target) {
        return name -> CSSValue.ofEach(target, name);
    }

    public static QuestionForNames ofEach(By byLocator) {
        return name -> CSSValue.ofEach(byLocator, name);
    }

    public static QuestionForNames ofEach(String locator) {
        return name -> CSSValue.ofEach(locator, name);
    }

    private static String matches(List<WebElementFacade> elements, String attributeName) {
        return elements.stream().findFirst().map(element -> element.getCssValue(attributeName)).orElse("");
    }
}

