/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.pages.ListOfWebElementFacades;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import net.serenitybdd.core.webdriver.RemoteDriver;
import net.serenitybdd.screenplay.targets.HasByLocator;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.thucydides.core.webdriver.ThucydidesConfigurationException;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ByMobileTarget
extends SearchableTarget
implements HasByLocator {
    private By androidLocator;
    private By iosLocator;

    public ByMobileTarget(String targetElementName, By androidLocator, By iosLocator, Optional<IFrame> iFrame) {
        super(targetElementName, iFrame);
        this.androidLocator = androidLocator;
        this.iosLocator = iosLocator;
    }

    public ByMobileTarget(String targetElementName, By androidLocator, By iosLocator, Optional<IFrame> iFrame, Optional<Duration> timeout) {
        super(targetElementName, iFrame, timeout);
        this.androidLocator = androidLocator;
        this.iosLocator = iosLocator;
    }

    @Override
    public WebElementFacade resolveFor(PageObject page) {
        if (this.timeout.isPresent()) {
            return page.withTimeoutOf((Duration)this.timeout.get()).find(this.getLocatorForPlatform(page.getDriver()));
        }
        return page.find(this.getLocatorForPlatform(page.getDriver()));
    }

    @Override
    public ListOfWebElementFacades resolveAllFor(PageObject page) {
        if (this.timeout.isPresent()) {
            return new ListOfWebElementFacades((Collection)page.withTimeoutOf((Duration)this.timeout.get()).findAll(this.getLocatorForPlatform(page.getDriver())));
        }
        return new ListOfWebElementFacades((Collection)page.findAll(this.getLocatorForPlatform(page.getDriver())));
    }

    public WebElementFacade resolveFor(SearchContext searchContext) {
        return WebElementFacadeImpl.wrapWebElement((WebDriver)Serenity.getDriver(), (WebElement)searchContext.findElement(this.getLocatorForPlatform(Serenity.getDriver())));
    }

    public ListOfWebElementFacades resolveAllFor(SearchContext searchContext) {
        List matchingElements = searchContext.findElements(this.getLocatorForPlatform(Serenity.getDriver()));
        return WebElementFacadeImpl.fromWebElements((List)matchingElements);
    }

    @Override
    public SearchableTarget of(String ... parameters) {
        throw new UnsupportedOperationException("The of() method is not supported for By-type Targets");
    }

    private By getLocatorForPlatform(WebDriver driver) {
        if (null != this.androidLocator && null != this.iosLocator) {
            String platform;
            try {
                platform = RemoteDriver.isStubbed((WebDriver)driver) ? "IOS" : RemoteDriver.of((WebDriver)driver).getCapabilities().getCapability("platformName").toString().toUpperCase();
            }
            catch (Exception e) {
                throw new ThucydidesConfigurationException(String.format("The configured driver '%s' does not support Cross Platform Mobile targets", driver), (Throwable)e);
            }
            if (platform.equals("ANDROID")) {
                return this.androidLocator;
            }
            if (platform.equals("IOS")) {
                return this.iosLocator;
            }
            throw new ThucydidesConfigurationException(String.format("'%s' is not a valid platform for Cross Platform Mobile targets", platform));
        }
        throw new IllegalStateException("ByMobileTarget must have either an androidLocator or an iosLocator");
    }

    @Override
    public String getCssOrXPathSelector() {
        throw new UnsupportedOperationException("The getCssOrXPathSelector() method is not supported for By-type Targets");
    }

    @Override
    public Target waitingForNoMoreThan(Duration timeout) {
        return new ByMobileTarget(this.targetElementName, this.androidLocator, this.iosLocator, this.iFrame, Optional.ofNullable(timeout));
    }

    @Override
    public List<By> selectors(WebDriver driver) {
        return Collections.singletonList(this.getLocatorForPlatform(driver));
    }

    @Override
    public ByMobileTarget called(String name) {
        return new ByMobileTarget(name, this.androidLocator, this.iosLocator, this.iFrame, this.timeout);
    }

    @Override
    public List<String> getCssOrXPathSelectors() {
        throw new UnsupportedOperationException("The getCssOrXPathSelector() method is not supported for By Targets");
    }

    @Override
    public By getLocator() {
        return this.getLocatorForPlatform(Serenity.getDriver());
    }
}

