/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.LocatorStrategies;
import net.serenitybdd.screenplay.ui.TargetFactory;
import org.openqa.selenium.By;

public class Dropdown {
    private static final String BY_ID_OR_NAME = "css:select[id='{0}' i],select[name='{0}' i],select[data-test='{0}' i],[aria-label='{0}' i]";
    private static final String BY_DEFAULT_OPTION = ".//select[option[1][normalize-space(.)='{0}']]";

    public static SearchableTarget withNameOrId(String nameOrId) {
        return Target.the("'" + nameOrId + "' dropdown").locatedByFirstMatching(BY_ID_OR_NAME).of(nameOrId);
    }

    public static SearchableTarget withLabel(String labelText) {
        return Target.the("the '" + labelText + "' dropdown").locatedBy(LocatorStrategies.fieldWithLabel(labelText));
    }

    public static SearchableTarget withDefaultOption(String defaultOption) {
        return Target.the("the '" + defaultOption + "' dropdown").locatedBy(BY_DEFAULT_OPTION).of(defaultOption);
    }

    public static SearchableTarget locatedBy(String selector) {
        return TargetFactory.forElementOfType("dropdown").locatedByXPathOrCss(selector);
    }

    public static SearchableTarget located(By selector) {
        return TargetFactory.forElementOfType("dropdown").locatedBy(selector);
    }
}

