/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.serenitybdd.markers.CanBeSilent;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.serenitybdd.model.time.Stopwatch;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Complaint;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.EventualConsequenceBuilder;
import net.serenitybdd.screenplay.Performable;

public class EventualConsequence<T>
implements Consequence<T>,
CanBeSilent {
    public static final int A_SHORT_PERIOD_BETWEEN_TRIES = 100;
    private final Consequence<T> consequenceThatMightTakeSomeTime;
    private final long timeoutInMilliseconds;
    private final boolean isSilent;
    private Class<? extends Error> complaintType;
    private String complaintDetails;
    private AssertionError caughtAssertionError = null;
    private RuntimeException caughtRuntimeException = null;
    private List<Class<? extends Throwable>> exceptionsToIgnore = new ArrayList<Class<? extends Throwable>>();
    private final List<Performable> setupActions = new ArrayList<Performable>();

    public EventualConsequence(Consequence<T> consequenceThatMightTakeSomeTime, long timeoutInMilliseconds) {
        this(consequenceThatMightTakeSomeTime, timeoutInMilliseconds, false);
    }

    public EventualConsequence(Consequence<T> consequenceThatMightTakeSomeTime, long timeoutInMilliseconds, boolean isSilent) {
        this.consequenceThatMightTakeSomeTime = consequenceThatMightTakeSomeTime;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
        this.isSilent = isSilent;
    }

    public EventualConsequence(Consequence<T> consequenceThatMightTakeSomeTime) {
        this(consequenceThatMightTakeSomeTime, (long)ConfiguredEnvironment.getConfiguration().getElementTimeoutInSeconds() * 1000L);
    }

    public static <T> EventualConsequence<T> eventually(Consequence<T> consequenceThatMightTakeSomeTime) {
        return new EventualConsequence<T>(consequenceThatMightTakeSomeTime);
    }

    public EventualConsequenceBuilder<T> waitingForNoLongerThan(long amount) {
        return new EventualConsequenceBuilder(this.consequenceThatMightTakeSomeTime, amount);
    }

    @Override
    public void evaluateFor(Actor actor) {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        do {
            block7: {
                try {
                    this.performSetupActionsAs(actor);
                    this.consequenceThatMightTakeSomeTime.evaluateFor(actor);
                    return;
                }
                catch (AssertionError assertionError) {
                    if (!this.shouldIgnoreException((Throwable)((Object)assertionError))) {
                        this.caughtAssertionError = assertionError;
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (!this.shouldIgnoreException(runtimeException)) {
                        this.caughtRuntimeException = runtimeException;
                    }
                }
                catch (Throwable exception) {
                    if (this.shouldIgnoreException(exception)) break block7;
                    throw exception;
                }
            }
            this.pauseBeforeNextAttempt();
        } while (stopwatch.lapTime() < this.timeoutInMilliseconds);
        this.throwAnyCaughtErrors();
    }

    private boolean shouldIgnoreException(Throwable exception) {
        return this.exceptionsToIgnore.contains(exception.getClass());
    }

    private void pauseBeforeNextAttempt() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void throwAnyCaughtErrors() {
        if (this.caughtAssertionError != null) {
            this.throwComplaintTypeErrorIfSpecified((Throwable)((Object)this.caughtAssertionError));
            throw this.caughtAssertionError;
        }
        if (this.caughtRuntimeException != null) {
            this.throwComplaintTypeErrorIfSpecified(this.caughtRuntimeException);
            throw this.caughtRuntimeException;
        }
    }

    public String toString() {
        return this.consequenceThatMightTakeSomeTime.toString();
    }

    @Override
    public Consequence<T> orComplainWith(Class<? extends Error> complaintType) {
        this.complaintType = complaintType;
        return this;
    }

    public Consequence<T> ignoringExceptions(Class<? extends Throwable> ... exceptionsToIgnore) {
        this.exceptionsToIgnore = Arrays.asList(exceptionsToIgnore);
        return this;
    }

    @Override
    public Consequence<T> orComplainWith(Class<? extends Error> complaintType, String complaintDetails) {
        this.complaintType = complaintType;
        this.complaintDetails = complaintDetails;
        return this;
    }

    @Override
    public Consequence<T> whenAttemptingTo(Performable performable) {
        return new EventualConsequence<T>(this.consequenceThatMightTakeSomeTime.whenAttemptingTo(performable), this.timeoutInMilliseconds, this.isSilent);
    }

    @Override
    public Consequence<T> because(String explanation) {
        return new EventualConsequence<T>(this.consequenceThatMightTakeSomeTime.because(explanation), this.timeoutInMilliseconds, this.isSilent);
    }

    public boolean isSilent() {
        return this.isSilent;
    }

    public EventualConsequence<T> withNoReporting() {
        return new EventualConsequence<T>(this.consequenceThatMightTakeSomeTime, this.timeoutInMilliseconds, true);
    }

    private void throwComplaintTypeErrorIfSpecified(Throwable actualError) {
        if (this.complaintType != null) {
            throw Complaint.from(this.complaintType, this.complaintDetails, actualError);
        }
    }

    @Override
    public Consequence<T> after(Performable ... actions) {
        this.setupActions.addAll(Arrays.asList(actions));
        return this;
    }

    protected void performSetupActionsAs(Actor actor) {
        actor.attemptsTo(Actor.ErrorHandlingMode.IGNORE_EXCEPTIONS, this.setupActions.toArray(new Performable[0]));
    }
}

