/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.reports.model.BackgroundColor;
import net.thucydides.model.domain.TestResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lnet/serenitybdd/reports/model/CoverageSegment;", "", "percentage", "", "count", "", "result", "Lnet/thucydides/model/domain/TestResult;", "<init>", "(DJLnet/thucydides/model/domain/TestResult;)V", "getPercentage", "()D", "getCount", "()J", "getResult", "()Lnet/thucydides/model/domain/TestResult;", "color", "", "getColor", "()Ljava/lang/String;", "roundedPercentage", "getRoundedPercentage", "title", "getTitle", "serenity-stats"})
public final class CoverageSegment {
    private final double percentage;
    private final long count;
    @NotNull
    private final TestResult result;
    @NotNull
    private final String color;
    private final long roundedPercentage;
    @NotNull
    private final String title;

    public CoverageSegment(double percentage, long count, @NotNull TestResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.percentage = percentage;
        this.count = count;
        this.result = result;
        this.color = new BackgroundColor().inDarkforResult(this.result);
        this.roundedPercentage = Math.round(this.percentage);
        String string = this.result.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.title = this.roundedPercentage + "% " + string;
    }

    public final double getPercentage() {
        return this.percentage;
    }

    public final long getCount() {
        return this.count;
    }

    @NotNull
    public final TestResult getResult() {
        return this.result;
    }

    @NotNull
    public final String getColor() {
        return this.color;
    }

    public final long getRoundedPercentage() {
        return this.roundedPercentage;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }
}

