/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.preverification;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;

public class FullFrame
extends StackMapFrame {
    public int variablesCount;
    public VerificationType[] variables;
    public int stackCount;
    public VerificationType[] stack;

    public FullFrame() {
    }

    public FullFrame(int offsetDelta, VerificationType[] variables, VerificationType[] stack) {
        this(offsetDelta, variables.length, variables, stack.length, stack);
    }

    public FullFrame(int offsetDelta, int variablesCount, VerificationType[] variables, int stackCount, VerificationType[] stack) {
        this.u2offsetDelta = offsetDelta;
        this.variablesCount = variablesCount;
        this.variables = variables;
        this.stackCount = stackCount;
        this.stack = stack;
    }

    public void variablesAccept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VerificationTypeVisitor verificationTypeVisitor) {
        for (int index = 0; index < this.variablesCount; ++index) {
            this.variables[index].variablesAccept(clazz, method, codeAttribute, offset, index, verificationTypeVisitor);
        }
    }

    public void stackAccept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VerificationTypeVisitor verificationTypeVisitor) {
        for (int index = 0; index < this.stackCount; ++index) {
            this.stack[index].stackAccept(clazz, method, codeAttribute, offset, index, verificationTypeVisitor);
        }
    }

    public int getTag() {
        return 255;
    }

    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, StackMapFrameVisitor stackMapFrameVisitor) {
        stackMapFrameVisitor.visitFullFrame(clazz, method, codeAttribute, offset, this);
    }

    public boolean equals(Object object) {
        VerificationType otherType;
        VerificationType thisType;
        int index;
        if (!super.equals(object)) {
            return false;
        }
        FullFrame other = (FullFrame)object;
        if (this.u2offsetDelta != other.u2offsetDelta || this.variablesCount != other.variablesCount || this.stackCount != other.stackCount) {
            return false;
        }
        for (index = 0; index < this.variablesCount; ++index) {
            thisType = this.variables[index];
            otherType = other.variables[index];
            if (thisType.equals(otherType)) continue;
            return false;
        }
        for (index = 0; index < this.stackCount; ++index) {
            thisType = this.stack[index];
            otherType = other.stack[index];
            if (thisType.equals(otherType)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int index;
        int hashCode = super.hashCode();
        for (index = 0; index < this.variablesCount; ++index) {
            hashCode ^= this.variables[index].hashCode();
        }
        for (index = 0; index < this.stackCount; ++index) {
            hashCode ^= this.stack[index].hashCode();
        }
        return hashCode;
    }

    public String toString() {
        int index;
        StringBuffer buffer = new StringBuffer(super.toString()).append("Var: ");
        for (index = 0; index < this.variablesCount; ++index) {
            buffer = buffer.append('[').append(this.variables[index].toString()).append(']');
        }
        buffer.append(", Stack: ");
        for (index = 0; index < this.stackCount; ++index) {
            buffer = buffer.append('[').append(this.stack[index].toString()).append(']');
        }
        return buffer.toString();
    }
}

