/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.XPathException;

public class Rule {
    protected Pattern pattern;
    protected RuleTarget action;
    protected int precedence;
    protected int minImportPrecedence;
    protected double priority;
    protected Rule next;
    protected int sequence;
    private boolean alwaysMatches;
    private int rank;

    public Rule() {
    }

    public Rule(Pattern p, RuleTarget o, int prec, int min, double prio, int seq) {
        this.pattern = p;
        this.action = o;
        this.precedence = prec;
        this.minImportPrecedence = min;
        this.priority = prio;
        this.next = null;
        this.sequence = seq;
        o.registerRule(this);
    }

    public Rule(Rule r, boolean copyChain) {
        this.pattern = r.pattern.copy();
        this.action = r.action instanceof TemplateRule ? ((TemplateRule)r.action).copy() : r.action;
        this.precedence = r.precedence;
        this.minImportPrecedence = r.minImportPrecedence;
        this.priority = r.priority;
        this.sequence = r.sequence;
        this.next = r.next == null || !copyChain ? null : new Rule(r.next, true);
        this.action.registerRule(this);
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setAction(RuleTarget action) {
        this.action = action;
    }

    public RuleTarget getAction() {
        return this.action;
    }

    public Rule getNext() {
        return this.next;
    }

    public void setNext(Rule next) {
        this.next = next;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public double getPriority() {
        return this.priority;
    }

    public void setAlwaysMatches(boolean matches) {
        this.alwaysMatches = matches;
    }

    public boolean isAlwaysMatches() {
        return this.alwaysMatches;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    public void export(ExpressionPresenter out, boolean modeStreamable) throws XPathException {
        RuleTarget target = this.getAction();
        TemplateRule template = null;
        if (target instanceof TemplateRule) {
            int e;
            template = (TemplateRule)target;
            int s = out.startElement("templateRule");
            out.emitAttribute("prec", this.getPrecedence() + "");
            out.emitAttribute("prio", this.getPriority() + "");
            out.emitAttribute("seq", this.getSequence() + "");
            out.emitAttribute("rank", "" + this.getRank());
            out.emitAttribute("minImp", this.getMinImportPrecedence() + "");
            out.emitAttribute("slots", template.getStackFrameMap().getNumberOfVariables() + "");
            template.explainProperties(out);
            this.exportOtherProperties(out);
            out.setChildRole("match");
            this.getPattern().export(out);
            if (template.getBody() != null) {
                out.setChildRole("action");
                template.getBody().export(out);
            }
            if (s != (e = out.endElement())) {
                throw new IllegalStateException("Export tree unbalanced in template at line " + (template != null ? template.getLineNumber() + " of " + template.getSystemId() : ""));
            }
        } else {
            target.export(out);
        }
    }

    public void exportOtherProperties(ExpressionPresenter out) throws XPathException {
    }

    public int compareRank(Rule other) {
        return this.rank - other.rank;
    }

    public int compareComputedRank(Rule other) {
        if (this.precedence == other.precedence) {
            if (this.priority == other.priority) {
                return 0;
            }
            if (this.priority < other.priority) {
                return -1;
            }
            return 1;
        }
        if (this.precedence < other.precedence) {
            return -1;
        }
        return 1;
    }

    public boolean matches(Item item, XPathContextMajor context) throws XPathException {
        return this.alwaysMatches || this.pattern.matches(item, context);
    }
}

