/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.client.googleapis.javanet;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.GoogleUtils;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.mtls.MtlsProvider;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.mtls.MtlsUtils;
import net.snowflake.client.jdbc.internal.google.api.client.http.javanet.NetHttpTransport;
import net.snowflake.client.jdbc.internal.google.api.client.util.Beta;

public class GoogleNetHttpTransport {
    public static NetHttpTransport newTrustedTransport() throws GeneralSecurityException, IOException {
        return GoogleNetHttpTransport.newTrustedTransport(MtlsUtils.getDefaultMtlsProvider());
    }

    @Beta
    public static NetHttpTransport newTrustedTransport(MtlsProvider mtlsProvider) throws GeneralSecurityException, IOException {
        KeyStore mtlsKeyStore = null;
        String mtlsKeyStorePassword = null;
        if (mtlsProvider.useMtlsClientCertificate()) {
            mtlsKeyStore = mtlsProvider.getKeyStore();
            mtlsKeyStorePassword = mtlsProvider.getKeyStorePassword();
        }
        if (mtlsKeyStore != null && mtlsKeyStorePassword != null) {
            return new NetHttpTransport.Builder().trustCertificates(GoogleUtils.getCertificateTrustStore(), mtlsKeyStore, mtlsKeyStorePassword).build();
        }
        return new NetHttpTransport.Builder().trustCertificates(GoogleUtils.getCertificateTrustStore()).build();
    }

    private GoogleNetHttpTransport() {
    }
}

