/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.BaseSqlInput;
import net.snowflake.client.core.ColumnTypeHelper;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFResultSet;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.json.Converters;
import net.snowflake.client.core.structs.SQLDataCreationHelper;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.JsonStringHashMap;
import net.snowflake.client.util.ThrowingBiFunction;

@SnowflakeJdbcInternalApi
public class ArrowSqlInput
extends BaseSqlInput {
    private final Map<String, Object> input;
    private int currentIndex = 0;
    private boolean wasNull = false;

    public ArrowSqlInput(Map<String, Object> input, SFBaseSession session, Converters converters, List<FieldMetadata> fields) {
        super(session, converters, fields);
        this.input = input;
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    @Override
    public String readString() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            int columnSubType = fieldMetadata.getType();
            int scale = fieldMetadata.getScale();
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getStringConverter().getString(value, columnType, columnSubType, scale));
        });
    }

    @Override
    public boolean readBoolean() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getBooleanConverter().getBoolean(value, columnType));
        });
    }

    @Override
    public byte readByte() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getByte(value)));
    }

    @Override
    public short readShort() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getShort(value, columnType));
        });
    }

    @Override
    public int readInt() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getInt(value, columnType));
        });
    }

    @Override
    public long readLong() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getLong(value, columnType));
        });
    }

    @Override
    public float readFloat() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> Float.valueOf(this.converters.getNumberConverter().getFloat(value, columnType)));
        }).floatValue();
    }

    @Override
    public double readDouble() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
            return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getDouble(value, columnType));
        });
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> this.convertToBigDecimal(value, (FieldMetadata)fieldMetadata));
    }

    private BigDecimal convertToBigDecimal(Object value, FieldMetadata fieldMetadata) throws SQLException {
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getBigDecimal(value, columnType));
    }

    @Override
    public byte[] readBytes() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> this.converToBytes(value, (FieldMetadata)fieldMetadata));
    }

    private byte[] converToBytes(Object value, FieldMetadata fieldMetadata) throws SQLException {
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        int columnSubType = fieldMetadata.getType();
        int scale = fieldMetadata.getScale();
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getBytesConverter().getBytes(value, columnType, columnSubType, scale));
    }

    @Override
    public Date readDate() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            return this.formatDate((Integer)value);
        });
    }

    private Date formatDate(int value) throws SQLException {
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getStructuredTypeDateTimeConverter().getDate(value, TimeZone.getDefault()));
    }

    @Override
    public Time readTime() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            return this.formatTime((Long)value, (FieldMetadata)fieldMetadata);
        });
    }

    private Time formatTime(long value, FieldMetadata fieldMetadata) throws SQLException {
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> {
            int scale = fieldMetadata.getScale();
            return this.converters.getStructuredTypeDateTimeConverter().getTime(value, scale);
        });
    }

    @Override
    public Timestamp readTimestamp(TimeZone tz) throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> this.formatTimestamp(tz, value, (FieldMetadata)fieldMetadata));
    }

    private Timestamp formatTimestamp(TimeZone tz, Object value, FieldMetadata fieldMetadata) throws SQLException {
        if (value == null) {
            return null;
        }
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        int columnSubType = fieldMetadata.getType();
        int scale = fieldMetadata.getScale();
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getStructuredTypeDateTimeConverter().getTimestamp((Map)value, columnType, columnSubType, tz, scale));
    }

    @Override
    public Object readObject() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (!(value instanceof JsonStringHashMap)) {
                throw new SQLException("Invalid value passed to 'readObject()', expected Map; got: " + value.getClass());
            }
            return value;
        });
    }

    @Override
    public <T> T readObject(Class<T> type) throws SQLException {
        return (T)this.withNextValue((value, fieldMetadata) -> {
            if (SQLData.class.isAssignableFrom(type)) {
                if (value == null) {
                    return null;
                }
                ArrowSqlInput sqlInput = new ArrowSqlInput((Map)value, this.session, this.converters, fieldMetadata.getFields());
                SQLData instance = (SQLData)SQLDataCreationHelper.create(type);
                instance.readSQL(sqlInput, null);
                return instance;
            }
            if (value == null) {
                return null;
            }
            if (Map.class.isAssignableFrom(type)) {
                if (value == null) {
                    return null;
                }
                return this.convertSqlInputToMap((SQLInput)value);
            }
            if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
                return value;
            }
            if (Date.class.isAssignableFrom(type)) {
                return this.formatDate((Integer)value);
            }
            if (Time.class.isAssignableFrom(type)) {
                return this.formatTime((Long)value, (FieldMetadata)fieldMetadata);
            }
            if (Timestamp.class.isAssignableFrom(type)) {
                return this.formatTimestamp(TimeZone.getDefault(), value, (FieldMetadata)fieldMetadata);
            }
            if (BigDecimal.class.isAssignableFrom(type)) {
                return this.convertToBigDecimal(value, (FieldMetadata)fieldMetadata);
            }
            if (byte[].class.isAssignableFrom(type)) {
                return this.converToBytes(value, (FieldMetadata)fieldMetadata);
            }
            SFResultSet.logger.debug("Unsupported type passed to readObject(int columnIndex,Class<T> type): " + type.getName(), new Object[0]);
            throw new SQLException("Type passed to 'getObject(int columnIndex,Class<T> type)' is unsupported. Type: " + type.getName());
        });
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    Map<String, Object> convertSqlInputToMap(SQLInput sqlInput) {
        return ((ArrowSqlInput)sqlInput).getInput();
    }

    private <T> T withNextValue(ThrowingBiFunction<Object, FieldMetadata, T, SQLException> action) throws SQLException {
        FieldMetadata field;
        Object value;
        this.wasNull = (value = this.input.get((field = (FieldMetadata)this.fields.get(this.currentIndex++)).getName())) == null;
        return action.apply(value, field);
    }
}

