/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BackwardCompatibilityUtils;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ServiceAccount;

public class HmacKey
implements Serializable {
    private static final long serialVersionUID = 3033393659217005187L;
    private final String secretKey;
    private final HmacKeyMetadata metadata;

    private HmacKey(Builder builder) {
        this.secretKey = builder.secretKey;
        this.metadata = builder.metadata;
    }

    public static Builder newBuilder(String secretKey) {
        return new Builder(secretKey);
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public HmacKeyMetadata getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hash(this.secretKey, this.metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HmacKey)) {
            return false;
        }
        HmacKey hmacKey = (HmacKey)o;
        return Objects.equals(this.secretKey, hmacKey.secretKey) && Objects.equals(this.metadata, hmacKey.metadata);
    }

    public static class HmacKeyMetadata
    implements Serializable {
        private static final long serialVersionUID = 9130344756739042314L;
        private final String accessId;
        private final String etag;
        private final String id;
        private final String projectId;
        private final ServiceAccount serviceAccount;
        private final HmacKeyState state;
        private final OffsetDateTime createTime;
        private final OffsetDateTime updateTime;

        private HmacKeyMetadata(Builder builder) {
            this.accessId = builder.accessId;
            this.etag = builder.etag;
            this.id = builder.id;
            this.projectId = builder.projectId;
            this.serviceAccount = builder.serviceAccount;
            this.state = builder.state;
            this.createTime = builder.createTime;
            this.updateTime = builder.updateTime;
        }

        public static Builder newBuilder(ServiceAccount serviceAccount) {
            return new Builder(serviceAccount);
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        public static HmacKeyMetadata of(ServiceAccount serviceAccount, String accessId, String projectId) {
            return HmacKeyMetadata.newBuilder(serviceAccount).setAccessId(accessId).setProjectId(projectId).build();
        }

        public int hashCode() {
            return Objects.hash(this.accessId, this.projectId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HmacKeyMetadata other = (HmacKeyMetadata)obj;
            return Objects.equals(this.accessId, other.accessId) && Objects.equals(this.etag, other.etag) && Objects.equals(this.id, other.id) && Objects.equals(this.projectId, other.projectId) && Objects.equals(this.serviceAccount, other.serviceAccount) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.createTime, other.createTime) && Objects.equals(this.updateTime, other.updateTime);
        }

        public String getAccessId() {
            return this.accessId;
        }

        public String getEtag() {
            return this.etag;
        }

        public String getId() {
            return this.id;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public ServiceAccount getServiceAccount() {
            return this.serviceAccount;
        }

        public HmacKeyState getState() {
            return this.state;
        }

        @Deprecated
        public Long getCreateTime() {
            return (Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(this.createTime);
        }

        public OffsetDateTime getCreateTimeOffsetDateTime() {
            return this.createTime;
        }

        @Deprecated
        public Long getUpdateTime() {
            return (Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(this.updateTime);
        }

        public OffsetDateTime getUpdateTimeOffsetDateTime() {
            return this.updateTime;
        }

        public static class Builder {
            private String accessId;
            private String etag;
            private String id;
            private String projectId;
            private ServiceAccount serviceAccount;
            private HmacKeyState state;
            private OffsetDateTime createTime;
            private OffsetDateTime updateTime;

            private Builder(ServiceAccount serviceAccount) {
                this.serviceAccount = serviceAccount;
            }

            private Builder(HmacKeyMetadata metadata) {
                this.accessId = metadata.accessId;
                this.etag = metadata.etag;
                this.id = metadata.id;
                this.projectId = metadata.projectId;
                this.serviceAccount = metadata.serviceAccount;
                this.state = metadata.state;
                this.createTime = metadata.createTime;
                this.updateTime = metadata.updateTime;
            }

            public Builder setAccessId(String accessId) {
                this.accessId = accessId;
                return this;
            }

            public Builder setEtag(String etag) {
                this.etag = etag;
                return this;
            }

            public Builder setId(String id) {
                this.id = id;
                return this;
            }

            public Builder setServiceAccount(ServiceAccount serviceAccount) {
                this.serviceAccount = serviceAccount;
                return this;
            }

            public Builder setState(HmacKeyState state) {
                this.state = state;
                return this;
            }

            @Deprecated
            public Builder setCreateTime(long createTime) {
                return this.setCreateTimeOffsetDateTime((OffsetDateTime)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.encode(createTime));
            }

            public Builder setCreateTimeOffsetDateTime(OffsetDateTime createTime) {
                this.createTime = createTime;
                return this;
            }

            public Builder setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public HmacKeyMetadata build() {
                return new HmacKeyMetadata(this);
            }

            @Deprecated
            public Builder setUpdateTime(long updateTime) {
                return this.setUpdateTimeOffsetDateTime((OffsetDateTime)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.encode(updateTime));
            }

            public Builder setUpdateTimeOffsetDateTime(OffsetDateTime updateTime) {
                this.updateTime = updateTime;
                return this;
            }
        }
    }

    public static enum HmacKeyState {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE"),
        DELETED("DELETED");

        private final String state;

        private HmacKeyState(String state) {
            this.state = state;
        }
    }

    public static class Builder {
        private String secretKey;
        private HmacKeyMetadata metadata;

        private Builder(String secretKey) {
            this.secretKey = secretKey;
        }

        public Builder setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public Builder setMetadata(HmacKeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public HmacKey build() {
            return new HmacKey(this);
        }
    }
}

