/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.Attributes;
import net.snowflake.client.jdbc.internal.grpc.Metadata;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.internal.AbstractServerStream;
import net.snowflake.client.jdbc.internal.grpc.internal.StatsTraceContext;
import net.snowflake.client.jdbc.internal.grpc.internal.TransportTracer;
import net.snowflake.client.jdbc.internal.grpc.internal.WritableBuffer;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.CancelServerStreamCommand;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.NettyReadableBuffer;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.NettyServerHandler;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.NettyWritableBuffer;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.NettyWritableBufferAllocator;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.SendGrpcFrameCommand;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.SendResponseHeadersCommand;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.StreamIdHolder;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.Utils;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.WriteQueue;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.Channel;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.EventLoop;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Stream;
import net.snowflake.client.jdbc.internal.io.perfmark.Link;
import net.snowflake.client.jdbc.internal.io.perfmark.PerfMark;
import net.snowflake.client.jdbc.internal.io.perfmark.Tag;
import net.snowflake.client.jdbc.internal.io.perfmark.TaskCloseable;

class NettyServerStream
extends AbstractServerStream {
    private static final Logger log = Logger.getLogger(NettyServerStream.class.getName());
    private final Sink sink = new Sink();
    private final TransportState state;
    private final WriteQueue writeQueue;
    private final Attributes attributes;
    private final String authority;
    private final TransportTracer transportTracer;
    private final int streamId;

    public NettyServerStream(Channel channel, TransportState state, Attributes transportAttrs, String authority, StatsTraceContext statsTraceCtx, TransportTracer transportTracer) {
        super(new NettyWritableBufferAllocator(channel.alloc()), statsTraceCtx);
        this.state = Preconditions.checkNotNull(state, "transportState");
        this.writeQueue = state.handler.getWriteQueue();
        this.attributes = Preconditions.checkNotNull(transportAttrs);
        this.authority = authority;
        this.transportTracer = Preconditions.checkNotNull(transportTracer, "transportTracer");
        this.streamId = this.transportState().id();
    }

    @Override
    protected TransportState transportState() {
        return this.state;
    }

    @Override
    protected Sink abstractServerStreamSink() {
        return this.sink;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public int streamId() {
        return this.streamId;
    }

    public static class TransportState
    extends AbstractServerStream.TransportState
    implements StreamIdHolder {
        private final Http2Stream http2Stream;
        private final NettyServerHandler handler;
        private final EventLoop eventLoop;
        private final Tag tag;

        public TransportState(NettyServerHandler handler, EventLoop eventLoop, Http2Stream http2Stream, int maxMessageSize, StatsTraceContext statsTraceCtx, TransportTracer transportTracer, String methodName) {
            super(maxMessageSize, statsTraceCtx, transportTracer);
            this.http2Stream = Preconditions.checkNotNull(http2Stream, "http2Stream");
            this.handler = Preconditions.checkNotNull(handler, "handler");
            this.eventLoop = eventLoop;
            this.tag = PerfMark.createTag(methodName, http2Stream.id());
        }

        @Override
        public void runOnTransportThread(final Runnable r) {
            if (this.eventLoop.inEventLoop()) {
                r.run();
            } else {
                final Link link = PerfMark.linkOut();
                this.eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        try (TaskCloseable ignore = PerfMark.traceTask("NettyServerStream$TransportState.runOnTransportThread");){
                            PerfMark.attachTag(tag);
                            PerfMark.linkIn(link);
                            r.run();
                        }
                    }
                });
            }
        }

        @Override
        public void bytesRead(int processedBytes) {
            this.handler.returnProcessedBytes(this.http2Stream, processedBytes);
            this.handler.getWriteQueue().scheduleFlush();
        }

        @Override
        public void deframeFailed(Throwable cause) {
            log.log(Level.WARNING, "Exception processing message", cause);
            Status status = Status.fromThrowable(cause);
            this.transportReportStatus(status);
            this.handler.getWriteQueue().enqueue(new CancelServerStreamCommand(this, status), true);
        }

        void inboundDataReceived(ByteBuf frame, boolean endOfStream) {
            super.inboundDataReceived(new NettyReadableBuffer(frame.retain()), endOfStream);
        }

        @Override
        public int id() {
            return this.http2Stream.id();
        }

        @Override
        public Tag tag() {
            return this.tag;
        }
    }

    private class Sink
    implements AbstractServerStream.Sink {
        private Sink() {
        }

        @Override
        public void writeHeaders(Metadata headers, boolean flush) {
            try (TaskCloseable ignore = PerfMark.traceTask("NettyServerStream$Sink.writeHeaders");){
                NettyServerStream.this.writeQueue.enqueue(SendResponseHeadersCommand.createHeaders(NettyServerStream.this.transportState(), Utils.convertServerHeaders(headers)), flush);
            }
        }

        private void writeFrameInternal(WritableBuffer frame, boolean flush, final int numMessages) {
            Preconditions.checkArgument(numMessages >= 0);
            ByteBuf bytebuf = ((NettyWritableBuffer)frame).bytebuf().touch();
            final int numBytes = bytebuf.readableBytes();
            NettyServerStream.this.onSendingBytes(numBytes);
            NettyServerStream.this.writeQueue.enqueue(new SendGrpcFrameCommand(NettyServerStream.this.transportState(), bytebuf, false), flush).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    NettyServerStream.this.transportState().onSentBytes(numBytes);
                    if (future.isSuccess()) {
                        NettyServerStream.this.transportTracer.reportMessageSent(numMessages);
                    }
                }
            });
        }

        @Override
        public void writeFrame(WritableBuffer frame, boolean flush, int numMessages) {
            try (TaskCloseable ignore = PerfMark.traceTask("NettyServerStream$Sink.writeFrame");){
                this.writeFrameInternal(frame, flush, numMessages);
            }
        }

        @Override
        public void writeTrailers(Metadata trailers, boolean headersSent, Status status) {
            try (TaskCloseable ignore = PerfMark.traceTask("NettyServerStream$Sink.writeTrailers");){
                Http2Headers http2Trailers = Utils.convertTrailers(trailers, headersSent);
                NettyServerStream.this.writeQueue.enqueue(SendResponseHeadersCommand.createTrailers(NettyServerStream.this.transportState(), http2Trailers, status), true);
            }
        }

        @Override
        public void cancel(Status status) {
            try (TaskCloseable ignore = PerfMark.traceTask("NettyServerStream$Sink.cancel");){
                NettyServerStream.this.writeQueue.enqueue(new CancelServerStreamCommand(NettyServerStream.this.transportState(), status), true);
            }
        }
    }
}

