/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

class SnowflakeResultSetMetaDataV1
implements ResultSetMetaData,
SnowflakeResultSetMetaData {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeResultSetMetaDataV1.class);
    private SFResultSetMetaData resultSetMetaData;
    private String queryId;
    private QueryType queryType = QueryType.SYNC;
    private SFBaseSession session;

    SnowflakeResultSetMetaDataV1(SFResultSetMetaData resultSetMetaData) throws SnowflakeSQLException {
        this.resultSetMetaData = resultSetMetaData;
        this.queryId = resultSetMetaData.getQueryId();
        this.session = resultSetMetaData.getSession();
    }

    public void setQueryType(QueryType type) {
        this.queryType = type;
    }

    @Override
    public String getQueryID() throws SQLException {
        return this.queryId;
    }

    public void setQueryIdForAsyncResults(String queryId) {
        this.queryId = queryId;
    }

    @Override
    public List<String> getColumnNames() throws SQLException {
        return this.resultSetMetaData.getColumnNames();
    }

    @Override
    public int getColumnIndex(String columnName) throws SQLException {
        return this.resultSetMetaData.getColumnIndex(columnName);
    }

    @Override
    public int getInternalColumnType(int column) throws SQLException {
        try {
            return this.resultSetMetaData.getInternalColumnType(column);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLLoggedException(this.session, ex.getSqlState(), ex.getVendorCode(), ex.getCause(), ex.getParams());
        }
    }

    @Override
    public List<FieldMetadata> getColumnFields(int column) throws SQLException {
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.resultSetMetaData.getColumnFields(column));
    }

    @Override
    public int getDimension(int column) throws SQLException {
        return this.resultSetMetaData.getDimension(column);
    }

    @Override
    public int getDimension(String columnName) throws SQLException {
        return this.resultSetMetaData.getDimension(this.getColumnIndex(columnName) + 1);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.trace("<T> T unwrap(Class<T> iface)", false);
        if (!iface.isInstance(this)) {
            throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.trace("boolean isWrapperFor(Class<?> iface)", false);
        return iface.isInstance(this);
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.resultSetMetaData.getIsAutoIncrement(column);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        int colType = this.getColumnType(column);
        switch (colType) {
            case 1: 
            case 12: 
            case 2002: 
            case 2003: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        logger.trace("String getColumnClassName(int column)", false);
        int type = this.getColumnType(column);
        return SnowflakeType.javaTypeToClassName(type);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.resultSetMetaData.getColumnCount();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.resultSetMetaData.isSigned(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.resultSetMetaData.getColumnLabel(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.resultSetMetaData.getColumnName(column);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.resultSetMetaData.getPrecision(column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.resultSetMetaData.getScale(column);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        try {
            return this.resultSetMetaData.getColumnType(column);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLLoggedException(this.session, ex.getSqlState(), ex.getVendorCode(), ex.getCause(), ex.getParams());
        }
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        try {
            return this.resultSetMetaData.getColumnTypeName(column);
        }
        catch (SFException ex) {
            throw new SnowflakeSQLLoggedException(this.session, ex.getSqlState(), ex.getVendorCode(), ex.getCause(), ex.getParams());
        }
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.resultSetMetaData.isNullable(column);
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        if (this.queryType == QueryType.SYNC) {
            return this.resultSetMetaData.getCatalogName(column);
        }
        return "";
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        if (this.queryType == QueryType.SYNC) {
            return this.resultSetMetaData.getSchemaName(column);
        }
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (this.queryType == QueryType.SYNC) {
            return this.resultSetMetaData.getTableName(column);
        }
        return "";
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.resultSetMetaData.getColumnDisplaySize(column);
    }

    boolean isStructuredTypeColumn(int column) {
        return this.resultSetMetaData.isStructuredTypeColumn(column);
    }

    public static enum QueryType {
        ASYNC,
        SYNC;

    }
}

