/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ciba;

import java.net.URI;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ciba.AuthRequestID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ciba.CIBAErrorDelivery;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ciba.CIBATokenDelivery;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

public abstract class CIBAPushCallback
extends ProtectedResourceRequest {
    private final AuthRequestID authRequestID;

    public CIBAPushCallback(URI endpoint, BearerAccessToken accessToken, AuthRequestID authRequestID) {
        super(endpoint, accessToken);
        this.authRequestID = Objects.requireNonNull(authRequestID);
    }

    public abstract boolean indicatesSuccess();

    public AuthRequestID getAuthRequestID() {
        return this.authRequestID;
    }

    public CIBATokenDelivery toTokenDelivery() {
        return (CIBATokenDelivery)this;
    }

    public CIBAErrorDelivery toErrorDelivery() {
        return (CIBAErrorDelivery)this;
    }

    public static CIBAPushCallback parse(HTTPRequest httpRequest) throws ParseException {
        JSONObject jsonObject = httpRequest.getBodyAsJSONObject();
        if (jsonObject.containsKey("error")) {
            return CIBAErrorDelivery.parse(httpRequest);
        }
        return CIBATokenDelivery.parse(httpRequest);
    }
}

