/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.ResultRetryAlgorithm;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.UnaryCallable;
import net.snowflake.client.jdbc.internal.google.cloud.RestorableState;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Blob;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobInfo;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Conversions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.CopyWriter;
import net.snowflake.client.jdbc.internal.google.cloud.storage.CrossTransportUtils;
import net.snowflake.client.jdbc.internal.google.cloud.storage.GrpcStorageImpl;
import net.snowflake.client.jdbc.internal.google.cloud.storage.GrpcStorageOptions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Retrying;
import net.snowflake.client.jdbc.internal.google.storage.v2.RewriteObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.RewriteResponse;

final class GapicCopyWriter
extends CopyWriter {
    private final transient GrpcStorageImpl storage;
    private final GrpcStorageOptions options;
    private final UnaryCallable<RewriteObjectRequest, RewriteResponse> callable;
    private final ResultRetryAlgorithm<?> alg;
    private final RewriteResponse initialResponse;
    private RewriteResponse mostRecentResponse;

    GapicCopyWriter(GrpcStorageImpl storage, UnaryCallable<RewriteObjectRequest, RewriteResponse> callable, ResultRetryAlgorithm<?> alg, RewriteResponse initialResponse) {
        this.storage = storage;
        this.options = storage.getOptions();
        this.callable = callable;
        this.alg = alg;
        this.initialResponse = initialResponse;
        this.mostRecentResponse = initialResponse;
    }

    @Override
    public Blob getResult() {
        while (!this.isDone()) {
            this.copyChunk();
        }
        BlobInfo info = (BlobInfo)Conversions.grpc().blobInfo().decode(this.mostRecentResponse.getResource());
        return info.asBlob(this.storage);
    }

    @Override
    public long getBlobSize() {
        return this.initialResponse.getObjectSize();
    }

    @Override
    public boolean isDone() {
        return this.mostRecentResponse.getDone();
    }

    @Override
    public long getTotalBytesCopied() {
        return this.mostRecentResponse.getTotalBytesRewritten();
    }

    @Override
    public void copyChunk() {
        if (!this.isDone()) {
            RewriteObjectRequest req = RewriteObjectRequest.newBuilder().setRewriteToken(this.mostRecentResponse.getRewriteToken()).build();
            GrpcCallContext retryContext = Retrying.newCallContext();
            this.mostRecentResponse = (RewriteResponse)Retrying.run(this.options, this.alg, () -> this.callable.call(req, retryContext), Conversions.Decoder.identity());
        }
    }

    @Override
    public RestorableState<CopyWriter> capture() {
        return (RestorableState)CrossTransportUtils.throwHttpJsonOnly(CopyWriter.class, "capture");
    }
}

