/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.TimeZone;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.spark.snowflake.SnowflakeConnectorException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Conversions$ {
    public static final Conversions$ MODULE$ = new Conversions$();
    private static final String net$snowflake$spark$snowflake$Conversions$$PATTERN_TZLTZ = System.getProperty("java.version").startsWith("1.6.") ? "Z yyyy-MM-dd HH:mm:ss.SSS" : "XX yyyy-MM-dd HH:mm:ss.SSS";
    private static final String net$snowflake$spark$snowflake$Conversions$$PATTERN_NTZ = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String net$snowflake$spark$snowflake$Conversions$$PATTERN_DATE = "yyyy-MM-dd";
    private static final DateFormat snowflakeTimestampFormat = new DateFormat(){
        private final ThreadLocal<SimpleDateFormat> formatTzLtz;
        private final ThreadLocal<SimpleDateFormat> formatNtz;

        private ThreadLocal<SimpleDateFormat> formatTzLtz() {
            return this.formatTzLtz;
        }

        private ThreadLocal<SimpleDateFormat> formatNtz() {
            return this.formatNtz;
        }

        public StringBuffer format(java.util.Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            return this.formatTzLtz().get().format(date, toAppendTo, fieldPosition);
        }

        public java.util.Date parse(String source, ParsePosition pos) {
            int idx = pos.getIndex();
            int errIdx = pos.getErrorIndex();
            java.util.Date res = this.formatNtz().get().parse(source, pos);
            if (res == null) {
                pos.setIndex(idx);
                pos.setErrorIndex(errIdx);
                return this.formatTzLtz().get().parse(source, pos);
            }
            return res;
        }
        {
            this.formatTzLtz = new ThreadLocal<SimpleDateFormat>(null){

                public SimpleDateFormat initialValue() {
                    return new SimpleDateFormat(Conversions$.MODULE$.net$snowflake$spark$snowflake$Conversions$$PATTERN_TZLTZ());
                }
            };
            this.formatNtz = new ThreadLocal<SimpleDateFormat>(null){

                public SimpleDateFormat initialValue() {
                    return new SimpleDateFormat(Conversions$.MODULE$.net$snowflake$spark$snowflake$Conversions$$PATTERN_NTZ());
                }
            };
        }
    };
    private static final String PATTERN_WRITE_TZLTZ = "XX yyyy-MM-dd HH:mm:ss.SSSSSSSSS";
    private static final DateTimeFormatter timestampWriteFormatter = DateTimeFormatter.ofPattern(MODULE$.PATTERN_WRITE_TZLTZ());
    private static final ThreadLocal<SimpleDateFormat> snowflakeDateFormat = new ThreadLocal<SimpleDateFormat>(){

        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat(Conversions$.MODULE$.net$snowflake$spark$snowflake$Conversions$$PATTERN_DATE());
        }
    };
    private static final ThreadLocal<DecimalFormat> snowflakeDecimalFormat = new ThreadLocal<DecimalFormat>(){

        public DecimalFormat initialValue() {
            DecimalFormat df = new DecimalFormat();
            df.setParseBigDecimal(true);
            return df;
        }
    };

    public String net$snowflake$spark$snowflake$Conversions$$PATTERN_TZLTZ() {
        return net$snowflake$spark$snowflake$Conversions$$PATTERN_TZLTZ;
    }

    public String net$snowflake$spark$snowflake$Conversions$$PATTERN_NTZ() {
        return net$snowflake$spark$snowflake$Conversions$$PATTERN_NTZ;
    }

    public String net$snowflake$spark$snowflake$Conversions$$PATTERN_DATE() {
        return net$snowflake$spark$snowflake$Conversions$$PATTERN_DATE;
    }

    private DateFormat snowflakeTimestampFormat() {
        return snowflakeTimestampFormat;
    }

    private String PATTERN_WRITE_TZLTZ() {
        return PATTERN_WRITE_TZLTZ;
    }

    private DateTimeFormatter timestampWriteFormatter() {
        return timestampWriteFormatter;
    }

    private ThreadLocal<SimpleDateFormat> snowflakeDateFormat() {
        return snowflakeDateFormat;
    }

    private ThreadLocal<DecimalFormat> snowflakeDecimalFormat() {
        return snowflakeDecimalFormat;
    }

    public String formatDate(java.util.Date d) {
        return ((DateFormat)this.snowflakeDateFormat().get()).format(d);
    }

    public String formatTimestamp(Timestamp t) {
        return this.timestampWriteFormatter().format(ZonedDateTime.of(t.toLocalDateTime(), TimeZone.getDefault().toZoneId()));
    }

    public String formatString(String s) {
        return new StringBuilder(2).append("\"").append(s.replace("\"", "\"\"")).append("\"").toString();
    }

    public String formatAny(Object v) {
        if (v == null) {
            return "";
        }
        return v.toString();
    }

    public <T> Function1<String[], T> createRowConverter(StructType schema, ClassTag<T> evidence$1) {
        return (Function1 & Serializable)x$1 -> MODULE$.convertRow(schema, (String[])x$1, evidence$1);
    }

    private <T> T convertRow(StructType schema, String[] fields, ClassTag<T> evidence$2) {
        boolean isIR = this.isInternalRow(evidence$2);
        Object[] converted = (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (IterableOnce)schema)), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String data;
                String input = (String)tuple2._1();
                StructField field = (StructField)tuple2._2();
                String string = data = input == null && !field.nullable() ? "" : input;
                if (data == null) {
                    return null;
                }
                DataType dataType = field.dataType();
                if (ByteType$.MODULE$.equals(dataType)) {
                    return BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(data)));
                }
                if (BooleanType$.MODULE$.equals(dataType)) {
                    return BoxesRunTime.boxToBoolean((boolean)MODULE$.parseBoolean(data));
                }
                if (DateType$.MODULE$.equals(dataType)) {
                    return MODULE$.parseDate(data, isIR);
                }
                if (DoubleType$.MODULE$.equals(dataType)) {
                    return BoxesRunTime.boxToDouble((double)MODULE$.parseDouble(data));
                }
                if (FloatType$.MODULE$.equals(dataType)) {
                    return BoxesRunTime.boxToFloat((float)MODULE$.parseFloat(data));
                }
                if (dataType instanceof DecimalType) {
                    return MODULE$.parseDecimal(data, isIR);
                }
                if (IntegerType$.MODULE$.equals(dataType)) {
                    return BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(data)));
                }
                if (LongType$.MODULE$.equals(dataType)) {
                    return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(data)));
                }
                if (ShortType$.MODULE$.equals(dataType)) {
                    return BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(data)));
                }
                if (StringType$.MODULE$.equals(dataType)) {
                    if (isIR) {
                        return UTF8String.fromString((String)data);
                    }
                    return data;
                }
                if (TimestampType$.MODULE$.equals(dataType)) {
                    return MODULE$.parseTimestamp(data, isIR);
                }
                return data;
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.Any());
        if (isIR) {
            return (T)InternalRow$.MODULE$.fromSeq((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)converted));
        }
        return (T)Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)converted));
    }

    private Object parseTimestamp(String s, boolean isInternalRow) {
        Timestamp res = new Timestamp(this.snowflakeTimestampFormat().parse(s).getTime());
        if (isInternalRow) {
            return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(res));
        }
        return res;
    }

    private Object parseDate(String s, boolean isInternalRow) {
        Date d = new Date(((DateFormat)this.snowflakeDateFormat().get()).parse(s).getTime());
        if (isInternalRow) {
            return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(d));
        }
        return d;
    }

    private boolean parseBoolean(String s) {
        String string = s;
        String string2 = "true";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return true;
        }
        String string3 = s;
        String string4 = "false";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            return false;
        }
        throw new IllegalArgumentException(new StringBuilder(37).append("Expected 'true' or 'false' but got '").append(s).append("'").toString());
    }

    public Object parseDecimal(String s, boolean isInternalRow) {
        BigDecimal res = (BigDecimal)((NumberFormat)this.snowflakeDecimalFormat().get()).parse(s);
        if (isInternalRow) {
            return Decimal$.MODULE$.apply(res);
        }
        return res;
    }

    private double parseDouble(String s) {
        if (s.equalsIgnoreCase("inf")) {
            return Double.POSITIVE_INFINITY;
        }
        if (s.equalsIgnoreCase("-inf")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (s.equalsIgnoreCase("NaN")) {
            return Double.NaN;
        }
        return StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s));
    }

    private float parseFloat(String s) {
        if (s.equalsIgnoreCase("inf")) {
            return Float.POSITIVE_INFINITY;
        }
        if (s.equalsIgnoreCase("-inf")) {
            return Float.NEGATIVE_INFINITY;
        }
        if (s.equalsIgnoreCase("NaN")) {
            return Float.NaN;
        }
        return StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(s));
    }

    public <T> Object jsonStringToRow(JsonNode data, DataType dataType, ClassTag<T> evidence$3) {
        boolean isIR = this.isInternalRow(evidence$3);
        DataType dataType2 = dataType;
        if (ByteType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToByte((byte)((byte)data.asInt()));
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToBoolean((boolean)data.asBoolean());
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return this.parseDate(data.asText(), isIR);
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToDouble((double)data.asDouble());
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToFloat((float)((float)data.asDouble()));
        }
        if (dataType2 != null && DecimalType$.MODULE$.unapply(dataType2)) {
            return data.decimalValue();
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToInteger((int)data.asInt());
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToLong((long)data.asLong());
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToShort((short)data.shortValue());
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            if (isIR) {
                return UTF8String.fromString((String)data.asText());
            }
            return data.asText();
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return this.parseTimestamp(data.asText(), isIR);
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType dt = arrayType.elementType();
            Object[] result = new Object[data.size()];
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), data.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                result$1[i] = MODULE$.jsonStringToRow(data.get(i), dt, evidence$3);
            });
            if (isIR) {
                return new GenericArrayData(result);
            }
            return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps((Object)result));
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            Object[] converted = (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> {
                JsonNode value = data.findValue(field.name());
                if (value == null) {
                    if (field.nullable()) {
                        return null;
                    }
                    throw new IllegalArgumentException("data is not nullable");
                }
                return MODULE$.jsonStringToRow(value, field.dataType(), evidence$3);
            }, ClassTag$.MODULE$.Any());
            if (isIR) {
                return InternalRow$.MODULE$.fromSeq((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)converted));
            }
            return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)converted));
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType dt = mapType.valueType();
            Iterator keys = data.fieldNames();
            if (isIR) {
                Nil$ keyList = Nil$.MODULE$;
                Nil$ valueList = Nil$.MODULE$;
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    UTF8String uTF8String = UTF8String.fromString((String)key);
                    keyList = keyList.$colon$colon((Object)uTF8String);
                    Object object = this.jsonStringToRow(data.get(key), dt, evidence$3);
                    valueList = valueList.$colon$colon(object);
                }
                return new ArrayBasedMapData((ArrayData)new GenericArrayData(keyList.reverse().toArray(ClassTag$.MODULE$.apply(UTF8String.class))), (ArrayData)new GenericArrayData((Object[])valueList.reverse().toArray(ClassTag$.MODULE$.Any())));
            }
            HashMap result = HashMap$.MODULE$.empty();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                result.put((Object)key, this.jsonStringToRow(data.get(key), dt, evidence$3));
            }
            return result;
        }
        if (isIR) {
            return UTF8String.fromString((String)data.toString());
        }
        return data.toString();
    }

    public <U> boolean isInternalRow(ClassTag<U> evidence$4) {
        ClassTag row = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(Row.class));
        ClassTag internalRow = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(InternalRow.class));
        ClassTag classTag = (ClassTag)Predef$.MODULE$.implicitly(evidence$4);
        ClassTag classTag2 = row;
        ClassTag classTag3 = classTag;
        if (!(classTag2 != null ? !classTag2.equals(classTag3) : classTag3 != null)) {
            return false;
        }
        ClassTag classTag4 = internalRow;
        ClassTag classTag5 = classTag;
        if (!(classTag4 != null ? !classTag4.equals(classTag5) : classTag5 != null)) {
            return true;
        }
        throw new SnowflakeConnectorException("Wrong type for convertRow.");
    }

    private Conversions$() {
    }
}

