/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.spark.snowflake.ConnectionCacheKey;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.Parameters$;
import net.snowflake.spark.snowflake.ServerConnection;
import net.snowflake.spark.snowflake.ServerConnection$providedConnections$;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.TelemetryClientInfoFields$;
import net.snowflake.spark.snowflake.Utils$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ServerConnection$ {
    public static final ServerConnection$ MODULE$ = new ServerConnection$();
    private static final Logger log = LoggerFactory.getLogger(MODULE$.getClass());
    private static final AtomicLong serverConnectionCount = new AtomicLong();
    private static final AtomicLong jdbcConnectionCount = new AtomicLong();
    private static boolean supportSharingJDBCConnection = true;
    private static final Map<ConnectionCacheKey, Connection> cachedJdbcConnections = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

    private Logger log() {
        return log;
    }

    public AtomicLong serverConnectionCount() {
        return serverConnectionCount;
    }

    public AtomicLong jdbcConnectionCount() {
        return jdbcConnectionCount;
    }

    public boolean supportSharingJDBCConnection() {
        return supportSharingJDBCConnection;
    }

    public void supportSharingJDBCConnection_$eq(boolean x$1) {
        supportSharingJDBCConnection = x$1;
    }

    public void setSupportSharingJDBCConnection(boolean enabled) {
        this.supportSharingJDBCConnection_$eq(enabled);
    }

    public ServerConnection apply(Connection jdbcConnection, boolean enableCache) {
        return new ServerConnection(jdbcConnection, enableCache);
    }

    public ServerConnection apply(Connection jdbcConnection) {
        return new ServerConnection(jdbcConnection, true);
    }

    private Map<ConnectionCacheKey, Connection> cachedJdbcConnections() {
        return cachedJdbcConnections;
    }

    public synchronized void closeAllCachedConnections() {
        this.log().info(new StringBuilder(29).append("Close all ").append(this.cachedJdbcConnections().size()).append(" cached connection.").toString());
        this.cachedJdbcConnections().values().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        this.cachedJdbcConnections().clear();
    }

    public synchronized ServerConnection getServerConnection(Parameters.MergedParameters parameters, boolean useCache) {
        ServerConnection serverConnection;
        block7: {
            Tuple2 tuple2;
            Tuple2 tuple22;
            boolean enableCache;
            ConnectionCacheKey connectionCacheKey = new ConnectionCacheKey(parameters);
            boolean bl = enableCache = (useCache || parameters.getConnectionId().isDefined()) && connectionCacheKey.isConnectionCacheSupported();
            if (enableCache && this.cachedJdbcConnections().keySet().contains((Object)connectionCacheKey)) {
                tuple22 = new Tuple2(this.cachedJdbcConnections().apply((Object)connectionCacheKey), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            } else {
                Connection connection;
                Option<String> option = parameters.getConnectionId();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String connectionId = (String)some.value();
                    Connection snowparkConnection = (Connection)ServerConnection$providedConnections$.MODULE$.getConnection(connectionId).getOrElse((Function0 & Serializable)() -> {
                        throw new RuntimeException("Internal Error: Can't find the Snowpark Session");
                    });
                    this.log().debug("Reuse connection from Snowpark");
                    this.cachedJdbcConnections().put((Object)connectionCacheKey, (Object)snowparkConnection);
                    connection = snowparkConnection;
                } else {
                    BoxedUnit boxedUnit;
                    Connection createdJdbcConnection = this.createJDBCConnection(parameters);
                    if (enableCache) {
                        this.log().debug("Cache the new created JDBCConnection");
                        boxedUnit = this.cachedJdbcConnections().put((Object)connectionCacheKey, (Object)createdJdbcConnection);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    connection = createdJdbcConnection;
                }
                Connection newConnection = connection;
                tuple22 = tuple2 = new Tuple2((Object)newConnection, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Connection jdbcConnection = (Connection)tuple2._1();
            boolean newConnection = tuple2._2$mcZ$sp();
            Tuple2 tuple23 = new Tuple2((Object)jdbcConnection, (Object)BoxesRunTime.boxToBoolean((boolean)newConnection));
            Connection jdbcConnection2 = (Connection)tuple23._1();
            boolean newConnection2 = tuple23._2$mcZ$sp();
            serverConnection = this.apply(jdbcConnection2, enableCache);
            this.log().info(new StringBuilder(47).append("Create ServerConnection with ").append((Object)(newConnection2 ? "new" : "cached")).append(" JDBC connection: ").append(serverConnection.getSessionID()).toString());
            if (!newConnection2) break block7;
            scala.collection.immutable.Map extraValues = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TelemetryClientInfoFields$.MODULE$.SFURL()), (Object)parameters.sfURL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TelemetryClientInfoFields$.MODULE$.SHARED()), (Object)Boolean.toString(enableCache))}));
            SnowflakeTelemetry$.MODULE$.sendClientInfoTelemetry((scala.collection.immutable.Map<String, String>)extraValues, serverConnection);
        }
        return serverConnection;
    }

    public boolean getServerConnection$default$2() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Connection createJDBCConnection(Parameters.MergedParameters params) {
        Object object;
        String driverClassName = Utils$.MODULE$.JDBC_DRIVER();
        try {
            Class<?> driverClass = Utils$.MODULE$.classForName(driverClassName);
            DriverRegistry$.MODULE$.register(driverClass.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException(new StringBuilder(50).append("Could not load a Snowflake JDBC driver class < ").append(driverClassName).append(" > ").toString(), e);
        }
        String sfURL = params.sfURL();
        String jdbcURL = new StringBuilder(17).append("jdbc:snowflake://").append(sfURL).toString();
        Properties jdbcProperties = new Properties();
        jdbcProperties.put("db", params.sfDatabase());
        jdbcProperties.put("schema", params.sfSchema());
        Object object2 = params.sfUser() != null ? jdbcProperties.put("user", params.sfUser()) : BoxedUnit.UNIT;
        Option<PrivateKey> option = params.privateKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            PrivateKey privateKey = (PrivateKey)some.value();
            jdbcProperties.put("privateKey", privateKey);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            Option<String> option2 = params.sfToken();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String value = (String)some.value();
                jdbcProperties.put("token", value);
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                jdbcProperties.put("password", params.sfPassword());
            }
        }
        jdbcProperties.put("ssl", params.sfSSL());
        Object object5 = params.sfAccount().isDefined() ? jdbcProperties.put("account", params.sfAccount().get()) : BoxedUnit.UNIT;
        object5 = params.sfWarehouse().isDefined() ? jdbcProperties.put("warehouse", params.sfWarehouse().get()) : BoxedUnit.UNIT;
        object5 = params.sfRole().isDefined() ? jdbcProperties.put("role", params.sfRole().get()) : BoxedUnit.UNIT;
        Option<String> option3 = params.getTimeOutputFormat();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            String value = (String)some.value();
            jdbcProperties.put(Parameters$.MODULE$.PARAM_TIME_OUTPUT_FORMAT(), value);
        }
        Option<String> option4 = params.getQueryResultFormat();
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            String value = (String)some.value();
            jdbcProperties.put(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT(), value);
        }
        params.setJDBCProxyIfNecessary(jdbcProperties);
        Option<String> option5 = params.sfAuthenticator();
        if (option5 instanceof Some) {
            Some some = (Some)option5;
            String value = (String)some.value();
            jdbcProperties.put("authenticator", value);
        }
        jdbcProperties.put("client_session_keep_alive", "true");
        Object object6 = params.treatDecimalAsLong() ? jdbcProperties.put("JDBC_TREAT_DECIMAL_AS_INT", "true") : jdbcProperties.put("JDBC_TREAT_DECIMAL_AS_INT", "false");
        scala.collection.immutable.Map<String, Object> extraOptions = params.sfExtraOptions();
        extraOptions.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ServerConnection$.$anonfun$createJDBCConnection$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                if (k != null) {
                    String string = k;
                    if (v != null) {
                        Object object = v;
                        return jdbcProperties.put(string.toLowerCase(), object.toString());
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (!Utils$.MODULE$.CERTIFIED_JDBC_VERSION().equals(Utils$.MODULE$.jdbcVersion())) {
            this.log().warn(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(107).append("JDBC ").append(Utils$.MODULE$.jdbcVersion()).append(" is being used.\n           | But the certified JDBC version\n           | ").append(Utils$.MODULE$.CERTIFIED_JDBC_VERSION()).append(" is recommended.\n           |").toString()))), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ServerConnection$.$anonfun$createJDBCConnection$3(BoxesRunTime.unboxToChar((Object)x$4)))));
        }
        jdbcProperties.put(SFSessionProperty.CLIENT_INFO.getPropertyKey(), Utils$.MODULE$.getClientInfoString());
        Connection conn = DriverManager.getConnection(jdbcURL, jdbcProperties);
        if (jdbcProperties.getProperty(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT()) != null) {
            try {
                String resultFormat = jdbcProperties.getProperty(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT());
                object = BoxesRunTime.boxToBoolean((boolean)conn.createStatement().execute(new StringBuilder(47).append("alter session set JDBC_QUERY_RESULT_FORMAT = '").append(resultFormat).append("'").toString()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SQLException) {
                    SQLException sQLException = (SQLException)throwable2;
                    this.log().info(sQLException.getMessage());
                    object = BoxedUnit.UNIT;
                }
                if (throwable2 == null) throw throwable;
                Throwable throwable3 = throwable2;
                throw throwable3;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        conn.createStatement().execute(new StringBuilder(41).append("alter session set ABORT_DETACHED_QUERY = ").append(params.abortDetachedQuery()).toString());
        Object object7 = params.supportAWSStageEndPoint() ? params.getS3StageVpceDnsName().map((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ServerConnection$.$anonfun$createJDBCConnection$4(conn, x))) : BoxedUnit.UNIT;
        this.jdbcConnectionCount().incrementAndGet();
        return conn;
    }

    public static final /* synthetic */ boolean $anonfun$createJDBCConnection$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            if (k != null && v != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$createJDBCConnection$3(char x$4) {
        return x$4 >= ' ';
    }

    public static final /* synthetic */ boolean $anonfun$createJDBCConnection$4(Connection conn$1, String x) {
        return conn$1.createStatement().execute(new StringBuilder(45).append("alter session set S3_STAGE_VPCE_DNS_NAME = '").append(x).append("'").toString());
    }

    private ServerConnection$() {
    }
}

