/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.PMD;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;

public class SourceCode {
    private CodeLoader cl;

    public SourceCode(CodeLoader cl) {
        this.cl = cl;
    }

    public List<String> getCode() {
        return this.cl.getCode();
    }

    public StringBuilder getCodeBuffer() {
        StringBuilder sb = new StringBuilder();
        List<String> lines = this.cl.getCode();
        for (String line : lines) {
            sb.append(line).append(PMD.EOL);
        }
        return sb;
    }

    public String getSlice(int startLine, int endLine) {
        int i;
        StringBuilder sb = new StringBuilder();
        List<String> lines = this.cl.getCode();
        int n = i = startLine == 0 ? startLine : startLine - 1;
        while (i < endLine && i < lines.size()) {
            if (sb.length() != 0) {
                sb.append(PMD.EOL);
            }
            sb.append(lines.get(i));
            ++i;
        }
        return sb.toString();
    }

    public String getFileName() {
        return this.cl.getFileName();
    }

    public static class ReaderCodeLoader
    extends CodeLoader {
        public static final String DEFAULT_NAME = "CODE_LOADED_FROM_READER";
        private Reader code;
        private String name;

        public ReaderCodeLoader(Reader code) {
            this(code, DEFAULT_NAME);
        }

        public ReaderCodeLoader(Reader code, String name) {
            this.code = code;
            this.name = name;
        }

        @Override
        public Reader getReader() {
            return this.code;
        }

        @Override
        public String getFileName() {
            return this.name;
        }
    }

    public static class StringCodeLoader
    extends CodeLoader {
        public static final String DEFAULT_NAME = "CODE_LOADED_FROM_STRING";
        private String code;
        private String name;

        public StringCodeLoader(String code) {
            this(code, DEFAULT_NAME);
        }

        public StringCodeLoader(String code, String name) {
            this.code = code;
            this.name = name;
        }

        @Override
        public Reader getReader() {
            return new StringReader(this.code);
        }

        @Override
        public String getFileName() {
            return this.name;
        }
    }

    public static class FileCodeLoader
    extends CodeLoader {
        private File file;
        private String encoding;

        public FileCodeLoader(File file, String encoding) {
            this.file = file;
            this.encoding = encoding;
        }

        @Override
        public Reader getReader() throws Exception {
            BOMInputStream inputStream = new BOMInputStream((InputStream)new FileInputStream(this.file), new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE});
            if (inputStream.hasBOM()) {
                this.encoding = inputStream.getBOMCharsetName();
            }
            return new InputStreamReader((InputStream)inputStream, this.encoding);
        }

        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public String getFileName() {
            return this.file.getAbsolutePath();
        }
    }

    public static abstract class CodeLoader {
        private SoftReference<List<String>> code;

        public List<String> getCode() {
            List<String> c = null;
            if (this.code != null) {
                c = this.code.get();
            }
            if (c != null) {
                return c;
            }
            this.code = new SoftReference<List<String>>(this.load());
            return this.code.get();
        }

        public abstract String getFileName();

        protected abstract Reader getReader() throws Exception;

        protected List<String> load() {
            ArrayList<String> arrayList;
            LineNumberReader lnr = null;
            try {
                String currentLine;
                lnr = new LineNumberReader(this.getReader());
                ArrayList<String> lines = new ArrayList<String>();
                while ((currentLine = lnr.readLine()) != null) {
                    lines.add(currentLine);
                }
                arrayList = lines;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    throw new RuntimeException("Problem while reading " + this.getFileName() + ":" + e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(lnr);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)lnr);
            return arrayList;
        }
    }
}

