/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dcd.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.dcd.graph.ClassNode;
import net.sourceforge.pmd.dcd.graph.ClassNodeComparator;
import net.sourceforge.pmd.dcd.graph.FieldNode;
import net.sourceforge.pmd.dcd.graph.MemberNode;
import net.sourceforge.pmd.dcd.graph.NodeVisitor;
import net.sourceforge.pmd.dcd.graph.NodeVisitorAcceptor;
import net.sourceforge.pmd.util.filter.Filter;

public class UsageGraph
implements NodeVisitorAcceptor {
    private final List<ClassNode> classNodes = new ArrayList<ClassNode>();
    protected final Filter<String> classFilter;

    public UsageGraph(Filter<String> classFilter) {
        this.classFilter = classFilter;
    }

    @Override
    public Object accept(NodeVisitor visitor, Object data) {
        for (ClassNode classNode : this.classNodes) {
            visitor.visit(classNode, data);
        }
        return data;
    }

    public boolean isClass(String className) {
        this.checkClassName(className);
        return Collections.binarySearch(this.classNodes, className, ClassNodeComparator.INSTANCE) >= 0;
    }

    public ClassNode defineClass(String className) {
        ClassNode classNode;
        this.checkClassName(className);
        int index = Collections.binarySearch(this.classNodes, className, ClassNodeComparator.INSTANCE);
        if (index >= 0) {
            classNode = this.classNodes.get(index);
        } else {
            classNode = new ClassNode(className);
            this.classNodes.add(-(index + 1), classNode);
        }
        return classNode;
    }

    public FieldNode defineField(String className, String name, String desc) {
        ClassNode classNode = this.defineClass(className);
        return classNode.defineField(name, desc);
    }

    public MemberNode defineConstructor(String className, String name, String desc) {
        ClassNode classNode = this.defineClass(className);
        return classNode.defineConstructor(name, desc);
    }

    public MemberNode defineMethod(String className, String name, String desc) {
        ClassNode classNode = this.defineClass(className);
        if ("<clinit>".equals(name) || "<init>".equals(name)) {
            return classNode.defineConstructor(name, desc);
        }
        return classNode.defineMethod(name, desc);
    }

    public void usageField(String className, String name, String desc, MemberNode usingMemberNode) {
        this.checkClassName(className);
        if (this.classFilter.filter(className)) {
            FieldNode fieldNode = this.defineField(className, name, desc);
            this.usage(fieldNode, usingMemberNode);
        }
    }

    public void usageMethod(String className, String name, String desc, MemberNode usingMemberNode) {
        this.checkClassName(className);
        if (this.classFilter.filter(className)) {
            MemberNode memberNode = "<clinit>".equals(name) || "<init>".equals(name) ? this.defineConstructor(className, name, desc) : this.defineMethod(className, name, desc);
            this.usage(memberNode, usingMemberNode);
        }
    }

    private void usage(MemberNode use, MemberNode user) {
        use.addUser(user);
        user.addUse(use);
    }

    private final void checkClassName(String className) {
        if (className.indexOf(47) >= 0 || className.indexOf(92) >= 0) {
            throw new IllegalArgumentException("Invalid class name: " + className);
        }
    }
}

