/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;

public final class LanguageRegistry {
    private static LanguageRegistry instance = new LanguageRegistry();
    private Map<String, Language> languages = new LinkedHashMap<String, Language>();

    private LanguageRegistry() {
        ServiceLoader<Language> languageLoader = ServiceLoader.load(Language.class);
        Iterator<Language> iterator = languageLoader.iterator();
        while (iterator.hasNext()) {
            try {
                Language language = iterator.next();
                this.languages.put(language.getName(), language);
            }
            catch (UnsupportedClassVersionError e) {
                System.err.println("Ignoring language for PMD: " + e.toString());
            }
        }
    }

    public static LanguageRegistry getInstance() {
        return instance;
    }

    public static Collection<Language> getLanguages() {
        return LanguageRegistry.getInstance().languages.values();
    }

    public static Language getLanguage(String languageName) {
        return LanguageRegistry.getInstance().languages.get(languageName);
    }

    public static Language getDefaultLanguage() {
        Collection<Language> allLanguages;
        Language defaultLanguage = LanguageRegistry.getLanguage("Java");
        if (defaultLanguage == null && !(allLanguages = LanguageRegistry.getInstance().languages.values()).isEmpty()) {
            defaultLanguage = allLanguages.iterator().next();
        }
        return defaultLanguage;
    }

    public static Language findLanguageByTerseName(String terseName) {
        for (Language language : LanguageRegistry.getInstance().languages.values()) {
            if (!language.getTerseName().equals(terseName)) continue;
            return language;
        }
        return null;
    }

    public static LanguageVersion findLanguageVersionByTerseName(String terseNameAndVersion) {
        String terseName;
        String version;
        if (terseNameAndVersion.contains(" ")) {
            version = terseNameAndVersion.substring(terseNameAndVersion.lastIndexOf(32) + 1);
            terseName = terseNameAndVersion.substring(0, terseNameAndVersion.lastIndexOf(32));
        } else {
            version = null;
            terseName = terseNameAndVersion;
        }
        Language language = LanguageRegistry.findLanguageByTerseName(terseName);
        if (language != null) {
            if (version == null) {
                return language.getDefaultVersion();
            }
            return language.getVersion(version);
        }
        return null;
    }

    public static List<Language> findByExtension(String extension) {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (Language language : LanguageRegistry.getInstance().languages.values()) {
            if (!language.hasExtension(extension)) continue;
            languages.add(language);
        }
        return languages;
    }

    public static List<LanguageVersion> findAllVersions() {
        ArrayList<LanguageVersion> versions = new ArrayList<LanguageVersion>();
        for (Language language : LanguageRegistry.getLanguages()) {
            for (LanguageVersion languageVersion : language.getVersions()) {
                versions.add(languageVersion);
            }
        }
        return versions;
    }

    public static List<Language> findWithRuleSupport() {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (Language language : LanguageRegistry.getInstance().languages.values()) {
            if (language.getRuleChainVisitorClass() == null) continue;
            languages.add(language);
        }
        return languages;
    }

    public static String commaSeparatedTerseNamesForLanguage(List<Language> languages) {
        StringBuilder builder = new StringBuilder();
        for (Language language : languages) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(language.getTerseName());
        }
        return builder.toString();
    }

    public static String commaSeparatedTerseNamesForLanguageVersion(List<LanguageVersion> languageVersions) {
        if (languageVersions == null || languageVersions.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(languageVersions.get(0).getTerseName());
        for (int i = 1; i < languageVersions.size(); ++i) {
            builder.append(", ").append(languageVersions.get(i).getTerseName());
        }
        return builder.toString();
    }
}

