/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.symboltable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;

public abstract class AbstractScope
implements Scope {
    private Scope parent;
    private Map<Class<? extends NameDeclaration>, Map<NameDeclaration, List<NameOccurrence>>> nameDeclarations = new LinkedHashMap<Class<? extends NameDeclaration>, Map<NameDeclaration, List<NameOccurrence>>>();

    @Override
    public Scope getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Scope parent) {
        this.parent = parent;
    }

    @Override
    public Map<NameDeclaration, List<NameOccurrence>> getDeclarations() {
        LinkedHashMap<NameDeclaration, List<NameOccurrence>> result = new LinkedHashMap<NameDeclaration, List<NameOccurrence>>();
        for (Map<NameDeclaration, List<NameOccurrence>> e : this.nameDeclarations.values()) {
            result.putAll(e);
        }
        return result;
    }

    @Override
    public <T extends NameDeclaration> Map<T, List<NameOccurrence>> getDeclarations(Class<T> clazz) {
        Map<NameDeclaration, List<NameOccurrence>> result = this.nameDeclarations.get(clazz);
        if (result == null) {
            result = new LinkedHashMap<NameDeclaration, List<NameOccurrence>>();
        }
        return result;
    }

    @Override
    public boolean contains(NameOccurrence occ) {
        for (NameDeclaration d : this.getDeclarations().keySet()) {
            if (!d.getImage().equals(occ.getImage())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addDeclaration(NameDeclaration declaration) {
        Map<NameDeclaration, List<NameOccurrence>> declarationsPerClass = this.nameDeclarations.get(declaration.getClass());
        if (declarationsPerClass == null) {
            declarationsPerClass = new LinkedHashMap<NameDeclaration, List<NameOccurrence>>();
            this.nameDeclarations.put(declaration.getClass(), declarationsPerClass);
        }
        declarationsPerClass.put(declaration, new ArrayList());
    }

    @Override
    public <T extends Scope> T getEnclosingScope(Class<T> clazz) {
        AbstractScope result = null;
        for (Scope current = this; result == null && current != null; current = current.getParent()) {
            AbstractScope cast;
            if (!clazz.isAssignableFrom(current.getClass())) continue;
            result = cast = current;
        }
        return (T)result;
    }

    @Override
    public Set<NameDeclaration> addNameOccurrence(NameOccurrence occurrence) {
        HashSet<NameDeclaration> result = new HashSet<NameDeclaration>();
        for (Map.Entry<NameDeclaration, List<NameOccurrence>> e : this.getDeclarations().entrySet()) {
            if (!e.getKey().getImage().equals(occurrence.getImage())) continue;
            result.add(e.getKey());
            e.getValue().add(occurrence);
        }
        return result;
    }
}

