/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.benchmark;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SourceCodeProcessor;
import net.sourceforge.pmd.benchmark.Benchmark;
import net.sourceforge.pmd.benchmark.BenchmarkResult;
import net.sourceforge.pmd.benchmark.RuleDuration;
import net.sourceforge.pmd.benchmark.TextReport;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageFilenameFilter;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.util.FileUtil;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.datasource.DataSource;
import org.apache.commons.io.IOUtils;

public class Benchmarker {
    private static final Map<String, BenchmarkResult> BENCHMARKS_BY_NAME = new HashMap<String, BenchmarkResult>();

    private Benchmarker() {
    }

    private static boolean findBooleanSwitch(String[] args, String name) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    private static String findOptionalStringValue(String[] args, String name, String defaultValue) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(name)) continue;
            return args[i + 1];
        }
        return defaultValue;
    }

    public static void main(String[] args) throws RuleSetNotFoundException, IOException, PMDException {
        String targetjdk = Benchmarker.findOptionalStringValue(args, "--targetjdk", "1.4");
        Language language = LanguageRegistry.getLanguage("Java");
        LanguageVersion languageVersion = language.getVersion(targetjdk);
        if (languageVersion == null) {
            languageVersion = language.getDefaultVersion();
        }
        String srcDir = Benchmarker.findOptionalStringValue(args, "--source-directory", "/usr/local/java/src/java/lang/");
        List<DataSource> dataSources = FileUtil.collectFiles(srcDir, new LanguageFilenameFilter(language));
        boolean debug = Benchmarker.findBooleanSwitch(args, "--debug");
        boolean parseOnly = Benchmarker.findBooleanSwitch(args, "--parse-only");
        if (debug) {
            System.out.println("Using " + language.getName() + " " + languageVersion.getVersion());
        }
        if (parseOnly) {
            Parser parser = PMD.parserFor(languageVersion, null);
            Benchmarker.parseStress(parser, dataSources, debug);
        } else {
            String ruleset = Benchmarker.findOptionalStringValue(args, "--ruleset", "");
            if (debug) {
                System.out.println("Checking directory " + srcDir);
            }
            TreeSet<RuleDuration> results = new TreeSet<RuleDuration>();
            RuleSetFactory factory = new RuleSetFactory();
            if (StringUtil.isNotEmpty(ruleset)) {
                Benchmarker.stress(languageVersion, factory.createRuleSet(ruleset), dataSources, results, debug);
            } else {
                Iterator<RuleSet> i = factory.getRegisteredRuleSets();
                while (i.hasNext()) {
                    Benchmarker.stress(languageVersion, i.next(), dataSources, results, debug);
                }
            }
            TextReport report = new TextReport();
            report.generate(results, System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseStress(Parser parser, List<DataSource> dataSources, boolean debug) throws IOException {
        long start = System.currentTimeMillis();
        for (DataSource dataSource : dataSources) {
            InputStreamReader reader = new InputStreamReader(dataSource.getInputStream());
            try {
                parser.parse(dataSource.getNiceFileName(false, null), reader);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        if (debug) {
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            System.out.println("That took " + elapsed + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stress(LanguageVersion languageVersion, RuleSet ruleSet, List<DataSource> dataSources, Set<RuleDuration> results, boolean debug) throws PMDException, IOException {
        RuleSetFactory factory = new RuleSetFactory();
        for (Rule rule : ruleSet.getRules()) {
            if (debug) {
                System.out.println("Starting " + rule.getName());
            }
            RuleSet working = factory.createSingleRuleRuleSet(rule);
            RuleSets ruleSets = new RuleSets(working);
            PMDConfiguration config = new PMDConfiguration();
            config.setDefaultLanguageVersion(languageVersion);
            RuleContext ctx = new RuleContext();
            long start = System.currentTimeMillis();
            for (DataSource dataSource : dataSources) {
                InputStreamReader reader = new InputStreamReader(dataSource.getInputStream());
                try {
                    ctx.setSourceCodeFilename(dataSource.getNiceFileName(false, null));
                    new SourceCodeProcessor(config).processSourceCode(reader, ruleSets, ctx);
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            results.add(new RuleDuration(elapsed, rule));
            if (!debug) continue;
            System.out.println("Done timing " + rule.getName() + "; elapsed time was " + elapsed);
        }
    }

    public static void mark(Benchmark type, long time, long count) {
        Benchmarker.mark(type, null, time, count);
    }

    public static synchronized void mark(Benchmark type, String name, long time, long count) {
        BenchmarkResult benchmarkResult;
        String typeName = type.name;
        if (typeName != null && name != null) {
            throw new IllegalArgumentException("Name cannot be given for type: " + (Object)((Object)type));
        }
        if (typeName == null && name == null) {
            throw new IllegalArgumentException("Name is required for type: " + (Object)((Object)type));
        }
        if (typeName == null) {
            typeName = name;
        }
        if ((benchmarkResult = BENCHMARKS_BY_NAME.get(typeName)) == null) {
            benchmarkResult = new BenchmarkResult(type, typeName);
            BENCHMARKS_BY_NAME.put(typeName, benchmarkResult);
        }
        benchmarkResult.update(time, count);
    }

    public static void reset() {
        BENCHMARKS_BY_NAME.clear();
    }

    public static Map<String, BenchmarkResult> values() {
        return BENCHMARKS_BY_NAME;
    }
}

