/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.util.filter.Filters;

public abstract class AbstractLanguage
implements Language {
    private final String name;
    private final String terseName;
    private final Tokenizer tokenizer;
    private final FilenameFilter fileFilter;
    private final List<String> extensions;

    public AbstractLanguage(String name, String terseName, Tokenizer tokenizer, String ... extensions) {
        this.name = name;
        this.terseName = terseName;
        this.tokenizer = tokenizer;
        this.fileFilter = Filters.toFilenameFilter(Filters.getFileExtensionOrDirectoryFilter(extensions));
        this.extensions = Arrays.asList(extensions);
    }

    @Override
    public FilenameFilter getFileFilter() {
        return this.fileFilter;
    }

    @Override
    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTerseName() {
        return this.terseName;
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }
}

