/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.CodeClimateRenderer;
import net.sourceforge.pmd.renderers.EmacsRenderer;
import net.sourceforge.pmd.renderers.EmptyRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.IDEAJRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.SummaryHTMLRenderer;
import net.sourceforge.pmd.renderers.TextColorRenderer;
import net.sourceforge.pmd.renderers.TextPadRenderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.VBHTMLRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import net.sourceforge.pmd.renderers.XSLTRenderer;
import net.sourceforge.pmd.renderers.YAHTMLRenderer;

public final class RendererFactory {
    private static final Logger LOG = Logger.getLogger(RendererFactory.class.getName());
    public static final Map<String, Class<? extends Renderer>> REPORT_FORMAT_TO_RENDERER;

    private RendererFactory() {
    }

    public static Renderer createRenderer(String reportFormat, Properties properties) {
        Renderer renderer;
        Class<? extends Renderer> rendererClass = RendererFactory.getRendererClass(reportFormat);
        Constructor<? extends Renderer> constructor = RendererFactory.getRendererConstructor(rendererClass);
        try {
            if (constructor.getParameterTypes().length > 0) {
                LOG.warning("The renderer uses a deprecated mechanism to use the properties. Please define the needed properties with this.definePropertyDescriptor(..).");
                renderer = constructor.newInstance(properties);
            } else {
                renderer = constructor.newInstance(new Object[0]);
                for (PropertyDescriptor<?> prop : renderer.getPropertyDescriptors()) {
                    String value = properties.getProperty(prop.name());
                    if (value == null) continue;
                    PropertyDescriptor<?> prop2 = prop;
                    Object valueFrom = prop2.valueFrom(value);
                    renderer.setProperty(prop2, valueFrom);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Unable to construct report renderer class: " + e.getLocalizedMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to construct report renderer class: " + e.getTargetException().getLocalizedMessage(), e);
        }
        if (REPORT_FORMAT_TO_RENDERER.containsKey(reportFormat) && !reportFormat.equals(renderer.getName()) && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Report format '" + reportFormat + "' is deprecated, and has been replaced with '" + renderer.getName() + "'. Future versions of PMD will remove support for this deprecated Report format usage.");
        }
        return renderer;
    }

    private static Class<? extends Renderer> getRendererClass(String reportFormat) {
        Class<Renderer> rendererClass = REPORT_FORMAT_TO_RENDERER.get(reportFormat);
        if (rendererClass == null && !"".equals(reportFormat)) {
            try {
                Class<?> clazz = Class.forName(reportFormat);
                if (!Renderer.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("Custom report renderer class does not implement the " + Renderer.class.getName() + " interface.");
                }
                rendererClass = clazz;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Can't find the custom format " + reportFormat + ": " + e);
            }
        }
        return rendererClass;
    }

    private static Constructor<? extends Renderer> getRendererConstructor(Class<? extends Renderer> rendererClass) {
        Constructor<? extends Renderer> constructor = null;
        try {
            constructor = rendererClass.getConstructor(Properties.class);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                constructor = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            constructor = rendererClass.getConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                constructor = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (constructor == null) {
            throw new IllegalArgumentException("Unable to find either a public java.util.Properties or no-arg constructors for Renderer class: " + rendererClass.getName());
        }
        return constructor;
    }

    static {
        TreeMap<String, Class> map = new TreeMap<String, Class>();
        map.put("codeclimate", CodeClimateRenderer.class);
        map.put("xml", XMLRenderer.class);
        map.put("ideaj", IDEAJRenderer.class);
        map.put("textcolor", TextColorRenderer.class);
        map.put("text", TextRenderer.class);
        map.put("textpad", TextPadRenderer.class);
        map.put("emacs", EmacsRenderer.class);
        map.put("csv", CSVRenderer.class);
        map.put("html", HTMLRenderer.class);
        map.put("xslt", XSLTRenderer.class);
        map.put("yahtml", YAHTMLRenderer.class);
        map.put("summaryhtml", SummaryHTMLRenderer.class);
        map.put("vbhtml", VBHTMLRenderer.class);
        map.put("empty", EmptyRenderer.class);
        REPORT_FORMAT_TO_RENDERER = Collections.unmodifiableMap(map);
    }
}

