/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;

public class TextRenderer
extends AbstractIncrementingRenderer {
    public static final String NAME = "text";

    public TextRenderer() {
        super(NAME, "Text format.");
    }

    @Override
    public String defaultFileExtension() {
        return "txt";
    }

    @Override
    public void renderFileViolations(Iterator<RuleViolation> violations) throws IOException {
        Writer writer = this.getWriter();
        StringBuilder buf = new StringBuilder();
        while (violations.hasNext()) {
            buf.setLength(0);
            RuleViolation rv = violations.next();
            buf.append(rv.getFilename());
            buf.append(':').append(Integer.toString(rv.getBeginLine()));
            buf.append(":\t").append(rv.getDescription()).append(PMD.EOL);
            writer.write(buf.toString());
        }
    }

    @Override
    public void end() throws IOException {
        Writer writer = this.getWriter();
        StringBuilder buf = new StringBuilder(500);
        for (Object error : this.errors) {
            buf.setLength(0);
            buf.append(((Report.ProcessingError)error).getFile());
            buf.append("\t-\t").append(((Report.ProcessingError)error).getMsg()).append(PMD.EOL);
            writer.write(buf.toString());
        }
        for (Report.SuppressedViolation excluded : this.suppressed) {
            buf.setLength(0);
            buf.append(excluded.getRuleViolation().getRule().getName());
            buf.append(" rule violation suppressed by ");
            buf.append(excluded.suppressedByNOPMD() ? "//NOPMD" : "Annotation");
            buf.append(" in ").append(excluded.getRuleViolation().getFilename()).append(PMD.EOL);
            writer.write(buf.toString());
        }
        for (Object error : this.configErrors) {
            buf.setLength(0);
            buf.append(((Report.ConfigurationError)error).rule().getName());
            buf.append("\t-\t").append(((Report.ConfigurationError)error).issue()).append(PMD.EOL);
            writer.write(buf.toString());
        }
    }
}

