/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetReference;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.rule.ImmutableLanguage;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptorField;
import net.sourceforge.pmd.properties.PropertyTypeId;
import net.sourceforge.pmd.util.IOUtil;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class RuleSetWriter {
    private static final Logger LOG = Logger.getLogger(RuleSetWriter.class.getName());
    public static final String RULESET_2_0_0_NS_URI = "http://pmd.sourceforge.net/ruleset/2.0.0";
    @Deprecated
    public static final String RULESET_NS_URI = "http://pmd.sourceforge.net/ruleset/2.0.0";
    private final OutputStream outputStream;
    private Document document;
    private Set<String> ruleSetFileNames;

    public RuleSetWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void close() {
        IOUtil.closeQuietly(this.outputStream);
    }

    public void write(RuleSet ruleSet) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = documentBuilder.newDocument();
            this.ruleSetFileNames = new HashSet<String>();
            Element ruleSetElement = this.createRuleSetElement(ruleSet);
            this.document.appendChild(ruleSetElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", 3);
            }
            catch (IllegalArgumentException iae) {
                LOG.log(Level.FINE, "Couldn't set indentation", iae);
            }
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(this.document), new StreamResult(this.outputStream));
        }
        catch (FactoryConfigurationError | ParserConfigurationException | TransformerException | DOMException e) {
            throw new RuntimeException(e);
        }
    }

    private Element createRuleSetElement(RuleSet ruleSet) {
        Element ruleSetElement = this.document.createElementNS("http://pmd.sourceforge.net/ruleset/2.0.0", "ruleset");
        ruleSetElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        ruleSetElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://pmd.sourceforge.net/ruleset/2.0.0 https://pmd.sourceforge.io/ruleset_2_0_0.xsd");
        ruleSetElement.setAttribute("name", ruleSet.getName());
        Element descriptionElement = this.createDescriptionElement(ruleSet.getDescription());
        ruleSetElement.appendChild(descriptionElement);
        for (String excludePattern : ruleSet.getExcludePatterns()) {
            Element excludePatternElement = this.createExcludePatternElement(excludePattern);
            ruleSetElement.appendChild(excludePatternElement);
        }
        for (String includePattern : ruleSet.getIncludePatterns()) {
            Element includePatternElement = this.createIncludePatternElement(includePattern);
            ruleSetElement.appendChild(includePatternElement);
        }
        for (Rule rule : ruleSet.getRules()) {
            Element ruleElement = this.createRuleElement(rule);
            if (ruleElement == null) continue;
            ruleSetElement.appendChild(ruleElement);
        }
        return ruleSetElement;
    }

    private Element createDescriptionElement(String description) {
        return this.createTextElement("description", description);
    }

    private Element createExcludePatternElement(String excludePattern) {
        return this.createTextElement("exclude-pattern", excludePattern);
    }

    private Element createIncludePatternElement(String includePattern) {
        return this.createTextElement("include-pattern", includePattern);
    }

    private Element createRuleElement() {
        return this.document.createElementNS("http://pmd.sourceforge.net/ruleset/2.0.0", "rule");
    }

    private Element createExcludeElement(String exclude) {
        Element element = this.document.createElementNS("http://pmd.sourceforge.net/ruleset/2.0.0", "exclude");
        element.setAttribute("name", exclude);
        return element;
    }

    private Element createExampleElement(String example) {
        return this.createCDATASectionElement("example", example);
    }

    private Element createPriorityElement(RulePriority priority) {
        return this.createTextElement("priority", String.valueOf(priority.getPriority()));
    }

    private Element createPropertiesElement() {
        return this.document.createElementNS("http://pmd.sourceforge.net/ruleset/2.0.0", "properties");
    }

    private Element createRuleElement(Rule rule) {
        if (rule instanceof RuleReference) {
            RuleReference ruleReference = (RuleReference)rule;
            RuleSetReference ruleSetReference = ruleReference.getRuleSetReference();
            if (ruleSetReference.isAllRules()) {
                if (!this.ruleSetFileNames.contains(ruleSetReference.getRuleSetFileName())) {
                    this.ruleSetFileNames.add(ruleSetReference.getRuleSetFileName());
                    return this.createRuleSetReferenceElement(ruleSetReference);
                }
                return null;
            }
            Language language = ruleReference.getOverriddenLanguage();
            LanguageVersion minimumLanguageVersion = ruleReference.getOverriddenMinimumLanguageVersion();
            LanguageVersion maximumLanguageVersion = ruleReference.getOverriddenMaximumLanguageVersion();
            Boolean deprecated = ruleReference.isOverriddenDeprecated();
            String name = ruleReference.getOverriddenName();
            String ref = ruleReference.getRuleSetReference().getRuleSetFileName() + '/' + ruleReference.getRule().getName();
            String message = ruleReference.getOverriddenMessage();
            String externalInfoUrl = ruleReference.getOverriddenExternalInfoUrl();
            String description = ruleReference.getOverriddenDescription();
            RulePriority priority = ruleReference.getOverriddenPriority();
            List<PropertyDescriptor<?>> propertyDescriptors = ruleReference.getOverriddenPropertyDescriptors();
            Map<PropertyDescriptor<?>, Object> propertiesByPropertyDescriptor = ruleReference.getOverriddenPropertiesByPropertyDescriptor();
            List<String> examples = ruleReference.getOverriddenExamples();
            return this.createSingleRuleElement(language, minimumLanguageVersion, maximumLanguageVersion, deprecated, name, null, ref, message, externalInfoUrl, null, null, null, null, description, priority, propertyDescriptors, propertiesByPropertyDescriptor, examples);
        }
        return this.createSingleRuleElement(rule instanceof ImmutableLanguage ? null : rule.getLanguage(), rule.getMinimumLanguageVersion(), rule.getMaximumLanguageVersion(), rule.isDeprecated(), rule.getName(), rule.getSince(), null, rule.getMessage(), rule.getExternalInfoUrl(), rule.getRuleClass(), rule.isDfa(), rule.isTypeResolution(), rule.isMultifile(), rule.getDescription(), rule.getPriority(), rule.getPropertyDescriptors(), rule.getPropertiesByPropertyDescriptor(), rule.getExamples());
    }

    private void setIfNonNull(Object value, Element target, String id) {
        if (value != null) {
            target.setAttribute(id, value.toString());
        }
    }

    private Element createSingleRuleElement(Language language, LanguageVersion minimumLanguageVersion, LanguageVersion maximumLanguageVersion, Boolean deprecated, String name, String since, String ref, String message, String externalInfoUrl, String clazz, Boolean dfa, Boolean typeResolution, Boolean multifile, String description, RulePriority priority, List<PropertyDescriptor<?>> propertyDescriptors, Map<PropertyDescriptor<?>, Object> propertiesByPropertyDescriptor, List<String> examples) {
        Element propertiesElement;
        Element ruleElement = this.createRuleElement();
        if (language != null) {
            ruleElement.setAttribute("language", language.getTerseName());
        }
        if (minimumLanguageVersion != null) {
            ruleElement.setAttribute("minimumLanguageVersion", minimumLanguageVersion.getVersion());
        }
        if (maximumLanguageVersion != null) {
            ruleElement.setAttribute("maximumLanguageVersion", maximumLanguageVersion.getVersion());
        }
        this.setIfNonNull(deprecated, ruleElement, "deprecated");
        this.setIfNonNull(name, ruleElement, "name");
        this.setIfNonNull(since, ruleElement, "since");
        this.setIfNonNull(ref, ruleElement, "ref");
        this.setIfNonNull(message, ruleElement, "message");
        this.setIfNonNull(clazz, ruleElement, "class");
        this.setIfNonNull(externalInfoUrl, ruleElement, "externalInfoUrl");
        this.setIfNonNull(dfa, ruleElement, "dfa");
        this.setIfNonNull(typeResolution, ruleElement, "typeResolution");
        if (description != null) {
            Element descriptionElement = this.createDescriptionElement(description);
            ruleElement.appendChild(descriptionElement);
        }
        if (priority != null) {
            Element priorityElement = this.createPriorityElement(priority);
            ruleElement.appendChild(priorityElement);
        }
        if ((propertiesElement = this.createPropertiesElement(propertyDescriptors, propertiesByPropertyDescriptor)) != null) {
            ruleElement.appendChild(propertiesElement);
        }
        if (examples != null) {
            for (String example : examples) {
                Element exampleElement = this.createExampleElement(example);
                ruleElement.appendChild(exampleElement);
            }
        }
        return ruleElement;
    }

    private Element createRuleSetReferenceElement(RuleSetReference ruleSetReference) {
        Element ruleSetReferenceElement = this.createRuleElement();
        ruleSetReferenceElement.setAttribute("ref", ruleSetReference.getRuleSetFileName());
        for (String exclude : ruleSetReference.getExcludes()) {
            Element excludeElement = this.createExcludeElement(exclude);
            ruleSetReferenceElement.appendChild(excludeElement);
        }
        return ruleSetReferenceElement;
    }

    private Element createPropertiesElement(List<PropertyDescriptor<?>> propertyDescriptors, Map<PropertyDescriptor<?>, Object> propertiesByPropertyDescriptor) {
        Element propertiesElement = null;
        if (propertyDescriptors != null) {
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                if (propertyDescriptor.isDefinedExternally()) {
                    if (propertiesElement == null) {
                        propertiesElement = this.createPropertiesElement();
                    }
                    Element propertyElement = this.createPropertyDefinitionElementBR(propertyDescriptor);
                    propertiesElement.appendChild(propertyElement);
                    continue;
                }
                if (propertiesByPropertyDescriptor == null) continue;
                Object defaultValue = propertyDescriptor.defaultValue();
                Object value = propertiesByPropertyDescriptor.get(propertyDescriptor);
                if (value == defaultValue || value != null && value.equals(defaultValue)) continue;
                if (propertiesElement == null) {
                    propertiesElement = this.createPropertiesElement();
                }
                Element propertyElement = this.createPropertyValueElement(propertyDescriptor, value);
                propertiesElement.appendChild(propertyElement);
            }
        }
        if (propertiesByPropertyDescriptor != null) {
            for (Map.Entry entry : propertiesByPropertyDescriptor.entrySet()) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getKey();
                if (propertyDescriptors.contains(propertyDescriptor)) continue;
                Object defaultValue = propertyDescriptor.defaultValue();
                Object value = entry.getValue();
                if (value == defaultValue || value != null && value.equals(defaultValue)) continue;
                if (propertiesElement == null) {
                    propertiesElement = this.createPropertiesElement();
                }
                Element propertyElement = this.createPropertyValueElement(propertyDescriptor, value);
                propertiesElement.appendChild(propertyElement);
            }
        }
        return propertiesElement;
    }

    private Element createPropertyValueElement(PropertyDescriptor propertyDescriptor, Object value) {
        Element propertyElement = this.document.createElementNS("http://pmd.sourceforge.net/ruleset/2.0.0", "property");
        propertyElement.setAttribute("name", propertyDescriptor.name());
        String valueString = propertyDescriptor.asDelimitedString(value);
        if (XPathRule.XPATH_DESCRIPTOR.equals(propertyDescriptor)) {
            Element valueElement = this.createCDATASectionElement("value", valueString);
            propertyElement.appendChild(valueElement);
        } else {
            propertyElement.setAttribute("value", valueString);
        }
        return propertyElement;
    }

    private Element createPropertyDefinitionElementBR(PropertyDescriptor<?> propertyDescriptor) {
        Element propertyElement = this.createPropertyValueElement(propertyDescriptor, propertyDescriptor.defaultValue());
        propertyElement.setAttribute(PropertyDescriptorField.TYPE.attributeName(), PropertyTypeId.typeIdFor(propertyDescriptor.type(), propertyDescriptor.isMultiValue()));
        Map<PropertyDescriptorField, String> propertyValuesById = propertyDescriptor.attributeValuesById();
        for (Map.Entry<PropertyDescriptorField, String> entry : propertyValuesById.entrySet()) {
            propertyElement.setAttribute(entry.getKey().attributeName(), entry.getValue());
        }
        return propertyElement;
    }

    private Element createTextElement(String name, String value) {
        Element element = this.document.createElementNS("http://pmd.sourceforge.net/ruleset/2.0.0", name);
        Text text = this.document.createTextNode(value);
        element.appendChild(text);
        return element;
    }

    private Element createCDATASectionElement(String name, String value) {
        Element element = this.document.createElementNS("http://pmd.sourceforge.net/ruleset/2.0.0", name);
        CDATASection cdataSection = this.document.createCDATASection(value);
        element.appendChild(cdataSection);
        return element;
    }
}

