/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import net.sourceforge.pmd.annotation.InternalApi;

@InternalApi
public abstract class LanguageServiceBase<T> {
    protected final Map<String, T> languages;

    protected LanguageServiceBase(Class<T> serviceType, Comparator<T> comparator, NameExtractor<T> nameExtractor) {
        ArrayList<T> languagesList = new ArrayList<T>();
        ServiceLoader<T> languageLoader = ServiceLoader.load(serviceType, this.getClass().getClassLoader());
        Iterator<T> iterator = languageLoader.iterator();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    T language = iterator.next();
                    languagesList.add(language);
                }
            }
            catch (UnsupportedClassVersionError | ServiceConfigurationError e) {
                System.err.println("Ignoring language for PMD: " + e.toString());
                continue;
            }
            break;
        }
        Collections.sort(languagesList, comparator);
        this.languages = new LinkedHashMap<String, T>();
        for (Object language : languagesList) {
            this.languages.put(nameExtractor.getName(language), language);
        }
    }

    protected static interface NameExtractor<T> {
        public String getName(T var1);
    }
}

