/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.MatchCollector;
import net.sourceforge.pmd.cpd.SourceManager;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import org.checkerframework.checker.nullness.qual.NonNull;

class MatchAlgorithm {
    private static final int MOD = 37;
    private int lastMod = 1;
    private final Tokens tokens;
    private final List<TokenEntry> code;
    private final int minTileSize;

    MatchAlgorithm(Tokens tokens, int minTileSize) {
        this.tokens = tokens;
        this.code = tokens.getTokens();
        this.minTileSize = minTileSize;
        for (int i = 0; i < minTileSize; ++i) {
            this.lastMod *= 37;
        }
    }

    public TokenEntry tokenAt(int offset, TokenEntry m) {
        return this.code.get(offset + m.getIndex());
    }

    public int getMinimumTileSize() {
        return this.minTileSize;
    }

    public List<Match> findMatches(@NonNull CPDListener cpdListener, SourceManager sourceManager) {
        MatchCollector matchCollector = new MatchCollector(this);
        cpdListener.phaseUpdate(1);
        Map<TokenEntry, Object> markGroups = this.hash();
        cpdListener.phaseUpdate(2);
        markGroups.values().stream().filter(it -> it instanceof List).forEach(it -> {
            List l = (List)it;
            Collections.reverse(l);
            matchCollector.collect(l);
        });
        cpdListener.phaseUpdate(3);
        List<Match> matches = matchCollector.getMatches();
        matches.sort(Comparator.naturalOrder());
        for (Match match : matches) {
            for (Mark mark : match) {
                TokenEntry token = mark.getToken();
                TokenEntry endToken = this.tokens.getEndToken(token, match);
                mark.setEndToken(endToken);
            }
        }
        cpdListener.phaseUpdate(4);
        return matches;
    }

    private Map<TokenEntry, Object> hash() {
        int lastHash = 0;
        HashMap<TokenEntry, Object> markGroups = new HashMap<TokenEntry, Object>(this.tokens.size());
        block0: for (int i = this.code.size() - 1; i >= 0; --i) {
            TokenEntry token = this.code.get(i);
            if (!token.isEof()) {
                ArrayList<TokenEntry> l;
                int last = this.tokenAt(this.minTileSize, token).getIdentifier();
                lastHash = 37 * lastHash + token.getIdentifier() - this.lastMod * last;
                token.setHashCode(lastHash);
                Object o = markGroups.get(token);
                if (o == null) {
                    markGroups.put(token, token);
                    continue;
                }
                if (o instanceof TokenEntry) {
                    l = new ArrayList<TokenEntry>();
                    l.add((TokenEntry)o);
                    l.add(token);
                    markGroups.put(token, l);
                    continue;
                }
                l = (ArrayList<TokenEntry>)o;
                l.add(token);
                continue;
            }
            lastHash = 0;
            int end = Math.max(0, i - this.minTileSize + 1);
            while (i > end) {
                token = this.code.get(i - 1);
                lastHash = 37 * lastHash + token.getIdentifier();
                if (token.isEof()) continue block0;
                --i;
            }
        }
        return markGroups;
    }
}

