/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.Language;

public final class LanguageVersion
implements Comparable<LanguageVersion> {
    private final Language language;
    private final String version;
    private final int index;
    private final List<String> aliases;

    LanguageVersion(Language language, String version, int index, List<String> aliases) {
        this.language = language;
        this.version = version;
        this.index = index;
        this.aliases = aliases;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getVersion() {
        return this.version;
    }

    List<String> getAliases() {
        return this.aliases;
    }

    public String getName() {
        return this.version.length() > 0 ? this.language.getName() + ' ' + this.version : this.language.getName();
    }

    public String getShortName() {
        return this.version.length() > 0 ? this.language.getShortName() + ' ' + this.version : this.language.getShortName();
    }

    public String getTerseName() {
        return this.version.length() > 0 ? this.language.getId() + ' ' + this.version : this.language.getId();
    }

    public int compareToVersion(String versionString) {
        LanguageVersion otherVersion = this.language.getVersion(versionString);
        if (otherVersion == null) {
            throw new IllegalArgumentException("No such version '" + versionString + "' for language " + this.language.getName());
        }
        return this.compareTo(otherVersion);
    }

    @Override
    public int compareTo(LanguageVersion o) {
        int cmp = this.language.compareTo(o.getLanguage());
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(this.index, o.index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LanguageVersion)) {
            return false;
        }
        LanguageVersion that = (LanguageVersion)o;
        return this.language.equals(that.language) && this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.language, this.version);
    }

    public String toString() {
        return this.language.toString() + "+version:" + this.version;
    }
}

