/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import java.util.Collections;
import java.util.Map;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class AstInfo<T extends RootNode> {
    private final TextDocument textDocument;
    private final T rootNode;
    private final LanguageProcessorRegistry lpReg;
    private final Map<Integer, String> suppressionComments;

    public AstInfo(Parser.ParserTask task, T rootNode) {
        this(task.getTextDocument(), rootNode, task.getLpRegistry(), Collections.emptyMap());
    }

    private AstInfo(TextDocument textDocument, T rootNode, LanguageProcessorRegistry lpReg, Map<Integer, String> suppressionComments) {
        this.textDocument = AssertionUtil.requireParamNotNull("text document", textDocument);
        this.rootNode = (RootNode)AssertionUtil.requireParamNotNull("root node", rootNode);
        this.lpReg = lpReg;
        this.suppressionComments = AssertionUtil.requireParamNotNull("suppress map", suppressionComments);
    }

    public T getRootNode() {
        return this.rootNode;
    }

    public @NonNull TextDocument getTextDocument() {
        return this.textDocument;
    }

    public LanguageProcessor getLanguageProcessor() {
        return this.lpReg.getProcessor(this.textDocument.getLanguageVersion().getLanguage());
    }

    public Map<Integer, String> getSuppressionComments() {
        return this.suppressionComments;
    }

    public AstInfo<T> withSuppressMap(Map<Integer, String> map) {
        return new AstInfo<T>(this.textDocument, this.rootNode, this.lpReg, map);
    }
}

