/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import java.util.Objects;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FileAnalysisException
extends RuntimeException {
    private FileId fileId = FileId.UNKNOWN;

    public FileAnalysisException() {
    }

    public FileAnalysisException(String message) {
        super(message);
    }

    public FileAnalysisException(Throwable cause) {
        super(cause);
    }

    public FileAnalysisException(String message, Throwable cause) {
        super(message, cause);
    }

    public FileAnalysisException setFileId(FileId fileId) {
        this.fileId = Objects.requireNonNull(fileId);
        return this;
    }

    protected boolean hasFileName() {
        return !FileId.UNKNOWN.equals(this.fileId);
    }

    public @NonNull FileId getFileId() {
        return this.fileId;
    }

    @Override
    public final String getMessage() {
        return this.errorKind() + StringUtils.uncapitalize((String)this.positionToString()) + ": " + super.getMessage();
    }

    protected String errorKind() {
        return "Error";
    }

    protected @Nullable FileLocation location() {
        return null;
    }

    private String positionToString() {
        FileLocation loc;
        String result = "";
        if (this.hasFileName()) {
            result = result + " in file '" + this.getFileId().getOriginalPath() + "'";
        }
        if ((loc = this.location()) != null) {
            result = result + " at " + loc.startPosToString();
        }
        return result;
    }

    public static FileAnalysisException wrap(@NonNull FileId fileId, @NonNull String message, @NonNull Throwable cause) {
        if (cause instanceof FileAnalysisException) {
            return ((FileAnalysisException)cause).setFileId(fileId);
        }
        String fullMessage = "In file '" + fileId.getAbsolutePath() + "': " + message;
        return new FileAnalysisException(fullMessage, cause).setFileId(fileId);
    }
}

