/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl.javacc;

import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.ast.impl.javacc.CharStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccTokenDocument;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRegion;

public class JavaccToken
implements GenericToken<JavaccToken> {
    public static final int EOF = 0;
    public static final int IMPLICIT_TOKEN = -1;
    public final int kind;
    private final JavaccTokenDocument document;
    private final CharSequence image;
    private final int startOffset;
    private final int endOffset;
    public JavaccToken next;
    public JavaccToken specialToken;

    JavaccToken(int kind, CharSequence image, int startInclusive, int endExclusive, JavaccTokenDocument document) {
        assert (document != null) : "Null document";
        assert (image instanceof String || image instanceof Chars) : "Null image";
        assert (TextRegion.isValidRegion(startInclusive, endExclusive, document.getTextDocument()));
        this.kind = kind;
        this.image = image;
        this.startOffset = startInclusive;
        this.endOffset = endExclusive;
        this.document = document;
    }

    public JavaccToken(int kind, Chars image, int startInclusive, int endExclusive, JavaccTokenDocument document) {
        this(kind, (CharSequence)image, startInclusive, endExclusive, document);
    }

    public JavaccToken(int kind, String image, int startInclusive, int endExclusive, JavaccTokenDocument document) {
        this(kind, (CharSequence)image, startInclusive, endExclusive, document);
    }

    public final JavaccTokenDocument getDocument() {
        return this.document;
    }

    @Override
    public boolean isEof() {
        return this.kind == 0;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    public JavaccToken getNext() {
        return this.next;
    }

    @Override
    public JavaccToken getPreviousComment() {
        return this.specialToken;
    }

    @Override
    public Chars getImageCs() {
        return Chars.wrap(this.image);
    }

    @Override
    public String getImage() {
        return this.image.toString();
    }

    @Override
    public final TextRegion getRegion() {
        return TextRegion.fromBothOffsets(this.startOffset, this.endOffset);
    }

    int getStartOffset() {
        return this.startOffset;
    }

    int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public FileLocation getReportLocation() {
        return this.document.getTextDocument().toLocation(this.getRegion());
    }

    @Override
    public boolean isImplicit() {
        return this.kind == -1;
    }

    public String toString() {
        return this.document.describeKind(this.kind) + ": " + this.getImage();
    }

    public JavaccToken replaceImage(CharStream charStream) {
        return new JavaccToken(this.kind, charStream.getTokenImageCs(), this.startOffset, charStream.getEndOffset(), this.document);
    }

    public JavaccToken withKind(int newKind) {
        JavaccToken tok = new JavaccToken(newKind, this.image, this.startOffset, this.endOffset, this.document);
        tok.specialToken = this.specialToken;
        tok.next = this.next;
        return tok;
    }

    public static JavaccToken implicitBefore(JavaccToken next) {
        JavaccToken implicit = JavaccToken.newImplicit(next.getRegion().getStartOffset(), next.document);
        implicit.next = next;
        if (next.specialToken != null) {
            next.specialToken.next = implicit;
            implicit.specialToken = next.specialToken;
        }
        next.specialToken = implicit;
        return implicit;
    }

    public static JavaccToken newImplicit(int offset, JavaccTokenDocument document) {
        return new JavaccToken(-1, "", offset, offset, document);
    }
}

