/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import com.github.oowekyala.ooxml.DomUtils;
import com.github.oowekyala.ooxml.messages.NiceXmlMessageSpec;
import com.github.oowekyala.ooxml.messages.OoxmlFacade;
import com.github.oowekyala.ooxml.messages.PositionedXmlDoc;
import com.github.oowekyala.ooxml.messages.XmlException;
import com.github.oowekyala.ooxml.messages.XmlMessageHandler;
import com.github.oowekyala.ooxml.messages.XmlMessageReporterBase;
import com.github.oowekyala.ooxml.messages.XmlPosition;
import com.github.oowekyala.ooxml.messages.XmlPositioner;
import com.github.oowekyala.ooxml.messages.XmlSeverity;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleFactory;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleSetLoadException;
import net.sourceforge.pmd.lang.rule.RuleSetLoader;
import net.sourceforge.pmd.lang.rule.internal.RuleSetReference;
import net.sourceforge.pmd.lang.rule.internal.RuleSetReferenceId;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.internal.ResourceLoader;
import net.sourceforge.pmd.util.internal.xml.PmdXmlReporter;
import net.sourceforge.pmd.util.internal.xml.SchemaConstants;
import net.sourceforge.pmd.util.internal.xml.XmlUtil;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

final class RuleSetFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RuleSetFactory.class);
    private final ResourceLoader resourceLoader;
    private final LanguageRegistry languageRegistry;
    private final RulePriority minimumPriority;
    private final boolean warnDeprecated;
    private final PmdReporter reporter;
    private final boolean includeDeprecatedRuleReferences;
    private final Map<RuleSetReferenceId, RuleSet> parsedRulesets = new HashMap<RuleSetReferenceId, RuleSet>();

    RuleSetFactory(ResourceLoader resourceLoader, LanguageRegistry languageRegistry, RulePriority minimumPriority, boolean warnDeprecated, boolean includeDeprecatedRuleReferences, PmdReporter reporter) {
        this.resourceLoader = resourceLoader;
        this.languageRegistry = Objects.requireNonNull(languageRegistry);
        this.minimumPriority = minimumPriority;
        this.warnDeprecated = warnDeprecated;
        this.includeDeprecatedRuleReferences = includeDeprecatedRuleReferences;
        this.reporter = reporter;
    }

    @NonNull RuleSet createRuleSet(RuleSetReferenceId ruleSetReferenceId) {
        return this.createRuleSet(ruleSetReferenceId, this.includeDeprecatedRuleReferences);
    }

    private @NonNull RuleSet createRuleSet(RuleSetReferenceId ruleSetReferenceId, boolean withDeprecatedRuleReferences) throws RuleSetLoadException {
        return this.readDocument(ruleSetReferenceId, withDeprecatedRuleReferences);
    }

    private Rule createRule(RuleSetReferenceId ruleSetReferenceId, boolean withDeprecatedRuleReferences) {
        RuleSetReferenceId parentRuleset = ruleSetReferenceId.getParentRulesetIfThisIsARule();
        if (parentRuleset == null) {
            throw new IllegalArgumentException("Cannot parse a single Rule from an all Rule RuleSet reference: <" + ruleSetReferenceId + ">.");
        }
        RuleSet ruleSet = this.parsedRulesets.get(parentRuleset);
        if (ruleSet == null) {
            ruleSet = this.createRuleSet(ruleSetReferenceId, withDeprecatedRuleReferences);
            this.parsedRulesets.put(ruleSetReferenceId, ruleSet);
        }
        return ruleSet.getRuleByName(ruleSetReferenceId.getRuleName());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private @NonNull RuleSet readDocument(RuleSetReferenceId ruleSetReferenceId, boolean withDeprecatedRuleReferences) {
        try (CheckedInputStream inputStream = new CheckedInputStream(ruleSetReferenceId.getInputStream(this.resourceLoader), new Adler32());){
            if (!ruleSetReferenceId.isAbsolute()) {
                throw new IllegalArgumentException("Cannot parse a RuleSet from a non-absolute reference: <" + ruleSetReferenceId + ">.");
            }
            XmlMessageHandler printer = this.getXmlMessagePrinter();
            DocumentBuilder builder = this.createDocumentBuilder();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(ruleSetReferenceId.getRuleSetFileName());
            OoxmlFacade ooxml = new OoxmlFacade().withPrinter(printer).withAnsiColors(false);
            PositionedXmlDoc parsed = ooxml.parse(builder, inputSource);
            PmdXmlReporterImpl err = new PmdXmlReporterImpl(this.reporter, ooxml, parsed.getPositioner());
            RuleSet.RuleSetBuilder ruleSetBuilder = new RuleSet.RuleSetBuilder(inputStream.getChecksum().getValue()).withFileName(ruleSetReferenceId.getRuleSetFileName());
            RuleSet ruleSet = this.parseRulesetNode(ruleSetReferenceId, withDeprecatedRuleReferences, parsed, ruleSetBuilder, err);
            if (err.errCount > 0) {
                String message = err.errCount == 1 ? "An XML validation error occurred" : err.errCount + " XML validation errors occurred";
                throw new RuleSetLoadException(ruleSetReferenceId, message);
            }
            RuleSet ruleSet2 = ruleSet;
            return ruleSet2;
        }
        catch (IOException | ParserConfigurationException ex) {
            throw new RuleSetLoadException(ruleSetReferenceId, (Throwable)ex);
        }
    }

    private RuleSet parseRulesetNode(RuleSetReferenceId ruleSetReferenceId, boolean withDeprecatedRuleReferences, PositionedXmlDoc parsed, RuleSet.RuleSetBuilder builder, PmdXmlReporter err) {
        Element ruleSetElement = parsed.getDocument().getDocumentElement();
        if (ruleSetElement.hasAttribute("name")) {
            builder.withName(ruleSetElement.getAttribute("name"));
        } else {
            ((PmdReporter)err.at(ruleSetElement)).warn("RuleSet name is missing. Future versions of PMD will require it.", new Object[0]);
            builder.withName("Missing RuleSet Name");
        }
        HashSet<String> rulesetReferences = new HashSet<String>();
        for (Element node : DomUtils.children((Element)ruleSetElement)) {
            Pattern pattern;
            String text = XmlUtil.parseTextNode(node);
            if (SchemaConstants.DESCRIPTION.matchesElt(node)) {
                builder.withDescription(text);
                continue;
            }
            if (SchemaConstants.INCLUDE_PATTERN.matchesElt(node)) {
                pattern = this.parseRegex(node, text, err);
                if (pattern == null) continue;
                builder.withFileInclusions(pattern, new Pattern[0]);
                continue;
            }
            if (SchemaConstants.EXCLUDE_PATTERN.matchesElt(node)) {
                pattern = this.parseRegex(node, text, err);
                if (pattern == null) continue;
                builder.withFileExclusions(pattern, new Pattern[0]);
                continue;
            }
            if (SchemaConstants.RULE.matchesElt(node)) {
                try {
                    this.parseRuleNode(ruleSetReferenceId, builder, node, withDeprecatedRuleReferences, rulesetReferences, err);
                }
                catch (XmlException xmlException) {}
                continue;
            }
            ((PmdReporter)err.at(node)).error("Unexpected element ''{0}'' in {1}", node.getTagName(), SchemaConstants.RULESET);
        }
        if (!builder.hasDescription()) {
            ((PmdReporter)err.at(ruleSetElement)).warn("RuleSet description is missing. Future versions of PMD will require it.", new Object[0]);
            builder.withDescription("Missing description");
        }
        builder.filterRulesByPriority(this.minimumPriority);
        return builder.build();
    }

    private Pattern parseRegex(Element node, String text, PmdXmlReporter err) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(text);
        }
        catch (PatternSyntaxException pse) {
            ((PmdReporter)err.at(node)).error(pse);
            return null;
        }
        return pattern;
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            LOG.warn("Ignored unsupported XML Parser Feature for parsing rulesets", (Throwable)e);
        }
        return dbf.newDocumentBuilder();
    }

    private void parseRuleNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Element ruleNode, boolean withDeprecatedRuleReferences, Set<String> rulesetReferences, PmdXmlReporter err) {
        String ref;
        RuleSetReferenceId refId;
        if (SchemaConstants.REF.hasAttribute(ruleNode) && (refId = this.parseReferenceAndWarn(ref = SchemaConstants.REF.getAttributeOrThrow(ruleNode, err), SchemaConstants.REF.getAttributeNode(ruleNode), err)) != null) {
            if (refId.isAllRules()) {
                this.parseRuleSetReferenceNode(ruleSetBuilder, ruleNode, ref, refId, rulesetReferences, err);
            } else {
                this.parseRuleReferenceNode(ruleSetReferenceId, ruleSetBuilder, ruleNode, ref, refId, withDeprecatedRuleReferences, err);
            }
            return;
        }
        this.parseSingleRuleNode(ruleSetReferenceId, ruleSetBuilder, ruleNode, err);
    }

    private void parseRuleSetReferenceNode(RuleSet.RuleSetBuilder ruleSetBuilder, Element ruleElement, String ref, RuleSetReferenceId ruleSetReferenceId, Set<String> rulesetReferences, PmdXmlReporter err) {
        RulePriority priority = null;
        HashMap<String, Element> excludedRulesCheck = new HashMap<String, Element>();
        for (Element child : XmlUtil.getElementChildrenList(ruleElement)) {
            if (SchemaConstants.EXCLUDE.matchesElt(child)) {
                String excludedRuleName;
                try {
                    excludedRuleName = SchemaConstants.NAME.getAttributeOrThrow(child, err);
                }
                catch (XmlException ignored) {
                    continue;
                }
                if (excludedRuleName == null) continue;
                excludedRulesCheck.put(excludedRuleName, child);
                continue;
            }
            if (SchemaConstants.PRIORITY.matchesElt(child)) {
                priority = RuleFactory.parsePriority(err, child);
                continue;
            }
            XmlUtil.reportIgnoredUnexpectedElt(ruleElement, child, CollectionUtil.setOf(SchemaConstants.EXCLUDE, SchemaConstants.PRIORITY), err);
        }
        RuleSetReference ruleSetReference = new RuleSetReference(ref, true, excludedRulesCheck.keySet());
        RuleSetFactory ruleSetFactory = this.toLoader().filterAbovePriority(RulePriority.LOW).warnDeprecated(false).toFactory();
        RuleSet otherRuleSet = ruleSetFactory.createRuleSet(ruleSetReferenceId);
        ArrayList<RuleReference> potentialRules = new ArrayList<RuleReference>();
        int countDeprecated = 0;
        for (Rule rule : otherRuleSet.getRules()) {
            excludedRulesCheck.remove(rule.getName());
            if (ruleSetReference.getExcludes().contains(rule.getName())) continue;
            RuleReference ruleReference = new RuleReference(rule, ruleSetReference);
            if (priority != null) {
                ruleReference.setPriority(priority);
            }
            if (rule.isDeprecated()) {
                ++countDeprecated;
            }
            potentialRules.add(ruleReference);
        }
        boolean rulesetDeprecated = false;
        if (!potentialRules.isEmpty() && potentialRules.size() == countDeprecated) {
            rulesetDeprecated = true;
            ((PmdReporter)err.at(SchemaConstants.REF.getAttributeNode(ruleElement))).warn("The RuleSet {0} has been deprecated and will be removed in PMD {1}", ref, PMDVersion.getNextMajorRelease());
        }
        for (RuleReference r : potentialRules) {
            if (!rulesetDeprecated && r.getRule().isDeprecated()) continue;
            ruleSetBuilder.addRuleIfNotExists(r);
        }
        if (!excludedRulesCheck.isEmpty()) {
            excludedRulesCheck.forEach((name, elt) -> ((PmdReporter)err.at((Node)elt)).warn("Exclude pattern ''{0}'' did not match any rule in ruleset ''{1}''", name, ref));
        }
        if (rulesetReferences.contains(ref)) {
            ((PmdReporter)err.at(ruleElement)).warn("The ruleset {0} is referenced multiple times in ruleset ''{1}''", ref, ruleSetBuilder.getName());
        }
        rulesetReferences.add(ref);
    }

    private RuleSetReferenceId parseReferenceAndWarn(String ref, Node xmlPlace, PmdXmlReporter err) {
        if (ref == null) {
            ((PmdReporter)err.at(xmlPlace)).warn("Rule reference references a deleted rule, ignoring", new Object[0]);
            return null;
        }
        List<RuleSetReferenceId> references = RuleSetReferenceId.parse(ref);
        if (references.size() > 1 && this.warnDeprecated) {
            ((PmdReporter)err.at(xmlPlace)).warn("Using a comma separated list as a ref attribute is deprecated. All references but the first are ignored.", new Object[0]);
        } else if (references.isEmpty()) {
            ((PmdReporter)err.at(xmlPlace)).warn("Empty ref attribute", new Object[0]);
            return null;
        }
        return references.get(0);
    }

    private void parseSingleRuleNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Element ruleNode, PmdXmlReporter err) {
        if (StringUtils.isNotBlank((CharSequence)ruleSetReferenceId.getRuleName()) && !this.isRuleName(ruleNode, ruleSetReferenceId.getRuleName())) {
            return;
        }
        Rule rule = new RuleFactory(this.resourceLoader, this.languageRegistry).buildRule(ruleNode, err);
        rule.setRuleSetName(ruleSetBuilder.getName());
        if (this.warnDeprecated && StringUtils.isBlank((CharSequence)ruleNode.getAttribute("language"))) {
            ((PmdReporter)err.at(ruleNode)).warn("Rule {0}/{1} does not mention attribute language='{2}', please mention it explicitly to be compatible with PMD 7", ruleSetReferenceId.getRuleSetFileName(), rule.getName(), rule.getLanguage().getId());
        }
        ruleSetBuilder.addRule(rule);
    }

    private void parseRuleReferenceNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Element ruleNode, String ref, RuleSetReferenceId otherRuleSetReferenceId, boolean withDeprecatedRuleReferences, PmdXmlReporter err) {
        RuleReference ruleReference;
        if (StringUtils.isNotBlank((CharSequence)ruleSetReferenceId.getRuleName()) && !this.isRuleName(ruleNode, ruleSetReferenceId.getRuleName())) {
            return;
        }
        RuleSetFactory ruleSetFactory = this.toLoader().filterAbovePriority(RulePriority.LOW).warnDeprecated(false).toFactory();
        boolean isSameRuleSet = false;
        if (!otherRuleSetReferenceId.isAbsolute() && this.containsRule(ruleSetReferenceId, otherRuleSetReferenceId.getRuleName())) {
            otherRuleSetReferenceId = new RuleSetReferenceId(ref, ruleSetReferenceId);
            isSameRuleSet = true;
        } else if (otherRuleSetReferenceId.isAbsolute() && otherRuleSetReferenceId.getRuleSetFileName().equals(ruleSetReferenceId.getRuleSetFileName())) {
            otherRuleSetReferenceId = new RuleSetReferenceId(otherRuleSetReferenceId.getRuleName(), ruleSetReferenceId);
            isSameRuleSet = true;
        }
        Rule referencedRule = ruleSetFactory.createRule(otherRuleSetReferenceId, true);
        if (referencedRule == null) {
            throw ((PmdReporter)err.at(ruleNode)).error("Unable to find referenced rule {0}; perhaps the rule name is misspelled?", otherRuleSetReferenceId.getRuleName());
        }
        if (this.warnDeprecated && referencedRule.isDeprecated()) {
            if (referencedRule instanceof RuleReference) {
                RuleReference ruleReference2 = (RuleReference)referencedRule;
                ((PmdReporter)err.at(ruleNode)).warn("Use Rule name {0}/{1} instead of the deprecated Rule name {2}. PMD {3} will remove support for this deprecated Rule name usage.", ruleReference2.getRuleSetReference().getRuleSetFileName(), ruleReference2.getOriginalName(), otherRuleSetReferenceId, PMDVersion.getNextMajorRelease());
            } else {
                ((PmdReporter)err.at(ruleNode)).warn("Discontinue using Rule name {0} as it is scheduled for removal from PMD. PMD {1} will remove support for this Rule.", otherRuleSetReferenceId, PMDVersion.getNextMajorRelease());
            }
        }
        RuleSetReference ruleSetReference = new RuleSetReference(otherRuleSetReferenceId.getRuleSetFileName(), false);
        try {
            ruleReference = new RuleFactory(this.resourceLoader, this.languageRegistry).decorateRule(referencedRule, ruleSetReference, ruleNode, err);
        }
        catch (XmlException e) {
            throw ((PmdReporter)err.at(ruleNode)).error(e, "Error while parsing rule reference", new Object[0]);
        }
        if (this.warnDeprecated && ruleReference.isDeprecated() && !isSameRuleSet) {
            ((PmdReporter)err.at(ruleNode)).warn("Use Rule name {0}/{1} instead of the deprecated Rule name {2}/{3}. PMD {4} will remove support for this deprecated Rule name usage.", ruleReference.getRuleSetReference().getRuleSetFileName(), ruleReference.getOriginalName(), ruleSetReferenceId.getRuleSetFileName(), ruleReference.getName(), PMDVersion.getNextMajorRelease());
        }
        if (withDeprecatedRuleReferences || !isSameRuleSet || !ruleReference.isDeprecated()) {
            RuleReference existingRuleReference;
            Rule existingRule = ruleSetBuilder.getExistingRule(ruleReference);
            if (existingRule instanceof RuleReference && ((existingRuleReference = (RuleReference)existingRule).hasOverriddenAttributes() || !ruleReference.hasOverriddenAttributes())) {
                ((PmdReporter)err.at(ruleNode)).warn("The rule {0} is referenced multiple times in ruleset ''{1}''. Only the last rule configuration is used.", ruleReference.getName(), ruleSetBuilder.getName());
            }
            ruleSetBuilder.addRuleReplaceIfExists(ruleReference);
        }
    }

    private boolean containsRule(RuleSetReferenceId ruleSetReferenceId, String ruleName) {
        boolean found = false;
        try (InputStream ruleSet = ruleSetReferenceId.getInputStream(this.resourceLoader);){
            DocumentBuilder builder = this.createDocumentBuilder();
            Document document = builder.parse(ruleSet);
            Element ruleSetElement = document.getDocumentElement();
            NodeList rules = ruleSetElement.getElementsByTagName("rule");
            for (int i = 0; i < rules.getLength(); ++i) {
                Element rule = (Element)rules.item(i);
                if (!rule.hasAttribute("name") || !rule.getAttribute("name").equals(ruleName)) continue;
                found = true;
                break;
            }
        }
        catch (Exception e) {
            throw new RuleSetLoadException(ruleSetReferenceId, (Throwable)e);
        }
        return found;
    }

    private boolean isRuleName(Element ruleElement, String ruleName) {
        if (ruleElement.hasAttribute("name")) {
            return ruleElement.getAttribute("name").equals(ruleName);
        }
        if (ruleElement.hasAttribute("ref")) {
            RuleSetReferenceId ruleSetReferenceId = RuleSetReferenceId.parse(ruleElement.getAttribute("ref")).get(0);
            return ruleSetReferenceId.getRuleName() != null && ruleSetReferenceId.getRuleName().equals(ruleName);
        }
        return false;
    }

    public RuleSetLoader toLoader() {
        return new RuleSetLoader().loadResourcesWith(this.resourceLoader).filterAbovePriority(this.minimumPriority).warnDeprecated(this.warnDeprecated).includeDeprecatedRuleReferences(this.includeDeprecatedRuleReferences);
    }

    private @NonNull XmlMessageHandler getXmlMessagePrinter() {
        return entry -> {
            Level level = entry.getSeverity() == XmlSeverity.WARNING ? Level.WARN : Level.ERROR;
            String quotedText = StringUtil.quoteMessageFormat(entry.toString());
            this.reporter.logEx(level, quotedText, new Object[0], entry.getCause());
        };
    }

    private static final class PmdXmlReporterImpl
    extends XmlMessageReporterBase<PmdReporter>
    implements PmdXmlReporter {
        private final PmdReporter pmdReporter;
        private int errCount;

        PmdXmlReporterImpl(PmdReporter pmdReporter, OoxmlFacade ooxml, XmlPositioner positioner) {
            super(ooxml, positioner);
            this.pmdReporter = pmdReporter;
        }

        protected PmdReporter create2ndStage(final XmlPosition position, final XmlPositioner positioner) {
            return new PmdReporter(){

                @Override
                public boolean isLoggable(Level level) {
                    return pmdReporter.isLoggable(level);
                }

                @Override
                public void log(Level level, String message, Object ... formatArgs) {
                    this.logEx(level, message, formatArgs, null);
                }

                @Override
                public void logEx(Level level, String message, Object[] formatArgs, @Nullable Throwable error) {
                    this.newException(level, error, message, formatArgs);
                }

                public XmlException error(@Nullable Throwable cause, @Nullable String contextMessage, Object ... formatArgs) {
                    return this.newException(Level.ERROR, cause, contextMessage, formatArgs);
                }

                public XmlException newException(Level level, Throwable cause, String message, Object ... formatArgs) {
                    XmlSeverity severity;
                    switch (level) {
                        case WARN: {
                            severity = XmlSeverity.WARNING;
                            break;
                        }
                        case ERROR: {
                            errCount++;
                            severity = XmlSeverity.ERROR;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unexpected level " + level);
                        }
                    }
                    if (message == null && formatArgs.length != 0) {
                        throw new IllegalArgumentException("Cannot pass format arguments for null message");
                    }
                    String actualMessage = message == null ? cause.getMessage() : MessageFormat.format(message, formatArgs);
                    NiceXmlMessageSpec spec = new NiceXmlMessageSpec(position, actualMessage).withSeverity(severity).withCause(cause);
                    String fullMessage = ooxml.getFormatter().formatSpec(ooxml, spec, positioner);
                    XmlException ex = new XmlException(spec, fullMessage);
                    ooxml.getPrinter().accept(ex);
                    return ex;
                }

                @Override
                public int numErrors() {
                    return pmdReporter.numErrors();
                }
            };
        }
    }
}

