/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.DeprecatedAttribute;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Attribute {
    private static final Logger LOG = LoggerFactory.getLogger(Attribute.class);
    private final @NonNull Node parent;
    private final @NonNull String name;
    private final @Nullable MethodHandle handle;
    private final @Nullable Method method;
    private boolean invoked;
    private @Nullable Object value;
    private String stringValue;

    public Attribute(@NonNull Node parent, @NonNull String name, @NonNull MethodHandle handle, @NonNull Method method) {
        this.parent = Objects.requireNonNull(parent);
        this.name = Objects.requireNonNull(name);
        this.handle = Objects.requireNonNull(handle);
        this.method = Objects.requireNonNull(method);
    }

    public Attribute(@NonNull Node parent, @NonNull String name, @Nullable String value) {
        this.parent = Objects.requireNonNull(parent);
        this.name = Objects.requireNonNull(name);
        this.value = value;
        this.handle = null;
        this.method = null;
        this.stringValue = value == null ? "" : value;
        this.invoked = true;
    }

    public Type getType() {
        return this.method == null ? String.class : this.method.getGenericReturnType();
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull Node getParent() {
        return this.parent;
    }

    String replacementIfDeprecated() {
        String result;
        if (this.method == null) {
            return null;
        }
        DeprecatedAttribute annot = this.method.getAnnotation(DeprecatedAttribute.class);
        String string = annot != null ? annot.replaceWith() : (result = this.method.isAnnotationPresent(Deprecated.class) ? "" : null);
        if (result == null && List.class.isAssignableFrom(this.method.getReturnType())) {
            result = "";
        }
        return result;
    }

    public boolean isDeprecated() {
        return this.replacementIfDeprecated() != null;
    }

    public Object getValue() {
        Object value;
        if (this.invoked) {
            return this.value;
        }
        if (this.handle == null) {
            throw new NullPointerException("Cannot fetch value of attribute with null getter! " + this);
        }
        try {
            value = this.handle.invokeExact(this.parent);
        }
        catch (Throwable iae) {
            LOG.debug("Exception while fetching attribute value", iae);
            value = null;
        }
        this.value = value;
        this.invoked = true;
        return value;
    }

    public @NonNull String getStringValue() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        Object v = this.getValue();
        this.stringValue = v == null ? "" : v.toString();
        return this.stringValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.parent, attribute.parent) && Objects.equals(this.name, attribute.name);
    }

    public int hashCode() {
        return this.parent.hashCode() * 31 + this.name.hashCode();
    }

    public String toString() {
        return this.parent.getXPathNodeName() + "/@" + this.name + " = " + this.getValue();
    }
}

