/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.type.SchemaType;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstElementNode;
import net.sourceforge.pmd.lang.rule.xpath.internal.BaseNodeInfo;
import net.sourceforge.pmd.lang.rule.xpath.internal.DomainConversion;

class AstAttributeNode
extends BaseNodeInfo
implements SiblingCountingNode {
    private final Attribute attribute;
    private AtomicSequence value;
    private final SchemaType schemaType;
    private final int siblingPosition;

    AstAttributeNode(AstElementNode parent, Attribute attribute, int siblingPosition) {
        super(2, parent.getNamePool(), attribute.getName(), parent);
        this.attribute = attribute;
        this.schemaType = DomainConversion.buildType(attribute.getType());
        this.siblingPosition = siblingPosition;
        this.treeInfo = parent.getTreeInfo();
    }

    @Override
    List<AstElementNode> getChildren() {
        return Collections.emptyList();
    }

    public int getSiblingPosition() {
        return this.siblingPosition;
    }

    protected AxisIterator iterateAttributes(Predicate<? super NodeInfo> nodeTest) {
        return EmptyIterator.ofNodes();
    }

    protected AxisIterator iterateChildren(Predicate<? super NodeInfo> nodeTest) {
        return EmptyIterator.ofNodes();
    }

    protected AxisIterator iterateSiblings(Predicate<? super NodeInfo> nodeTest, boolean forwards) {
        return EmptyIterator.ofNodes();
    }

    public AtomicSequence atomize() {
        if (this.value == null) {
            this.value = DomainConversion.convert(this.attribute.getValue());
        }
        return this.value;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public Attribute getUnderlyingNode() {
        return this.attribute;
    }

    public int compareOrder(NodeInfo other) {
        if (other instanceof SiblingCountingNode) {
            return Navigator.compareOrder((SiblingCountingNode)this, (SiblingCountingNode)((SiblingCountingNode)other));
        }
        throw new UnsupportedOperationException();
    }

    public String getLocalPart() {
        return this.attribute.getName();
    }

    public void generateId(FastStringBuffer buffer) {
        buffer.append(Integer.toString(this.hashCode()));
    }

    public CharSequence getStringValueCS() {
        this.getTreeInfo().getLogger().recordUsageOf(this.attribute);
        return this.attribute.getStringValue();
    }
}

