/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.List;
import net.sourceforge.pmd.properties.PropertyConstraint;
import net.sourceforge.pmd.properties.PropertySerializer;
import net.sourceforge.pmd.properties.internal.PropertyParsingUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

class ConstraintDecorator<T>
extends PropertySerializer<T> {
    private final PropertySerializer<T> propertySerializer;
    private final List<PropertyConstraint<? super T>> constraints;

    ConstraintDecorator(PropertySerializer<T> mapper, List<PropertyConstraint<? super T>> constraints) {
        this.propertySerializer = mapper;
        this.constraints = constraints;
    }

    @Override
    public List<PropertyConstraint<? super T>> getConstraints() {
        return this.constraints;
    }

    @Override
    public PropertySerializer<T> withConstraint(PropertyConstraint<? super T> t) {
        return new ConstraintDecorator<T>(this.propertySerializer, CollectionUtil.plus(this.constraints, t));
    }

    @Override
    public T fromString(@NonNull String attributeData) {
        T t = this.propertySerializer.fromString(attributeData);
        PropertyParsingUtil.checkConstraintsThrow(t, this.constraints);
        return t;
    }

    @Override
    public @NonNull String toString(T value) {
        return this.propertySerializer.toString(value);
    }

    public String toString() {
        return "ConstraintDecorator{propertySerializer=" + this.propertySerializer + ", constraints=" + this.constraints + '}';
    }
}

