/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class XMLRenderer
extends AbstractIncrementingRenderer {
    public static final String NAME = "xml";
    public static final PropertyDescriptor<String> ENCODING = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty("encoding").desc("XML encoding format")).defaultValue("UTF-8")).build();
    private static final String PMD_REPORT_NS_URI = "http://pmd.sourceforge.net/report/2.0.0";
    private static final String PMD_REPORT_NS_LOCATION = "http://pmd.sourceforge.net/report_2_0_0.xsd";
    private static final String XSI_NS_PREFIX = "xsi";
    private XMLStreamWriter xmlWriter;
    private OutputStream stream;
    private byte[] lineSeparator;

    public XMLRenderer() {
        super(NAME, "XML format.");
        this.definePropertyDescriptor(ENCODING);
    }

    public XMLRenderer(String encoding) {
        this();
        this.setProperty(ENCODING, encoding);
    }

    @Override
    public String defaultFileExtension() {
        return NAME;
    }

    @Override
    public void start() throws IOException {
        String encoding = this.getProperty(ENCODING);
        String unmarkedEncoding = XMLRenderer.toUnmarkedEncoding(encoding);
        this.lineSeparator = System.lineSeparator().getBytes(unmarkedEncoding);
        try {
            this.xmlWriter.writeStartDocument(encoding, "1.0");
            this.writeNewLine();
            this.xmlWriter.setDefaultNamespace(PMD_REPORT_NS_URI);
            this.xmlWriter.writeStartElement(PMD_REPORT_NS_URI, "pmd");
            this.xmlWriter.writeDefaultNamespace(PMD_REPORT_NS_URI);
            this.xmlWriter.writeNamespace(XSI_NS_PREFIX, "http://www.w3.org/2001/XMLSchema-instance");
            this.xmlWriter.writeAttribute(XSI_NS_PREFIX, "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://pmd.sourceforge.net/report/2.0.0 http://pmd.sourceforge.net/report_2_0_0.xsd");
            this.xmlWriter.writeAttribute("version", PMDVersion.VERSION);
            this.xmlWriter.writeAttribute("timestamp", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").format(new Date()));
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private static String toUnmarkedEncoding(String encoding) {
        if (StandardCharsets.UTF_16.name().equalsIgnoreCase(encoding)) {
            return StandardCharsets.UTF_16BE.name();
        }
        if ("UTF-16LE_BOM".equalsIgnoreCase(encoding)) {
            return StandardCharsets.UTF_16LE.name();
        }
        return encoding;
    }

    private void writeNewLine() throws XMLStreamException, IOException {
        this.xmlWriter.writeCharacters("");
        this.xmlWriter.flush();
        this.stream.write(this.lineSeparator);
    }

    @Override
    public void renderFileViolations(Iterator<RuleViolation> violations) throws IOException {
        String filename = null;
        try {
            while (violations.hasNext()) {
                RuleViolation rv = violations.next();
                String nextFilename = this.determineFileName(rv.getFileId());
                if (!nextFilename.equals(filename)) {
                    if (filename != null) {
                        this.xmlWriter.writeEndElement();
                    }
                    filename = nextFilename;
                    this.writeNewLine();
                    this.xmlWriter.writeStartElement("file");
                    this.xmlWriter.writeAttribute("name", filename);
                    this.writeNewLine();
                }
                this.xmlWriter.writeStartElement("violation");
                this.xmlWriter.writeAttribute("beginline", String.valueOf(rv.getBeginLine()));
                this.xmlWriter.writeAttribute("endline", String.valueOf(rv.getEndLine()));
                this.xmlWriter.writeAttribute("begincolumn", String.valueOf(rv.getBeginColumn()));
                this.xmlWriter.writeAttribute("endcolumn", String.valueOf(rv.getEndColumn()));
                this.xmlWriter.writeAttribute("rule", rv.getRule().getName());
                this.xmlWriter.writeAttribute("ruleset", rv.getRule().getRuleSetName());
                this.maybeAdd("package", rv.getAdditionalInfo().get("packageName"));
                this.maybeAdd("class", rv.getAdditionalInfo().get("className"));
                this.maybeAdd("method", rv.getAdditionalInfo().get("methodName"));
                this.maybeAdd("variable", rv.getAdditionalInfo().get("variableName"));
                this.maybeAdd("externalInfoUrl", rv.getRule().getExternalInfoUrl());
                this.xmlWriter.writeAttribute("priority", String.valueOf(rv.getRule().getPriority().getPriority()));
                this.writeNewLine();
                this.xmlWriter.writeCharacters(StringUtil.removedInvalidXml10Characters(rv.getDescription()));
                this.writeNewLine();
                this.xmlWriter.writeEndElement();
                this.writeNewLine();
            }
            if (filename != null) {
                this.xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void end() throws IOException {
        try {
            for (Report.ProcessingError pe : this.errors) {
                this.writeNewLine();
                this.xmlWriter.writeStartElement("error");
                this.xmlWriter.writeAttribute("filename", this.determineFileName(pe.getFileId()));
                this.xmlWriter.writeAttribute("msg", pe.getMsg());
                this.writeNewLine();
                this.xmlWriter.writeCData(pe.getDetail());
                this.writeNewLine();
                this.xmlWriter.writeEndElement();
            }
            if (this.showSuppressedViolations) {
                for (Report.SuppressedViolation s : this.suppressed) {
                    this.writeNewLine();
                    this.xmlWriter.writeStartElement("suppressedviolation");
                    this.xmlWriter.writeAttribute("filename", this.determineFileName(s.getRuleViolation().getFileId()));
                    this.xmlWriter.writeAttribute("suppressiontype", s.getSuppressor().getId().toLowerCase(Locale.ROOT));
                    this.xmlWriter.writeAttribute("msg", s.getRuleViolation().getDescription());
                    this.xmlWriter.writeAttribute("usermsg", s.getUserMessage() == null ? "" : s.getUserMessage());
                    this.xmlWriter.writeEndElement();
                }
            }
            for (Report.ConfigurationError ce : this.configErrors) {
                this.writeNewLine();
                this.xmlWriter.writeEmptyElement("configerror");
                this.xmlWriter.writeAttribute("rule", ce.rule().getName());
                this.xmlWriter.writeAttribute("msg", ce.issue());
            }
            this.writeNewLine();
            this.xmlWriter.writeEndElement();
            this.writeNewLine();
            this.xmlWriter.writeEndDocument();
            this.xmlWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void maybeAdd(String attr, String value) throws XMLStreamException {
        if (value != null && value.length() > 0) {
            this.xmlWriter.writeAttribute(attr, value);
        }
    }

    @Override
    public void setReportFile(String reportFilename) {
        String encoding = this.getProperty(ENCODING);
        try {
            this.stream = StringUtils.isBlank((CharSequence)reportFilename) ? System.out : Files.newOutputStream(new File(reportFilename).toPath(), new OpenOption[0]);
            XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
            this.xmlWriter = outputFactory.createXMLStreamWriter(this.stream, encoding);
            super.setWriter(new WrappedOutputStreamWriter(this.xmlWriter, this.stream, encoding));
        }
        catch (IOException | XMLStreamException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void setWriter(Writer writer) {
        String encoding = this.getProperty(ENCODING);
        this.stream = IOUtil.fromWriter(writer, encoding);
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmlWriter = outputFactory.createXMLStreamWriter(this.stream, encoding);
            super.setWriter(new WrappedOutputStreamWriter(this.xmlWriter, this.stream, encoding));
        }
        catch (UnsupportedEncodingException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private static class WrappedOutputStreamWriter
    extends OutputStreamWriter {
        private final XMLStreamWriter xmlWriter;

        WrappedOutputStreamWriter(XMLStreamWriter xmlWriter, OutputStream out, String charset) throws UnsupportedEncodingException {
            super(out, charset);
            this.xmlWriter = xmlWriter;
        }

        @Override
        public void flush() throws IOException {
            try {
                this.xmlWriter.flush();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
            super.flush();
        }

        @Override
        public void close() throws IOException {
            try {
                this.xmlWriter.close();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
            super.close();
        }
    }
}

