/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.ConsList;
import net.sourceforge.pmd.util.IteratorUtil;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.ConsPStack;
import org.pcollections.HashTreePSet;
import org.pcollections.PMap;
import org.pcollections.PSequence;
import org.pcollections.PSet;

public final class CollectionUtil {
    private static final int UNKNOWN_SIZE = -1;

    private CollectionUtil() {
    }

    public static <T> List<T> concatView(List<? extends T> head, List<? extends T> tail) {
        if (head.isEmpty()) {
            return CollectionUtil.makeUnmodifiableAndNonNull(tail);
        }
        if (tail.isEmpty()) {
            return CollectionUtil.makeUnmodifiableAndNonNull(head);
        }
        return new ConsList<T>(head, tail);
    }

    @SafeVarargs
    public static <T> Set<T> union(Collection<? extends T> c1, Collection<? extends T> c2, Collection<? extends T> ... rest) {
        LinkedHashSet<T> union = new LinkedHashSet<T>(c1);
        union.addAll(c2);
        for (Collection<? extends T> ts : rest) {
            union.addAll(ts);
        }
        return union;
    }

    @SafeVarargs
    public static <T> Set<T> intersect(Collection<? extends T> c1, Collection<? extends T> c2, Collection<? extends T> ... rest) {
        LinkedHashSet<T> union = new LinkedHashSet<T>(c1);
        union.retainAll(c2);
        for (Collection<? extends T> ts : rest) {
            union.retainAll(ts);
        }
        return union;
    }

    @SafeVarargs
    public static <T> Set<T> diff(Collection<? extends T> c1, Collection<? extends T> c2, Collection<? extends T> ... rest) {
        LinkedHashSet<T> union = new LinkedHashSet<T>(c1);
        union.removeAll(c2);
        for (Collection<? extends T> ts : rest) {
            union.removeAll(ts);
        }
        return union;
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T first, T ... rest) {
        return CollectionUtil.immutableSetOf(first, rest);
    }

    @SafeVarargs
    public static <T> Set<T> immutableSetOf(T first, T ... rest) {
        if (rest.length == 0) {
            return Collections.singleton(first);
        }
        LinkedHashSet<T> union = new LinkedHashSet<T>();
        union.add(first);
        Collections.addAll(union, rest);
        return Collections.unmodifiableSet(union);
    }

    @SafeVarargs
    public static <T extends Enum<T>> Set<T> immutableEnumSet(T first, T ... rest) {
        return Collections.unmodifiableSet(EnumSet.of(first, rest));
    }

    @SafeVarargs
    public static <T> List<T> listOf(T first, T ... rest) {
        if (rest.length == 0) {
            return ConsPStack.singleton(first);
        }
        ArrayList<T> union = new ArrayList<T>();
        union.add(first);
        union.addAll(Arrays.asList(rest));
        return Collections.unmodifiableList(union);
    }

    public static <K, V> Map<K, V> mapOf(K k0, V v0) {
        return Collections.singletonMap(k0, v0);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> buildMap(Consumer<Map<K, V>> effect) {
        LinkedHashMap map = new LinkedHashMap();
        effect.accept(map);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> buildMap(Map<K, V> initialMap, Consumer<Map<K, V>> effect) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(initialMap);
        effect.accept(map);
        return Collections.unmodifiableMap(map);
    }

    public static <T, R> List<@NonNull R> mapNotNull(Iterable<? extends T> from, Function<? super T, ? extends @Nullable R> f) {
        Iterator<T> it = from.iterator();
        if (!it.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<R> res = new ArrayList<R>();
        while (it.hasNext()) {
            R r = f.apply(it.next());
            if (r == null) continue;
            res.add(r);
        }
        return res;
    }

    public static <K, V> Map<K, V> plus(Map<K, V> m, K k, V v) {
        AssertionUtil.requireParamNotNull("map", m);
        if (m instanceof PMap) {
            return ((PMap)m).plus(k, v);
        }
        if (m.isEmpty()) {
            return Collections.singletonMap(k, v);
        }
        HashMap<K, V> newM = new HashMap<K, V>(m);
        newM.put(k, v);
        return newM;
    }

    public static <V> List<V> plus(List<V> list, V v) {
        if (list instanceof PSequence) {
            return ((PSequence)list).plus(v);
        }
        if (list.isEmpty()) {
            return ConsPStack.singleton(v);
        }
        return ConsPStack.from(list).plus(v);
    }

    public static <V> List<V> emptyList() {
        return ConsPStack.empty();
    }

    @SafeVarargs
    public static <V> Set<V> setUnion(Collection<? extends V> set, V first, V ... newElements) {
        if (set instanceof PSet) {
            return ((PSet)set).plus(first).plusAll(Arrays.asList(newElements));
        }
        LinkedHashSet<V> newSet = new LinkedHashSet<V>(set.size() + 1 + newElements.length);
        newSet.addAll(set);
        newSet.add(first);
        Collections.addAll(newSet, newElements);
        return Collections.unmodifiableSet(newSet);
    }

    public static <K, V> @Nullable K getKeyOfValue(Map<K, V> m, V v) {
        AssertionUtil.requireParamNotNull("map", m);
        for (Map.Entry<K, V> it : m.entrySet()) {
            if (!it.getValue().equals(v)) continue;
            return Objects.requireNonNull(it.getKey(), "This method uses null as a sentinel value");
        }
        return null;
    }

    public static <K, V> Map<K, V> zip(List<? extends @NonNull K> from, List<? extends @NonNull V> to) {
        AssertionUtil.requireParamNotNull("keys", from);
        AssertionUtil.requireParamNotNull("values", to);
        Validate.isTrue((from.size() == to.size() ? 1 : 0) != 0, (String)"Mismatched list sizes %s to %s", (Object[])new Object[]{from, to});
        if (from.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<K, V> map = new HashMap<K, V>(from.size());
        for (int i = 0; i < from.size(); ++i) {
            K key = from.get(i);
            V val = to.get(i);
            Validate.notNull(key);
            Validate.notNull(val);
            map.put(key, val);
        }
        return map;
    }

    public static <K, V> Map<K, V> associateWith(Collection<? extends @NonNull K> keys, Function<? super K, ? extends V> mapper) {
        AssertionUtil.requireParamNotNull("keys", keys);
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        return CollectionUtil.associateWithTo(new HashMap(keys.size()), keys, mapper);
    }

    public static <K, V> Map<K, V> associateWithTo(Map<K, V> collector, Collection<? extends @NonNull K> keys, Function<? super K, ? extends V> mapper) {
        AssertionUtil.requireParamNotNull("collector", collector);
        AssertionUtil.requireParamNotNull("keys", keys);
        AssertionUtil.requireParamNotNull("mapper", mapper);
        for (K key : keys) {
            collector.put(key, mapper.apply(key));
        }
        return collector;
    }

    public static <K, V> Map<K, V> associateBy(Collection<? extends @NonNull V> values, Function<? super V, ? extends K> keyMapper) {
        AssertionUtil.requireParamNotNull("values", values);
        if (values.isEmpty()) {
            return Collections.emptyMap();
        }
        return CollectionUtil.associateByTo(new HashMap(values.size()), values, keyMapper);
    }

    public static <K, V> Map<K, V> associateByTo(Map<K, V> collector, Collection<? extends @NonNull V> values, Function<? super V, ? extends K> keyMapper) {
        AssertionUtil.requireParamNotNull("collector", collector);
        AssertionUtil.requireParamNotNull("values", values);
        AssertionUtil.requireParamNotNull("keyMapper", keyMapper);
        for (V v : values) {
            collector.put(keyMapper.apply(v), v);
        }
        return collector;
    }

    public static <T, R> List<R> map(Collection<? extends T> from, Function<? super T, ? extends R> f) {
        if (from == null) {
            return CollectionUtil.emptyList();
        }
        return CollectionUtil.map(from.iterator(), from.size(), f);
    }

    public static <T, R> List<R> map(Iterable<? extends T> from, Function<? super T, ? extends R> f) {
        if (from == null) {
            return CollectionUtil.emptyList();
        }
        return CollectionUtil.map(from.iterator(), -1, f);
    }

    public static <T, R> List<R> map(T[] from, Function<? super T, ? extends R> f) {
        if (from == null) {
            return CollectionUtil.emptyList();
        }
        return CollectionUtil.map(Arrays.asList(from), f);
    }

    public static <T, R> List<R> map(Iterator<? extends T> from, Function<? super T, ? extends R> f) {
        if (from == null) {
            return CollectionUtil.emptyList();
        }
        return CollectionUtil.map(from, -1, f);
    }

    private static <T, R> List<R> map(Iterator<? extends T> from, int sizeHint, Function<? super T, ? extends R> f) {
        ArrayList<R> res;
        if (!from.hasNext()) {
            return CollectionUtil.emptyList();
        }
        if (sizeHint == 1) {
            return ConsPStack.singleton(f.apply(from.next()));
        }
        ArrayList<Object> arrayList = res = sizeHint == -1 ? new ArrayList<R>() : new ArrayList(sizeHint);
        while (from.hasNext()) {
            res.add(f.apply(from.next()));
        }
        return Collections.unmodifiableList(res);
    }

    public static <T, U, A, C> C map(Collector<? super U, A, ? extends C> collector, Iterable<? extends T> from, Function<? super T, ? extends U> f) {
        if (from == null) {
            return CollectionUtil.map(collector, Collections.emptyIterator(), f);
        }
        return CollectionUtil.map(collector, from.iterator(), f);
    }

    public static <T, U, A, C> C map(Collector<? super U, A, ? extends C> collector, Iterator<? extends T> from, Function<? super T, ? extends U> f) {
        Object a = collector.supplier().get();
        BiConsumer accumulator = collector.accumulator();
        from.forEachRemaining(t -> accumulator.accept(a, (Object)f.apply(t)));
        return CollectionUtil.finish(collector, a);
    }

    public static <T> Collector<T, ?, List<T>> toMutableList() {
        return Collectors.toCollection(ArrayList::new);
    }

    public static <T> Collector<T, ?, Set<T>> toMutableSet() {
        return Collectors.toCollection(LinkedHashSet::new);
    }

    public static <T> Collector<T, ?, List<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(CollectionUtil.toMutableList(), Collections::unmodifiableList);
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiableSet() {
        return Collectors.collectingAndThen(CollectionUtil.toMutableSet(), Collections::unmodifiableSet);
    }

    public static <T> Collector<T, ?, PSet<T>> toPersistentSet() {
        class Holder {
            PSet<T> set = HashTreePSet.empty();

            Holder() {
            }
        }
        return Collector.of(() -> new Holder(), (h, t) -> {
            h.set = h.set.plus(t);
        }, (left, right) -> {
            left.set = left.set.plusAll(right.set);
            return left;
        }, a -> a.set, new Collector.Characteristics[0]);
    }

    public static <V, A, C> C finish(Collector<? super V, A, ? extends C> collector, A acc) {
        if (collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return (C)acc;
        }
        return collector.finisher().apply(acc);
    }

    public static <T> List<T> drop(List<T> list, int n) {
        AssertionUtil.requireNonNegative("n", n);
        return list.size() <= n ? CollectionUtil.emptyList() : list.subList(n, list.size());
    }

    public static <T> List<T> take(List<T> list, int n) {
        AssertionUtil.requireNonNegative("n", n);
        return list.size() <= n ? list : list.subList(0, n);
    }

    public static <T> List<T> listOfNotNull(T t) {
        return t == null ? CollectionUtil.emptyList() : ConsPStack.singleton(t);
    }

    public static <N> boolean any(@Nullable Iterable<? extends N> list, Predicate<? super N> predicate) {
        return list != null && IteratorUtil.anyMatch(list.iterator(), predicate);
    }

    public static <N> boolean all(@Nullable Iterable<? extends N> list, Predicate<? super N> predicate) {
        return list == null || IteratorUtil.allMatch(list.iterator(), predicate);
    }

    public static <N> boolean none(@Nullable Iterable<? extends N> list, Predicate<? super N> predicate) {
        return list == null || IteratorUtil.noneMatch(list.iterator(), predicate);
    }

    public static <T> @Nullable T asSingle(Set<T> set) {
        if (set.size() == 1) {
            return set.iterator().next();
        }
        return null;
    }

    public static <T> List<T> defensiveUnmodifiableCopy(List<? extends T> list) {
        if (list instanceof PSequence) {
            return list;
        }
        if (list.isEmpty()) {
            return ConsPStack.empty();
        }
        if (list.size() == 1) {
            return ConsPStack.singleton(list.get(0));
        }
        return ConsPStack.from(list);
    }

    public static <T> Set<T> defensiveUnmodifiableCopyToSet(Collection<? extends T> list) {
        if (list.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new LinkedHashSet<T>(list));
    }

    public static <T> StringBuilder joinOn(StringBuilder sb, Iterable<? extends T> iterable, BiConsumer<? super StringBuilder, ? super T> appendItem, String delimiter) {
        boolean first = true;
        for (T t : iterable) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            appendItem.accept((StringBuilder)((StringBuilder)sb), (StringBuilder)t);
        }
        return sb;
    }

    public static @NonNull StringBuilder joinCharsIntoStringBuilder(List<Chars> lines, String delimiter) {
        return CollectionUtil.joinOn(new StringBuilder(), lines, (buf, line) -> line.appendChars((StringBuilder)buf), delimiter);
    }

    public static <K, V> void mergeMaps(Map<K, V> result, Map<K, V> other, BinaryOperator<V> mergeFun) {
        for (K otherKey : other.keySet()) {
            V otherInfo = other.get(otherKey);
            result.merge(otherKey, otherInfo, mergeFun);
        }
    }

    public static <T> @NonNull List<T> makeUnmodifiableAndNonNull(@Nullable List<? extends T> list) {
        if (list instanceof PSequence) {
            return list;
        }
        return list == null || list.isEmpty() ? CollectionUtil.emptyList() : Collections.unmodifiableList(list);
    }
}

