/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.internal.xml;

import com.github.oowekyala.ooxml.DomUtils;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.internal.xml.PmdXmlReporter;
import net.sourceforge.pmd.util.internal.xml.SchemaConstant;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlUtil {
    private XmlUtil() {
    }

    public static Stream<Element> getElementChildren(Element parent) {
        return DomUtils.asList((NodeList)parent.getChildNodes()).stream().filter(it -> it.getNodeType() == 1).map(Element.class::cast);
    }

    public static List<Element> getElementChildrenList(Element parent) {
        return XmlUtil.getElementChildren(parent).collect(Collectors.toList());
    }

    public static Stream<Element> getElementChildrenNamed(Element parent, Set<SchemaConstant> names) {
        return XmlUtil.getElementChildren(parent).filter(e -> XmlUtil.matchesName(e, names));
    }

    public static Stream<Element> getElementChildrenNamedReportOthers(Element parent, Set<SchemaConstant> names, PmdXmlReporter err) {
        return XmlUtil.getElementChildren(parent).map(it -> {
            if (XmlUtil.matchesName(it, names)) {
                return it;
            }
            ((PmdReporter)err.at((Node)it)).warn("Unexpected element ''{0}'' in {1}, this will be ignored", it.getTagName(), XmlUtil.formatPossibleNames(names));
            return null;
        }).filter(Objects::nonNull);
    }

    public static boolean matchesName(Element elt, Set<SchemaConstant> names) {
        return names.stream().anyMatch(it -> it.xmlName().equals(elt.getTagName()));
    }

    public static void reportIgnoredUnexpectedElt(Element parent, Element unexpectedChild, Set<SchemaConstant> names, PmdXmlReporter err) {
        ((PmdReporter)err.at(unexpectedChild)).warn("Unexpected element ''{0}'' in {1}, expecting {2}, this will be ignored", unexpectedChild.getTagName(), parent.getTagName(), XmlUtil.formatPossibleNames(names));
    }

    public static Stream<Element> getElementChildrenNamed(Element parent, String name) {
        return XmlUtil.getElementChildren(parent).filter(e -> name.equals(e.getTagName()));
    }

    public static List<Element> getChildrenExpectSingleName(Element elt, String name, PmdXmlReporter err) {
        return XmlUtil.getElementChildren(elt).peek(it -> {
            if (!it.getTagName().equals(name)) {
                ((PmdReporter)err.at((Node)it)).warn("Unexpected element ''{0}'' in {1}, this will be ignored", it.getTagName(), name);
            }
        }).collect(Collectors.toList());
    }

    public static Element getSingleChildIn(Element elt, boolean throwOnMissing, PmdXmlReporter err, Set<SchemaConstant> names) {
        List children = XmlUtil.getElementChildrenNamed(elt, names).collect(Collectors.toList());
        if (children.size() == 1) {
            return (Element)children.get(0);
        }
        if (children.isEmpty()) {
            if (throwOnMissing) {
                throw ((PmdReporter)err.at(elt)).error("Required child element named ''{0}'' is missing", XmlUtil.formatPossibleNames(names));
            }
            return null;
        }
        for (int i = 1; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            ((PmdReporter)err.at(child)).warn("Duplicated child with name ''{0}'', this will be ignored", child.getTagName());
        }
        return (Element)children.get(0);
    }

    public static Set<SchemaConstant> toConstants(Set<String> names) {
        return CollectionUtil.map(Collectors.toSet(), names, SchemaConstant::new);
    }

    public static @Nullable String formatPossibleNames(Set<SchemaConstant> names) {
        if (names.isEmpty()) {
            return null;
        }
        if (names.size() == 1) {
            return StringUtil.inSingleQuotes(names.iterator().next().xmlName());
        }
        return "one of " + names.stream().map(SchemaConstant::xmlName).map(StringUtil::inSingleQuotes).collect(Collectors.joining(", "));
    }

    public static String parseTextNode(Node node) {
        int nodeCount = node.getChildNodes().getLength();
        if (nodeCount == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < nodeCount; ++i) {
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() != 4 && childNode.getNodeType() != 3) continue;
            buffer.append(childNode.getNodeValue());
        }
        return buffer.toString();
    }
}

