/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.util.IteratorUtil;

public class Match
implements Comparable<Match>,
Iterable<Mark> {
    private final int tokenCount;
    private final Set<Mark> markSet = new TreeSet<Mark>();
    public static final Comparator<Match> MATCHES_COMPARATOR = (ma, mb) -> mb.getMarkCount() - ma.getMarkCount();
    public static final Comparator<Match> LINES_COMPARATOR = (ma, mb) -> mb.getLineCount() - ma.getLineCount();

    Match(int tokenCount, Mark first, Mark second) {
        this.markSet.add(first);
        this.markSet.add(second);
        this.tokenCount = tokenCount;
    }

    Match(int tokenCount, TokenEntry first, TokenEntry second) {
        this(tokenCount, new Mark(first), new Mark(second));
    }

    void addMark(TokenEntry entry) {
        this.markSet.add(new Mark(entry));
    }

    public int getMarkCount() {
        return this.markSet.size();
    }

    public int getLineCount() {
        return this.getMark(0).getLocation().getLineCount();
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public Set<Mark> getMarkSet() {
        return Collections.unmodifiableSet(this.markSet);
    }

    @Override
    public Iterator<Mark> iterator() {
        return this.markSet.iterator();
    }

    @Override
    public int compareTo(Match other) {
        int diff = other.getTokenCount() - this.getTokenCount();
        if (diff != 0) {
            return diff;
        }
        return this.getFirstMark().compareTo(other.getFirstMark());
    }

    public Mark getFirstMark() {
        return this.getMark(0);
    }

    public Mark getSecondMark() {
        return this.getMark(1);
    }

    public String toString() {
        return "Match: \ntokenCount = " + this.tokenCount + "\nmarks = " + this.markSet.size();
    }

    public int getEndIndex() {
        return this.getMark(0).getToken().getIndex() + this.getTokenCount() - 1;
    }

    private Mark getMark(int index) {
        if (index >= this.markSet.size()) {
            throw new NoSuchElementException();
        }
        return IteratorUtil.getNth(this.markSet.iterator(), index);
    }
}

