/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.TokenFactory;
import net.sourceforge.pmd.lang.ast.LexException;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextDocument;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Tokens {
    private final List<TokenEntry> tokens = new ArrayList<TokenEntry>();
    private final Map<String, Integer> images = new HashMap<String, Integer>();
    private int curImageId = 1;

    Tokens() {
    }

    private void add(TokenEntry tokenEntry) {
        this.tokens.add(tokenEntry);
    }

    private void addEof(FileId filePathId, int line, int column) {
        this.add(new TokenEntry(filePathId, line, column));
    }

    private void setImage(TokenEntry entry, String newImage) {
        int i = this.getImageId(newImage);
        entry.setImageIdentifier(i);
    }

    private int getImageId(String newImage) {
        return this.images.computeIfAbsent(newImage, k -> this.curImageId++);
    }

    String imageFromId(int i) {
        return this.images.entrySet().stream().filter(it -> (Integer)it.getValue() == i).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    private TokenEntry peekLastToken() {
        return this.tokens.isEmpty() ? null : this.getToken(this.size() - 1);
    }

    private TokenEntry getToken(int index) {
        return this.tokens.get(index);
    }

    public int size() {
        return this.tokens.size();
    }

    TokenEntry getEndToken(TokenEntry mark, Match match) {
        return this.getToken(mark.getIndex() + match.getTokenCount() - 1);
    }

    public List<TokenEntry> getTokens() {
        return this.tokens;
    }

    TokenEntry addToken(String image, FileId fileName, int startLine, int startCol, int endLine, int endCol) {
        TokenEntry newToken = new TokenEntry(this.getImageId(image), fileName, startLine, startCol, endLine, endCol, this.tokens.size());
        this.add(newToken);
        return newToken;
    }

    State savePoint() {
        return new State(this);
    }

    static TokenFactory factoryForFile(final TextDocument file, final Tokens tokens) {
        return new TokenFactory(){
            final FileId fileId;
            final int firstToken;
            {
                this.fileId = file.getFileId();
                this.firstToken = tokens.size();
            }

            @Override
            public void recordToken(@NonNull String image, int startLine, int startCol, int endLine, int endCol) {
                tokens.addToken(image, this.fileId, startLine, startCol, endLine, endCol);
            }

            @Override
            public void setImage(TokenEntry entry, @NonNull String newImage) {
                tokens.setImage(entry, newImage);
            }

            @Override
            public LexException makeLexException(int line, int column, String message, @Nullable Throwable cause) {
                return new LexException(line, column, this.fileId, message, cause);
            }

            @Override
            public @Nullable TokenEntry peekLastToken() {
                if (tokens.size() <= this.firstToken) {
                    return null;
                }
                return tokens.peekLastToken();
            }

            @Override
            public void close() {
                TokenEntry tok = this.peekLastToken();
                if (tok == null) {
                    tokens.addEof(this.fileId, 1, 1);
                } else {
                    tokens.addEof(this.fileId, tok.getEndLine(), tok.getEndColumn());
                }
            }
        };
    }

    static final class State {
        private final int tokenCount;
        private final int curImageId;

        State(Tokens tokens) {
            this.tokenCount = tokens.tokens.size();
            this.curImageId = tokens.curImageId;
        }

        public void restore(Tokens tokens) {
            tokens.images.entrySet().removeIf(e -> (Integer)e.getValue() >= this.curImageId);
            tokens.curImageId = this.curImageId;
            List<TokenEntry> entries = tokens.getTokens();
            entries.subList(this.tokenCount, entries.size()).clear();
        }
    }
}

