/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal.util;

import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IOUtil {
    public static final char UTF_BOM = '\ufeff';
    public static final int EOF = -1;
    private static final int BUFFER_SIZE = 8192;

    private IOUtil() {
    }

    public static Writer createWriter() {
        return IOUtil.createWriter(null);
    }

    private static Charset getDefaultCharset() {
        String csn = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("file.encoding");
            }
        });
        try {
            return Charset.forName(csn);
        }
        catch (UnsupportedCharsetException e) {
            return StandardCharsets.UTF_8;
        }
    }

    public static Writer createWriter(String reportFile) {
        return IOUtil.createWriter(IOUtil.getDefaultCharset(), reportFile);
    }

    public static Writer createWriter(Charset charset, @Nullable String reportFile) {
        try {
            if (StringUtils.isBlank((CharSequence)reportFile)) {
                return new OutputStreamWriter((OutputStream)new FilterOutputStream(System.out){

                    @Override
                    public void close() {
                        try {
                            this.out.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        this.out.write(b, off, len);
                    }
                }, charset);
            }
            Path path = new File(reportFile).toPath().toAbsolutePath();
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            return Files.newBufferedWriter(path, charset, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void tryCloseClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof Closeable) {
            IOUtil.closeQuietly((Closeable)((Object)classLoader));
        }
    }

    public static Exception closeAll(Collection<? extends AutoCloseable> closeables) {
        Exception composed = null;
        for (AutoCloseable autoCloseable : closeables) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                if (composed == null) {
                    composed = e;
                    continue;
                }
                composed.addSuppressed(e);
            }
        }
        return composed;
    }

    public static void ensureClosed(List<? extends AutoCloseable> toClose, @Nullable Exception pendingException) throws Exception {
        Exception closeException = IOUtil.closeAll(toClose);
        if (closeException != null) {
            if (pendingException != null) {
                closeException.addSuppressed(pendingException);
                throw closeException;
            }
        } else if (pendingException != null) {
            throw pendingException;
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        byte[] result = new byte[]{};
        byte[] buffer = new byte[8192];
        int count = stream.read(buffer);
        while (count > -1) {
            byte[] newResult = new byte[result.length + count];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(buffer, 0, newResult, result.length, count);
            result = newResult;
            count = stream.read(buffer);
        }
        return result;
    }

    public static long skipFully(InputStream stream, long n) throws IOException {
        int count;
        long bytesToSkip;
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        byte[] buffer = new byte[(int)Math.min(8192L, bytesToSkip)];
        for (bytesToSkip = n; bytesToSkip > 0L && (count = stream.read(buffer, 0, (int)Math.min(8192L, bytesToSkip))) >= 0; bytesToSkip -= (long)count) {
        }
        return n - bytesToSkip;
    }

    public static String normalizePath(String path) {
        Path path1 = Paths.get(path, new String[0]);
        String normalized = path1.normalize().toString();
        if (normalized.contains("." + File.separator) || normalized.contains(".." + File.separator) || "".equals(normalized)) {
            return null;
        }
        return normalized;
    }

    public static boolean equalsNormalizedPaths(String path1, String path2) {
        return Objects.equals(IOUtil.normalizePath(path1), IOUtil.normalizePath(path2));
    }

    public static String getFilenameExtension(String name) {
        String filename = Paths.get(name, new String[0]).getFileName().toString();
        int dot = filename.lastIndexOf(46);
        if (dot > -1) {
            return filename.substring(dot + 1);
        }
        return "";
    }

    public static String getFilenameBase(String name) {
        String filename = Paths.get(name, new String[0]).getFileName().toString();
        int dot = filename.lastIndexOf(46);
        if (dot > -1) {
            return filename.substring(0, dot);
        }
        return filename;
    }

    public static void copy(InputStream from, OutputStream to) throws IOException {
        byte[] buffer = new byte[8192];
        int count = from.read(buffer);
        while (count > -1) {
            to.write(buffer, 0, count);
            count = from.read(buffer);
        }
    }

    public static void copy(Reader from, Writer to) throws IOException {
        char[] buffer = new char[8192];
        int count = from.read(buffer);
        while (count > -1) {
            to.write(buffer, 0, count);
            count = from.read(buffer);
        }
    }

    public static String readFileToString(File file) throws IOException {
        return IOUtil.readFileToString(file, Charset.defaultCharset());
    }

    public static String readFileToString(File file, Charset charset) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        return charset.decode(ByteBuffer.wrap(bytes)).toString();
    }

    public static String readToString(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder(8192);
        char[] buffer = new char[8192];
        int count = reader.read(buffer);
        while (count > -1) {
            sb.append(buffer, 0, count);
            count = reader.read(buffer);
        }
        return sb.toString();
    }

    public static String readToString(InputStream stream, Charset charset) throws IOException {
        byte[] bytes = IOUtil.toByteArray(stream);
        return charset.decode(ByteBuffer.wrap(bytes)).toString();
    }

    public static InputStream fromReader(Reader reader) throws IOException {
        class ReaderInputStream
        extends InputStream {
            private final Reader reader;
            private final CharBuffer charBuffer = CharBuffer.allocate(8192);
            private final ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
            private final CharsetEncoder encoder;
            private boolean eof;

            ReaderInputStream(Reader reader) {
                this.reader = reader;
                this.encoder = Charset.defaultCharset().newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.charBuffer.clear();
                this.byteBuffer.clear();
                this.byteBuffer.flip();
            }

            @Override
            public int read() throws IOException {
                if (!this.byteBuffer.hasRemaining()) {
                    if (this.charBuffer.hasRemaining() && !this.eof) {
                        int count = this.reader.read(this.charBuffer);
                        this.eof = count == -1;
                    }
                    this.byteBuffer.clear();
                    this.charBuffer.flip();
                    this.encoder.encode(this.charBuffer, this.byteBuffer, this.eof);
                    this.byteBuffer.flip();
                    this.charBuffer.compact();
                }
                if (this.byteBuffer.hasRemaining()) {
                    return this.byteBuffer.get();
                }
                return -1;
            }

            @Override
            public int available() throws IOException {
                return this.byteBuffer.remaining();
            }

            @Override
            public void close() throws IOException {
                this.reader.close();
            }
        }
        return new ReaderInputStream(reader);
    }

    public static OutputStream fromWriter(Writer writer, String encoding) throws UnsupportedCharsetException {
        class WriterOutputStream
        extends OutputStream {
            private final Writer writer;
            private final CharsetDecoder decoder;
            private final ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
            private final CharBuffer charBuffer = CharBuffer.allocate(8192);

            WriterOutputStream(Writer writer, String encoding) throws UnsupportedCharsetException {
                this.writer = writer;
                Charset charset = Charset.forName(encoding);
                this.decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.byteBuffer.clear();
                this.charBuffer.clear();
            }

            @Override
            public void write(int b) throws IOException {
                if (!this.byteBuffer.hasRemaining()) {
                    this.decodeByteBuffer(false);
                }
                this.byteBuffer.put((byte)b);
            }

            @Override
            public void flush() throws IOException {
                this.decodeByteBuffer(false);
            }

            private void decodeByteBuffer(boolean isClosing) throws IOException {
                this.byteBuffer.flip();
                this.charBuffer.clear();
                this.decoder.decode(this.byteBuffer, this.charBuffer, isClosing);
                this.writer.write(this.charBuffer.array(), 0, this.charBuffer.position());
                this.writer.flush();
                this.byteBuffer.compact();
            }

            @Override
            public void close() throws IOException {
                this.flush();
                this.decodeByteBuffer(true);
                this.writer.close();
            }
        }
        return new WriterOutputStream(writer, encoding);
    }

    public static class BomAwareInputStream
    extends FilterInputStream {
        private byte[] begin = this.determineBom();
        int beginIndex;
        private String charset;

        public BomAwareInputStream(InputStream in) {
            super(in);
        }

        private byte[] determineBom() {
            byte[] bytes = new byte[3];
            try {
                int count = this.in.read(bytes);
                if (count == 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                    this.charset = StandardCharsets.UTF_8.name();
                    return new byte[0];
                }
                if (count >= 2 && bytes[0] == -2 && bytes[1] == -1) {
                    this.charset = StandardCharsets.UTF_16BE.name();
                    return new byte[]{bytes[2]};
                }
                if (count >= 2 && bytes[0] == -1 && bytes[1] == -2) {
                    this.charset = StandardCharsets.UTF_16LE.name();
                    return new byte[]{bytes[2]};
                }
                if (count == 3) {
                    return bytes;
                }
                if (count < 0) {
                    return new byte[0];
                }
                byte[] read = new byte[count];
                for (int i = 0; i < count; ++i) {
                    read[i] = bytes[i];
                }
                return read;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.beginIndex < this.begin.length) {
                return this.begin[this.beginIndex++];
            }
            return super.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.beginIndex < this.begin.length) {
                int count = 0;
                while (count < len && this.beginIndex < this.begin.length) {
                    b[off + count] = this.begin[this.beginIndex];
                    ++count;
                    ++this.beginIndex;
                }
                return count;
            }
            return super.read(b, off, len);
        }

        public boolean hasBom() {
            return this.charset != null;
        }

        public String getBomCharsetName() {
            return this.charset;
        }
    }
}

