/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import java.util.Objects;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.FileAnalysisException;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.util.AssertionUtil;

public interface Parser {
    public RootNode parse(ParserTask var1) throws FileAnalysisException;

    public static final class ParserTask {
        private final TextDocument textDoc;
        private final SemanticErrorReporter reporter;
        private final LanguageProcessorRegistry lpRegistry;

        public ParserTask(TextDocument textDoc, SemanticErrorReporter reporter, LanguageProcessorRegistry lpRegistry) {
            this.textDoc = AssertionUtil.requireParamNotNull("Text document", textDoc);
            this.reporter = AssertionUtil.requireParamNotNull("reporter", reporter);
            this.lpRegistry = AssertionUtil.requireParamNotNull("lpRegistry", lpRegistry);
            Objects.requireNonNull(lpRegistry.getProcessor(textDoc.getLanguageVersion().getLanguage()));
        }

        public LanguageVersion getLanguageVersion() {
            return this.textDoc.getLanguageVersion();
        }

        public FileId getFileId() {
            return this.textDoc.getFileId();
        }

        public TextDocument getTextDocument() {
            return this.textDoc;
        }

        public String getSourceText() {
            return this.getTextDocument().getText().toString();
        }

        public SemanticErrorReporter getReporter() {
            return this.reporter;
        }

        public LanguageProcessorRegistry getLpRegistry() {
            return this.lpRegistry;
        }

        public LanguageProcessor getLanguageProcessor() {
            return this.lpRegistry.getProcessor(this.getLanguageVersion().getLanguage());
        }

        public ParserTask withTextDocument(TextDocument textDocument) {
            return new ParserTask(textDocument, this.reporter, this.lpRegistry);
        }
    }
}

