/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.util.Iterator;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;

public class VBHTMLRenderer
extends AbstractIncrementingRenderer {
    public static final String NAME = "vbhtml";

    public VBHTMLRenderer() {
        super(NAME, "Vladimir Bossicard HTML format.");
    }

    @Override
    public String defaultFileExtension() {
        return "vb.html";
    }

    @Override
    public void start() throws IOException {
        this.getWriter().write(this.header());
    }

    @Override
    public void renderFileViolations(Iterator<RuleViolation> violations) throws IOException {
        if (!violations.hasNext()) {
            return;
        }
        StringBuilder sb = new StringBuilder(500);
        String filename = null;
        String lineSep = System.lineSeparator();
        boolean colorize = false;
        while (violations.hasNext()) {
            sb.setLength(0);
            RuleViolation rv = violations.next();
            String nextFilename = this.determineFileName(rv.getFileId());
            if (!nextFilename.equals(filename)) {
                if (filename != null) {
                    sb.append("</table></br>");
                    colorize = false;
                }
                filename = nextFilename;
                sb.append("<table border=\"0\" width=\"80%\">");
                sb.append("<tr id=TableHeader><td colspan=\"2\"><font class=title>&nbsp;").append(filename).append("</font></tr>");
                sb.append(lineSep);
            }
            if (colorize) {
                sb.append("<tr id=RowColor1>");
            } else {
                sb.append("<tr id=RowColor2>");
            }
            colorize = !colorize;
            sb.append("<td width=\"50\" align=\"right\"><font class=body>").append(rv.getBeginLine()).append("&nbsp;&nbsp;&nbsp;</font></td>");
            sb.append("<td><font class=body>").append(rv.getDescription()).append("</font></td>");
            sb.append("</tr>");
            sb.append(lineSep);
            this.writer.write(sb.toString());
        }
        if (filename != null) {
            this.writer.write("</table>");
        }
    }

    @Override
    public void end() throws IOException {
        boolean colorize;
        StringBuilder sb = new StringBuilder();
        this.writer.write("<br>");
        if (!this.errors.isEmpty()) {
            sb.setLength(0);
            sb.append("<table border=\"0\" width=\"80%\">");
            sb.append("<tr id=TableHeader><td colspan=\"2\"><font class=title>&nbsp;Problems found</font></td></tr>");
            colorize = false;
            for (Object error : this.errors) {
                if (colorize) {
                    sb.append("<tr id=RowColor1>");
                } else {
                    sb.append("<tr id=RowColor2>");
                }
                colorize = !colorize;
                sb.append("<td><font class=body>").append(this.determineFileName(((Report.ProcessingError)error).getFileId())).append("</font></td>");
                sb.append("<td><font class=body><pre>").append(((Report.ProcessingError)error).getDetail()).append("</pre></font></td></tr>");
            }
            sb.append("</table>");
            this.writer.write(sb.toString());
        }
        if (!this.configErrors.isEmpty()) {
            sb.setLength(0);
            sb.append("<table border=\"0\" width=\"80%\">");
            sb.append("<tr id=TableHeader><td colspan=\"2\"><font class=title>&nbsp;Configuration problems found</font></td></tr>");
            colorize = false;
            for (Object error : this.configErrors) {
                if (colorize) {
                    sb.append("<tr id=RowColor1>");
                } else {
                    sb.append("<tr id=RowColor2>");
                }
                colorize = !colorize;
                sb.append("<td><font class=body>").append(((Report.ConfigurationError)error).rule().getName()).append("</font></td>");
                sb.append("<td><font class=body>").append(((Report.ConfigurationError)error).issue()).append("</font></td></tr>");
            }
            sb.append("</table>");
            this.writer.write(sb.toString());
        }
        this.writer.write(this.footer());
    }

    private String header() {
        return "<html><head><title>PMD</title></head><style type=\"text/css\"><!--" + System.lineSeparator() + "body { background-color: white; font-family:verdana, arial, helvetica, geneva; font-size: 16px; font-style: italic; color: black; }" + System.lineSeparator() + ".title { font-family: verdana, arial, helvetica,geneva; font-size: 12px; font-weight:bold; color: white; }" + System.lineSeparator() + ".body { font-family: verdana, arial, helvetica, geneva; font-size: 12px; font-weight:plain; color: black; }" + System.lineSeparator() + "#TableHeader { background-color: #003366; }" + System.lineSeparator() + "#RowColor1 { background-color: #eeeeee; }" + System.lineSeparator() + "#RowColor2 { background-color: white; }" + System.lineSeparator() + "--></style><body><center>";
    }

    private String footer() {
        return "</center></body></html>" + System.lineSeparator();
    }
}

