/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers.internal.sarif;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class SarifLog {
    @SerializedName(value="$schema")
    private String schema;
    private String version;
    private List<Run> runs;

    private static String defaultSchema() {
        return "https://json.schemastore.org/sarif-2.1.0.json";
    }

    private static String defaultVersion() {
        return "2.1.0";
    }

    private SarifLog(String schema, String version, List<Run> runs) {
        this.schema = schema;
        this.version = version;
        this.runs = runs;
    }

    public static SarifLogBuilder builder() {
        return new SarifLogBuilder();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Run> getRuns() {
        return this.runs;
    }

    public SarifLog setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public SarifLog setVersion(String version) {
        this.version = version;
        return this;
    }

    public SarifLog setRuns(List<Run> runs) {
        this.runs = runs;
        return this;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SarifLog sarifLog = (SarifLog)o;
        return Objects.equals(this.schema, sarifLog.schema) && Objects.equals(this.version, sarifLog.version) && Objects.equals(this.runs, sarifLog.runs);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.version, this.runs);
    }

    public String toString() {
        return "SarifLog(schema=" + this.getSchema() + ", version=" + this.getVersion() + ", runs=" + this.getRuns() + ")";
    }

    public static final class SarifLogBuilder {
        private boolean schemaSet;
        private String schemaValue;
        private boolean versionSet;
        private String versionValue;
        private List<Run> runs;

        private SarifLogBuilder() {
        }

        public SarifLogBuilder schema(String schema) {
            this.schemaValue = schema;
            this.schemaSet = true;
            return this;
        }

        public SarifLogBuilder version(String version) {
            this.versionValue = version;
            this.versionSet = true;
            return this;
        }

        public SarifLogBuilder runs(List<Run> runs) {
            this.runs = runs;
            return this;
        }

        public SarifLog build() {
            String schemaValue = this.schemaValue;
            if (!this.schemaSet) {
                schemaValue = SarifLog.defaultSchema();
            }
            String versionValue = this.versionValue;
            if (!this.versionSet) {
                versionValue = SarifLog.defaultVersion();
            }
            return new SarifLog(schemaValue, versionValue, this.runs);
        }

        public String toString() {
            return "SarifLog.SarifLogBuilder(schema$value=" + this.schemaValue + ", version$value=" + this.versionValue + ", runs=" + this.runs + ")";
        }
    }

    public static final class Invocation {
        private Boolean executionSuccessful;
        private List<ToolConfigurationNotification> toolConfigurationNotifications;
        private List<ToolExecutionNotification> toolExecutionNotifications;

        private Invocation(Boolean executionSuccessful, List<ToolConfigurationNotification> toolConfigurationNotifications, List<ToolExecutionNotification> toolExecutionNotifications) {
            this.executionSuccessful = executionSuccessful;
            this.toolConfigurationNotifications = toolConfigurationNotifications;
            this.toolExecutionNotifications = toolExecutionNotifications;
        }

        public static InvocationBuilder builder() {
            return new InvocationBuilder();
        }

        public InvocationBuilder toBuilder() {
            return new InvocationBuilder().executionSuccessful(this.executionSuccessful).toolConfigurationNotifications(this.toolConfigurationNotifications).toolExecutionNotifications(this.toolExecutionNotifications);
        }

        public Boolean getExecutionSuccessful() {
            return this.executionSuccessful;
        }

        public List<ToolConfigurationNotification> getToolConfigurationNotifications() {
            return this.toolConfigurationNotifications;
        }

        public List<ToolExecutionNotification> getToolExecutionNotifications() {
            return this.toolExecutionNotifications;
        }

        public Invocation setExecutionSuccessful(Boolean executionSuccessful) {
            this.executionSuccessful = executionSuccessful;
            return this;
        }

        public Invocation setToolConfigurationNotifications(List<ToolConfigurationNotification> toolConfigurationNotifications) {
            this.toolConfigurationNotifications = toolConfigurationNotifications;
            return this;
        }

        public Invocation setToolExecutionNotifications(List<ToolExecutionNotification> toolExecutionNotifications) {
            this.toolExecutionNotifications = toolExecutionNotifications;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Invocation that = (Invocation)o;
            return Objects.equals(this.executionSuccessful, that.executionSuccessful) && Objects.equals(this.toolConfigurationNotifications, that.toolConfigurationNotifications) && Objects.equals(this.toolExecutionNotifications, that.toolExecutionNotifications);
        }

        public int hashCode() {
            return Objects.hash(this.executionSuccessful, this.toolConfigurationNotifications, this.toolExecutionNotifications);
        }

        public String toString() {
            return "SarifLog.Invocation(executionSuccessful=" + this.getExecutionSuccessful() + ", toolConfigurationNotifications=" + this.getToolConfigurationNotifications() + ", toolExecutionNotifications=" + this.getToolExecutionNotifications() + ")";
        }

        public static final class InvocationBuilder {
            private Boolean executionSuccessful;
            private List<ToolConfigurationNotification> toolConfigurationNotifications;
            private List<ToolExecutionNotification> toolExecutionNotifications;

            private InvocationBuilder() {
            }

            public InvocationBuilder executionSuccessful(Boolean executionSuccessful) {
                this.executionSuccessful = executionSuccessful;
                return this;
            }

            public InvocationBuilder toolConfigurationNotifications(List<ToolConfigurationNotification> toolConfigurationNotifications) {
                this.toolConfigurationNotifications = toolConfigurationNotifications;
                return this;
            }

            public InvocationBuilder toolExecutionNotifications(List<ToolExecutionNotification> toolExecutionNotifications) {
                this.toolExecutionNotifications = toolExecutionNotifications;
                return this;
            }

            public Invocation build() {
                return new Invocation(this.executionSuccessful, this.toolConfigurationNotifications, this.toolExecutionNotifications);
            }

            public String toString() {
                return "SarifLog.Invocation.InvocationBuilder(executionSuccessful=" + this.executionSuccessful + ", toolConfigurationNotifications=" + this.toolConfigurationNotifications + ", toolExecutionNotifications=" + this.toolExecutionNotifications + ")";
            }
        }
    }

    public static final class ToolExecutionNotification {
        private List<Location> locations;
        private Message message;
        private Exception exception;

        private ToolExecutionNotification(List<Location> locations, Message message, Exception exception) {
            this.locations = locations;
            this.message = message;
            this.exception = exception;
        }

        public static ToolExecutionNotificationBuilder builder() {
            return new ToolExecutionNotificationBuilder();
        }

        public ToolExecutionNotificationBuilder toBuilder() {
            return new ToolExecutionNotificationBuilder().locations(this.locations).message(this.message).exception(this.exception);
        }

        public List<Location> getLocations() {
            return this.locations;
        }

        public Message getMessage() {
            return this.message;
        }

        public Exception getException() {
            return this.exception;
        }

        public ToolExecutionNotification setLocations(List<Location> locations) {
            this.locations = locations;
            return this;
        }

        public ToolExecutionNotification setMessage(Message message) {
            this.message = message;
            return this;
        }

        public ToolExecutionNotification setException(Exception exception) {
            this.exception = exception;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ToolExecutionNotification that = (ToolExecutionNotification)o;
            return Objects.equals(this.locations, that.locations) && Objects.equals(this.message, that.message) && Objects.equals(this.exception, that.exception);
        }

        public int hashCode() {
            return Objects.hash(this.locations, this.message, this.exception);
        }

        public String toString() {
            return "SarifLog.ToolExecutionNotification(locations=" + this.getLocations() + ", message=" + this.getMessage() + ", exception=" + this.getException() + ")";
        }

        public static final class ToolExecutionNotificationBuilder {
            private List<Location> locations;
            private Message message;
            private Exception exception;

            private ToolExecutionNotificationBuilder() {
            }

            public ToolExecutionNotificationBuilder locations(List<Location> locations) {
                this.locations = locations;
                return this;
            }

            public ToolExecutionNotificationBuilder message(Message message) {
                this.message = message;
                return this;
            }

            public ToolExecutionNotificationBuilder exception(Exception exception) {
                this.exception = exception;
                return this;
            }

            public ToolExecutionNotification build() {
                return new ToolExecutionNotification(this.locations, this.message, this.exception);
            }

            public String toString() {
                return "SarifLog.ToolExecutionNotification.ToolExecutionNotificationBuilder(locations=" + this.locations + ", message=" + this.message + ", exception=" + this.exception + ")";
            }
        }
    }

    public static final class ToolConfigurationNotification {
        private AssociatedRule associatedRule;
        private Message message;

        private ToolConfigurationNotification(AssociatedRule associatedRule, Message message) {
            this.associatedRule = associatedRule;
            this.message = message;
        }

        public static ToolConfigurationNotificationBuilder builder() {
            return new ToolConfigurationNotificationBuilder();
        }

        public ToolConfigurationNotificationBuilder toBuilder() {
            return new ToolConfigurationNotificationBuilder().associatedRule(this.associatedRule).message(this.message);
        }

        public AssociatedRule getAssociatedRule() {
            return this.associatedRule;
        }

        public Message getMessage() {
            return this.message;
        }

        public ToolConfigurationNotification setAssociatedRule(AssociatedRule associatedRule) {
            this.associatedRule = associatedRule;
            return this;
        }

        public ToolConfigurationNotification setMessage(Message message) {
            this.message = message;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ToolConfigurationNotification that = (ToolConfigurationNotification)o;
            return Objects.equals(this.associatedRule, that.associatedRule) && Objects.equals(this.message, that.message);
        }

        public int hashCode() {
            return Objects.hash(this.associatedRule, this.message);
        }

        public String toString() {
            return "SarifLog.ToolConfigurationNotification(associatedRule=" + this.getAssociatedRule() + ", message=" + this.getMessage() + ")";
        }

        public static final class ToolConfigurationNotificationBuilder {
            private AssociatedRule associatedRule;
            private Message message;

            private ToolConfigurationNotificationBuilder() {
            }

            public ToolConfigurationNotificationBuilder associatedRule(AssociatedRule associatedRule) {
                this.associatedRule = associatedRule;
                return this;
            }

            public ToolConfigurationNotificationBuilder message(Message message) {
                this.message = message;
                return this;
            }

            public ToolConfigurationNotification build() {
                return new ToolConfigurationNotification(this.associatedRule, this.message);
            }

            public String toString() {
                return "SarifLog.ToolConfigurationNotification.ToolConfigurationNotificationBuilder(associatedRule=" + this.associatedRule + ", message=" + this.message + ")";
            }
        }
    }

    public static final class AssociatedRule {
        private String id;

        private AssociatedRule(String id) {
            this.id = id;
        }

        public static AssociatedRuleBuilder builder() {
            return new AssociatedRuleBuilder();
        }

        public AssociatedRuleBuilder toBuilder() {
            return new AssociatedRuleBuilder().id(this.id);
        }

        public String getId() {
            return this.id;
        }

        public AssociatedRule setId(String id) {
            this.id = id;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssociatedRule that = (AssociatedRule)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }

        public String toString() {
            return "SarifLog.AssociatedRule(id=" + this.getId() + ")";
        }

        public static final class AssociatedRuleBuilder {
            private String id;

            private AssociatedRuleBuilder() {
            }

            public AssociatedRuleBuilder id(String id) {
                this.id = id;
                return this;
            }

            public AssociatedRule build() {
                return new AssociatedRule(this.id);
            }

            public String toString() {
                return "SarifLog.AssociatedRule.AssociatedRuleBuilder(id=" + this.id + ")";
            }
        }
    }

    public static final class Exception {
        private String message;

        private Exception(String message) {
            this.message = message;
        }

        public static ExceptionBuilder builder() {
            return new ExceptionBuilder();
        }

        public ExceptionBuilder toBuilder() {
            return new ExceptionBuilder().message(this.message);
        }

        public String getMessage() {
            return this.message;
        }

        public Exception setMessage(String message) {
            this.message = message;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Exception exception = (Exception)o;
            return Objects.equals(this.message, exception.message);
        }

        public int hashCode() {
            return Objects.hashCode(this.message);
        }

        public String toString() {
            return "SarifLog.Exception(message=" + this.getMessage() + ")";
        }

        public static final class ExceptionBuilder {
            private String message;

            private ExceptionBuilder() {
            }

            public ExceptionBuilder message(String message) {
                this.message = message;
                return this;
            }

            public Exception build() {
                return new Exception(this.message);
            }

            public String toString() {
                return "SarifLog.Exception.ExceptionBuilder(message=" + this.message + ")";
            }
        }
    }

    public static final class MultiformatMessage {
        private String text;
        private String markdown;

        public MultiformatMessage(String text) {
            this.text = text;
        }

        public MultiformatMessage(String text, String markdown) {
            this.text = text;
            this.markdown = markdown;
        }

        public static MultiformatMessageBuilder builder() {
            return new MultiformatMessageBuilder();
        }

        public String getText() {
            return this.text;
        }

        public String getMarkdown() {
            return this.markdown;
        }

        public MultiformatMessage setText(String text) {
            this.text = text;
            return this;
        }

        public MultiformatMessage setMarkdown(String markdown) {
            this.markdown = markdown;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiformatMessage that = (MultiformatMessage)o;
            return Objects.equals(this.text, that.text) && Objects.equals(this.markdown, that.markdown);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.markdown);
        }

        public String toString() {
            return "SarifLog.MultiformatMessage(text=" + this.getText() + ", markdown=" + this.getMarkdown() + ")";
        }

        public static final class MultiformatMessageBuilder {
            private String text;
            private String markdown;

            private MultiformatMessageBuilder() {
            }

            public MultiformatMessageBuilder text(String text) {
                this.text = text;
                return this;
            }

            public MultiformatMessageBuilder markdown(String markdown) {
                this.markdown = markdown;
                return this;
            }

            public MultiformatMessage build() {
                return new MultiformatMessage(this.text, this.markdown);
            }

            public String toString() {
                return "SarifLog.MultiformatMessage.MultiformatMessageBuilder(text=" + this.text + ", markdown=" + this.markdown + ")";
            }
        }
    }

    public static final class ReportingConfiguration {
        private Boolean enabled;
        private String level;
        private Double rank;
        private PropertyBag parameters;

        private ReportingConfiguration(Boolean enabled, String level, Double rank, PropertyBag parameters) {
            this.enabled = enabled;
            this.level = level;
            this.rank = rank;
            this.parameters = parameters;
        }

        public static ReportingConfigurationBuilder builder() {
            return new ReportingConfigurationBuilder();
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public String getLevel() {
            return this.level;
        }

        public Double getRank() {
            return this.rank;
        }

        public PropertyBag getParameters() {
            return this.parameters;
        }

        public ReportingConfiguration setEnabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public ReportingConfiguration setLevel(String level) {
            this.level = level;
            return this;
        }

        public ReportingConfiguration setRank(Double rank) {
            this.rank = rank;
            return this;
        }

        public ReportingConfiguration setParameters(PropertyBag parameters) {
            this.parameters = parameters;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReportingConfiguration that = (ReportingConfiguration)o;
            return Objects.equals(this.enabled, that.enabled) && Objects.equals(this.level, that.level) && Objects.equals(this.rank, that.rank) && Objects.equals(this.parameters, that.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.level, this.rank, this.parameters);
        }

        public String toString() {
            return "SarifLog.ReportingConfiguration(enabled=" + this.getEnabled() + ", level=" + this.getLevel() + ", rank=" + this.getRank() + ", parameters=" + this.getParameters() + ")";
        }

        public static final class ReportingConfigurationBuilder {
            private Boolean enabled;
            private String level;
            private Double rank;
            private PropertyBag parameters;

            private ReportingConfigurationBuilder() {
            }

            public ReportingConfigurationBuilder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public ReportingConfigurationBuilder level(String level) {
                this.level = level;
                return this;
            }

            public ReportingConfigurationBuilder rank(Double rank) {
                this.rank = rank;
                return this;
            }

            public ReportingConfigurationBuilder parameters(PropertyBag parameters) {
                this.parameters = parameters;
                return this;
            }

            public ReportingConfiguration build() {
                return new ReportingConfiguration(this.enabled, this.level, this.rank, this.parameters);
            }

            public String toString() {
                return "SarifLog.ReportingConfiguration.ReportingConfigurationBuilder(enabled=" + this.enabled + ", level=" + this.level + ", rank=" + this.rank + ", parameters=" + this.parameters + ")";
            }
        }
    }

    public static final class ReportingDescriptor {
        private String id;
        private String name;
        private MultiformatMessage shortDescription;
        private MultiformatMessage fullDescription;
        private MultiformatMessage messageStrings;
        private String helpUri;
        private MultiformatMessage help;
        private PropertyBag properties;
        private ReportingConfiguration defaultConfiguration;

        private ReportingDescriptor(String id, String name, MultiformatMessage shortDescription, MultiformatMessage fullDescription, MultiformatMessage messageStrings, String helpUri, MultiformatMessage help, PropertyBag properties, ReportingConfiguration defaultConfiguration) {
            this.id = id;
            this.name = name;
            this.shortDescription = shortDescription;
            this.fullDescription = fullDescription;
            this.messageStrings = messageStrings;
            this.helpUri = helpUri;
            this.help = help;
            this.properties = properties;
            this.defaultConfiguration = defaultConfiguration;
        }

        public static ReportingDescriptorBuilder builder() {
            return new ReportingDescriptorBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public MultiformatMessage getShortDescription() {
            return this.shortDescription;
        }

        public MultiformatMessage getFullDescription() {
            return this.fullDescription;
        }

        public MultiformatMessage getMessageStrings() {
            return this.messageStrings;
        }

        public String getHelpUri() {
            return this.helpUri;
        }

        public MultiformatMessage getHelp() {
            return this.help;
        }

        public PropertyBag getProperties() {
            return this.properties;
        }

        public ReportingConfiguration getDefaultConfiguration() {
            return this.defaultConfiguration;
        }

        public ReportingDescriptor setId(String id) {
            this.id = id;
            return this;
        }

        public ReportingDescriptor setName(String name) {
            this.name = name;
            return this;
        }

        public ReportingDescriptor setShortDescription(MultiformatMessage shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public ReportingDescriptor setFullDescription(MultiformatMessage fullDescription) {
            this.fullDescription = fullDescription;
            return this;
        }

        public ReportingDescriptor setMessageStrings(MultiformatMessage messageStrings) {
            this.messageStrings = messageStrings;
            return this;
        }

        public ReportingDescriptor setHelpUri(String helpUri) {
            this.helpUri = helpUri;
            return this;
        }

        public ReportingDescriptor setHelp(MultiformatMessage help) {
            this.help = help;
            return this;
        }

        public ReportingDescriptor setProperties(PropertyBag properties) {
            this.properties = properties;
            return this;
        }

        public ReportingDescriptor setDefaultConfiguration(ReportingConfiguration defaultConfiguration) {
            this.defaultConfiguration = defaultConfiguration;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReportingDescriptor that = (ReportingDescriptor)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.shortDescription, that.shortDescription) && Objects.equals(this.fullDescription, that.fullDescription) && Objects.equals(this.messageStrings, that.messageStrings) && Objects.equals(this.helpUri, that.helpUri) && Objects.equals(this.help, that.help) && Objects.equals(this.properties, that.properties) && Objects.equals(this.defaultConfiguration, that.defaultConfiguration);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.shortDescription, this.fullDescription, this.messageStrings, this.helpUri, this.help, this.properties, this.defaultConfiguration);
        }

        public String toString() {
            return "SarifLog.ReportingDescriptor(id=" + this.getId() + ", name=" + this.getName() + ", shortDescription=" + this.getShortDescription() + ", fullDescription=" + this.getFullDescription() + ", messageStrings=" + this.getMessageStrings() + ", helpUri=" + this.getHelpUri() + ", help=" + this.getHelp() + ", properties=" + this.getProperties() + ", defaultConfiguration=" + this.getDefaultConfiguration() + ")";
        }

        public static final class ReportingDescriptorBuilder {
            private String id;
            private String name;
            private MultiformatMessage shortDescription;
            private MultiformatMessage fullDescription;
            private MultiformatMessage messageStrings;
            private String helpUri;
            private MultiformatMessage help;
            private PropertyBag properties;
            private ReportingConfiguration defaultConfiguration;

            private ReportingDescriptorBuilder() {
            }

            public ReportingDescriptorBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ReportingDescriptorBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ReportingDescriptorBuilder shortDescription(MultiformatMessage shortDescription) {
                this.shortDescription = shortDescription;
                return this;
            }

            public ReportingDescriptorBuilder fullDescription(MultiformatMessage fullDescription) {
                this.fullDescription = fullDescription;
                return this;
            }

            public ReportingDescriptorBuilder messageStrings(MultiformatMessage messageStrings) {
                this.messageStrings = messageStrings;
                return this;
            }

            public ReportingDescriptorBuilder helpUri(String helpUri) {
                this.helpUri = helpUri;
                return this;
            }

            public ReportingDescriptorBuilder help(MultiformatMessage help) {
                this.help = help;
                return this;
            }

            public ReportingDescriptorBuilder properties(PropertyBag properties) {
                this.properties = properties;
                return this;
            }

            public ReportingDescriptorBuilder defaultConfiguration(ReportingConfiguration defaultConfiguration) {
                this.defaultConfiguration = defaultConfiguration;
                return this;
            }

            public ReportingDescriptor build() {
                return new ReportingDescriptor(this.id, this.name, this.shortDescription, this.fullDescription, this.messageStrings, this.helpUri, this.help, this.properties, this.defaultConfiguration);
            }

            public String toString() {
                return "SarifLog.ReportingDescriptor.ReportingDescriptorBuilder(id=" + this.id + ", name=" + this.name + ", shortDescription=" + this.shortDescription + ", fullDescription=" + this.fullDescription + ", messageStrings=" + this.messageStrings + ", helpUri=" + this.helpUri + ", help=" + this.help + ", properties=" + this.properties + ", defaultConfiguration=" + this.defaultConfiguration + ")";
            }
        }
    }

    public static final class Component {
        private String name;
        private String version;
        private String informationUri;
        private List<ReportingDescriptor> rules;

        private Component(String name, String version, String informationUri, List<ReportingDescriptor> rules) {
            this.name = name;
            this.version = version;
            this.informationUri = informationUri;
            this.rules = rules;
        }

        public static ComponentBuilder builder() {
            return new ComponentBuilder();
        }

        public ComponentBuilder toBuilder() {
            return new ComponentBuilder().name(this.name).version(this.version).informationUri(this.informationUri).rules(this.rules);
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getInformationUri() {
            return this.informationUri;
        }

        public List<ReportingDescriptor> getRules() {
            return this.rules;
        }

        public Component setName(String name) {
            this.name = name;
            return this;
        }

        public Component setVersion(String version) {
            this.version = version;
            return this;
        }

        public Component setInformationUri(String informationUri) {
            this.informationUri = informationUri;
            return this;
        }

        public Component setRules(List<ReportingDescriptor> rules) {
            this.rules = rules;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Component component = (Component)o;
            return Objects.equals(this.name, component.name) && Objects.equals(this.version, component.version) && Objects.equals(this.informationUri, component.informationUri) && Objects.equals(this.rules, component.rules);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.version, this.informationUri, this.rules);
        }

        public String toString() {
            return "SarifLog.Component(name=" + this.getName() + ", version=" + this.getVersion() + ", informationUri=" + this.getInformationUri() + ", rules=" + this.getRules() + ")";
        }

        public static final class ComponentBuilder {
            private String name;
            private String version;
            private String informationUri;
            private List<ReportingDescriptor> rules;

            private ComponentBuilder() {
            }

            public ComponentBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ComponentBuilder version(String version) {
                this.version = version;
                return this;
            }

            public ComponentBuilder informationUri(String informationUri) {
                this.informationUri = informationUri;
                return this;
            }

            public ComponentBuilder rules(List<ReportingDescriptor> rules) {
                this.rules = rules;
                return this;
            }

            public Component build() {
                return new Component(this.name, this.version, this.informationUri, this.rules);
            }

            public String toString() {
                return "SarifLog.Component.ComponentBuilder(name=" + this.name + ", version=" + this.version + ", informationUri=" + this.informationUri + ", rules=" + this.rules + ")";
            }
        }
    }

    public static final class Tool {
        private Component driver;

        private Tool(Component driver) {
            this.driver = driver;
        }

        public static ToolBuilder builder() {
            return new ToolBuilder();
        }

        public Component getDriver() {
            return this.driver;
        }

        public Tool setDriver(Component driver) {
            this.driver = driver;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tool tool = (Tool)o;
            return Objects.equals(this.driver, tool.driver);
        }

        public int hashCode() {
            return Objects.hashCode(this.driver);
        }

        public String toString() {
            return "SarifLog.Tool(driver=" + this.getDriver() + ")";
        }

        public static final class ToolBuilder {
            private Component driver;

            private ToolBuilder() {
            }

            public ToolBuilder driver(Component driver) {
                this.driver = driver;
                return this;
            }

            public Tool build() {
                return new Tool(this.driver);
            }

            public String toString() {
                return "SarifLog.Tool.ToolBuilder(driver=" + this.driver + ")";
            }
        }
    }

    public static final class Run {
        private Tool tool;
        private List<Result> results;
        private List<Invocation> invocations;

        private Run(Tool tool, List<Result> results, List<Invocation> invocations) {
            this.tool = tool;
            this.results = results;
            this.invocations = invocations;
        }

        public static RunBuilder builder() {
            return new RunBuilder();
        }

        public Tool getTool() {
            return this.tool;
        }

        public List<Result> getResults() {
            return this.results;
        }

        public List<Invocation> getInvocations() {
            return this.invocations;
        }

        public Run setTool(Tool tool) {
            this.tool = tool;
            return this;
        }

        public Run setResults(List<Result> results) {
            this.results = results;
            return this;
        }

        public Run setInvocations(List<Invocation> invocations) {
            this.invocations = invocations;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Run run = (Run)o;
            return Objects.equals(this.tool, run.tool) && Objects.equals(this.results, run.results) && Objects.equals(this.invocations, run.invocations);
        }

        public int hashCode() {
            return Objects.hash(this.tool, this.results, this.invocations);
        }

        public String toString() {
            return "SarifLog.Run(tool=" + this.getTool() + ", results=" + this.getResults() + ", invocations=" + this.getInvocations() + ")";
        }

        public static final class RunBuilder {
            private Tool tool;
            private List<Result> results;
            private List<Invocation> invocations;

            private RunBuilder() {
            }

            public RunBuilder tool(Tool tool) {
                this.tool = tool;
                return this;
            }

            public RunBuilder result(Result result) {
                if (this.results == null) {
                    this.results = new ArrayList<Result>();
                }
                this.results.add(result);
                return this;
            }

            public RunBuilder results(Collection<? extends Result> results) {
                if (results == null) {
                    throw new NullPointerException("results cannot be null");
                }
                if (this.results == null) {
                    this.results = new ArrayList<Result>();
                }
                this.results.addAll(results);
                return this;
            }

            public RunBuilder clearResults() {
                if (this.results != null) {
                    this.results.clear();
                }
                return this;
            }

            public RunBuilder invocations(List<Invocation> invocations) {
                this.invocations = invocations;
                return this;
            }

            public Run build() {
                List<Object> results;
                switch (this.results == null ? 0 : this.results.size()) {
                    case 0: {
                        results = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        results = Collections.singletonList(this.results.get(0));
                        break;
                    }
                    default: {
                        results = Collections.unmodifiableList(new ArrayList<Result>(this.results));
                    }
                }
                return new Run(this.tool, results, this.invocations);
            }

            public String toString() {
                return "SarifLog.Run.RunBuilder(tool=" + this.tool + ", results=" + this.results + ", invocations=" + this.invocations + ")";
            }
        }
    }

    public static final class Message {
        private String text;
        private String markdown;
        private String id;

        private Message(String text, String markdown, String id) {
            this.text = text;
            this.markdown = markdown;
            this.id = id;
        }

        public static MessageBuilder builder() {
            return new MessageBuilder();
        }

        public String getText() {
            return this.text;
        }

        public String getMarkdown() {
            return this.markdown;
        }

        public String getId() {
            return this.id;
        }

        public Message setText(String text) {
            this.text = text;
            return this;
        }

        public Message setMarkdown(String markdown) {
            this.markdown = markdown;
            return this;
        }

        public Message setId(String id) {
            this.id = id;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message message = (Message)o;
            return Objects.equals(this.text, message.text) && Objects.equals(this.markdown, message.markdown) && Objects.equals(this.id, message.id);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.markdown, this.id);
        }

        public String toString() {
            return "SarifLog.Message(text=" + this.getText() + ", markdown=" + this.getMarkdown() + ", id=" + this.getId() + ")";
        }

        public static final class MessageBuilder {
            private String text;
            private String markdown;
            private String id;

            private MessageBuilder() {
            }

            public MessageBuilder text(String text) {
                this.text = text;
                return this;
            }

            public MessageBuilder markdown(String markdown) {
                this.markdown = markdown;
                return this;
            }

            public MessageBuilder id(String id) {
                this.id = id;
                return this;
            }

            public Message build() {
                return new Message(this.text, this.markdown, this.id);
            }

            public String toString() {
                return "SarifLog.Message.MessageBuilder(text=" + this.text + ", markdown=" + this.markdown + ", id=" + this.id + ")";
            }
        }
    }

    public static final class Result {
        private String ruleId;
        private Integer ruleIndex;
        private Message message;
        private String level;
        private List<Location> locations;
        private PropertyBag properties;

        private Result(String ruleId, Integer ruleIndex, Message message, String level, List<Location> locations, PropertyBag properties) {
            this.ruleId = ruleId;
            this.ruleIndex = ruleIndex;
            this.message = message;
            this.level = level;
            this.locations = locations;
            this.properties = properties;
        }

        public static ResultBuilder builder() {
            return new ResultBuilder();
        }

        public String getRuleId() {
            return this.ruleId;
        }

        public Integer getRuleIndex() {
            return this.ruleIndex;
        }

        public Message getMessage() {
            return this.message;
        }

        public String getLevel() {
            return this.level;
        }

        public List<Location> getLocations() {
            return this.locations;
        }

        public PropertyBag getProperties() {
            return this.properties;
        }

        public Result setRuleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public Result setRuleIndex(Integer ruleIndex) {
            this.ruleIndex = ruleIndex;
            return this;
        }

        public Result setMessage(Message message) {
            this.message = message;
            return this;
        }

        public Result setLevel(String level) {
            this.level = level;
            return this;
        }

        public Result setLocations(List<Location> locations) {
            this.locations = locations;
            return this;
        }

        public Result setProperties(PropertyBag properties) {
            this.properties = properties;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return Objects.equals(this.ruleId, result.ruleId) && Objects.equals(this.ruleIndex, result.ruleIndex) && Objects.equals(this.message, result.message) && Objects.equals(this.level, result.level) && Objects.equals(this.locations, result.locations) && Objects.equals(this.properties, result.properties);
        }

        public int hashCode() {
            return Objects.hash(this.ruleId, this.ruleIndex, this.message, this.level, this.locations, this.properties);
        }

        public String toString() {
            return "SarifLog.Result(ruleId=" + this.getRuleId() + ", ruleIndex=" + this.getRuleIndex() + ", message=" + this.getMessage() + ", level=" + this.getLevel() + ", locations=" + this.getLocations() + ", properties=" + this.getProperties() + ")";
        }

        public static final class ResultBuilder {
            private String ruleId;
            private Integer ruleIndex;
            private Message message;
            private String level;
            private List<Location> locations;
            private PropertyBag properties;

            private ResultBuilder() {
            }

            public ResultBuilder ruleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }

            public ResultBuilder ruleIndex(Integer ruleIndex) {
                this.ruleIndex = ruleIndex;
                return this;
            }

            public ResultBuilder message(Message message) {
                this.message = message;
                return this;
            }

            public ResultBuilder level(String level) {
                this.level = level;
                return this;
            }

            public ResultBuilder locations(List<Location> locations) {
                this.locations = locations;
                return this;
            }

            public ResultBuilder properties(PropertyBag properties) {
                this.properties = properties;
                return this;
            }

            public Result build() {
                return new Result(this.ruleId, this.ruleIndex, this.message, this.level, this.locations, this.properties);
            }

            public String toString() {
                return "SarifLog.Result.ResultBuilder(ruleId=" + this.ruleId + ", ruleIndex=" + this.ruleIndex + ", message=" + this.message + ", level=" + this.level + ", locations=" + this.locations + ", properties=" + this.properties + ")";
            }
        }
    }

    public static final class Region {
        private Integer startLine;
        private Integer startColumn;
        private Integer endLine;
        private Integer endColumn;

        private Region(Integer startLine, Integer startColumn, Integer endLine, Integer endColumn) {
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
        }

        public static RegionBuilder builder() {
            return new RegionBuilder();
        }

        public Integer getStartLine() {
            return this.startLine;
        }

        public Integer getStartColumn() {
            return this.startColumn;
        }

        public Integer getEndLine() {
            return this.endLine;
        }

        public Integer getEndColumn() {
            return this.endColumn;
        }

        public Region setStartLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        public Region setStartColumn(Integer startColumn) {
            this.startColumn = startColumn;
            return this;
        }

        public Region setEndLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public Region setEndColumn(Integer endColumn) {
            this.endColumn = endColumn;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Region region = (Region)o;
            return Objects.equals(this.startLine, region.startLine) && Objects.equals(this.startColumn, region.startColumn) && Objects.equals(this.endLine, region.endLine) && Objects.equals(this.endColumn, region.endColumn);
        }

        public int hashCode() {
            return Objects.hash(this.startLine, this.startColumn, this.endLine, this.endColumn);
        }

        public String toString() {
            return "SarifLog.Region(startLine=" + this.getStartLine() + ", startColumn=" + this.getStartColumn() + ", endLine=" + this.getEndLine() + ", endColumn=" + this.getEndColumn() + ")";
        }

        public static final class RegionBuilder {
            private Integer startLine;
            private Integer startColumn;
            private Integer endLine;
            private Integer endColumn;

            private RegionBuilder() {
            }

            public RegionBuilder startLine(Integer startLine) {
                this.startLine = startLine;
                return this;
            }

            public RegionBuilder startColumn(Integer startColumn) {
                this.startColumn = startColumn;
                return this;
            }

            public RegionBuilder endLine(Integer endLine) {
                this.endLine = endLine;
                return this;
            }

            public RegionBuilder endColumn(Integer endColumn) {
                this.endColumn = endColumn;
                return this;
            }

            public Region build() {
                return new Region(this.startLine, this.startColumn, this.endLine, this.endColumn);
            }

            public String toString() {
                return "SarifLog.Region.RegionBuilder(startLine=" + this.startLine + ", startColumn=" + this.startColumn + ", endLine=" + this.endLine + ", endColumn=" + this.endColumn + ")";
            }
        }
    }

    public static final class PropertyBag {
        private String ruleset;
        private Integer priority;
        private Set<String> tags;

        private PropertyBag(String ruleset, Integer priority, Set<String> tags) {
            this.ruleset = ruleset;
            this.priority = priority;
            this.tags = tags;
        }

        public static PropertyBagBuilder builder() {
            return new PropertyBagBuilder();
        }

        public String getRuleset() {
            return this.ruleset;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public PropertyBag setRuleset(String ruleset) {
            this.ruleset = ruleset;
            return this;
        }

        public PropertyBag setPriority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public PropertyBag setTags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyBag that = (PropertyBag)o;
            return Objects.equals(this.ruleset, that.ruleset) && Objects.equals(this.priority, that.priority) && Objects.equals(this.tags, that.tags);
        }

        public int hashCode() {
            return Objects.hash(this.ruleset, this.priority, this.tags);
        }

        public String toString() {
            return "SarifLog.PropertyBag(ruleset=" + this.getRuleset() + ", priority=" + this.getPriority() + ", tags=" + this.getTags() + ")";
        }

        public static final class PropertyBagBuilder {
            private String ruleset;
            private Integer priority;
            private Set<String> tags;

            private PropertyBagBuilder() {
            }

            public PropertyBagBuilder ruleset(String ruleset) {
                this.ruleset = ruleset;
                return this;
            }

            public PropertyBagBuilder priority(Integer priority) {
                this.priority = priority;
                return this;
            }

            public PropertyBagBuilder tags(Set<String> tags) {
                this.tags = tags;
                return this;
            }

            public PropertyBag build() {
                return new PropertyBag(this.ruleset, this.priority, this.tags);
            }

            public String toString() {
                return "SarifLog.PropertyBag.PropertyBagBuilder(ruleset=" + this.ruleset + ", priority=" + this.priority + ", tags=" + this.tags + ")";
            }
        }
    }

    public static final class PhysicalLocation {
        private ArtifactLocation artifactLocation;
        private Region region;

        private PhysicalLocation(ArtifactLocation artifactLocation, Region region) {
            this.artifactLocation = artifactLocation;
            this.region = region;
        }

        public static PhysicalLocationBuilder builder() {
            return new PhysicalLocationBuilder();
        }

        public ArtifactLocation getArtifactLocation() {
            return this.artifactLocation;
        }

        public Region getRegion() {
            return this.region;
        }

        public PhysicalLocation setArtifactLocation(ArtifactLocation artifactLocation) {
            this.artifactLocation = artifactLocation;
            return this;
        }

        public PhysicalLocation setRegion(Region region) {
            this.region = region;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhysicalLocation that = (PhysicalLocation)o;
            return Objects.equals(this.artifactLocation, that.artifactLocation) && Objects.equals(this.region, that.region);
        }

        public int hashCode() {
            return Objects.hash(this.artifactLocation, this.region);
        }

        public String toString() {
            return "SarifLog.PhysicalLocation(artifactLocation=" + this.getArtifactLocation() + ", region=" + this.getRegion() + ")";
        }

        public static final class PhysicalLocationBuilder {
            private ArtifactLocation artifactLocation;
            private Region region;

            private PhysicalLocationBuilder() {
            }

            public PhysicalLocationBuilder artifactLocation(ArtifactLocation artifactLocation) {
                this.artifactLocation = artifactLocation;
                return this;
            }

            public PhysicalLocationBuilder region(Region region) {
                this.region = region;
                return this;
            }

            public PhysicalLocation build() {
                return new PhysicalLocation(this.artifactLocation, this.region);
            }

            public String toString() {
                return "SarifLog.PhysicalLocation.PhysicalLocationBuilder(artifactLocation=" + this.artifactLocation + ", region=" + this.region + ")";
            }
        }
    }

    public static final class ArtifactLocation {
        private String uri;
        private String uriBaseId;
        private Integer index;

        private ArtifactLocation(String uri, String uriBaseId, Integer index) {
            this.uri = uri;
            this.uriBaseId = uriBaseId;
            this.index = index;
        }

        public static ArtifactLocationBuilder builder() {
            return new ArtifactLocationBuilder();
        }

        public String getUri() {
            return this.uri;
        }

        public String getUriBaseId() {
            return this.uriBaseId;
        }

        public Integer getIndex() {
            return this.index;
        }

        public ArtifactLocation setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public ArtifactLocation setUriBaseId(String uriBaseId) {
            this.uriBaseId = uriBaseId;
            return this;
        }

        public ArtifactLocation setIndex(Integer index) {
            this.index = index;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactLocation that = (ArtifactLocation)o;
            return Objects.equals(this.uri, that.uri) && Objects.equals(this.uriBaseId, that.uriBaseId) && Objects.equals(this.index, that.index);
        }

        public int hashCode() {
            return Objects.hash(this.uri, this.uriBaseId, this.index);
        }

        public String toString() {
            return "SarifLog.ArtifactLocation(uri=" + this.getUri() + ", uriBaseId=" + this.getUriBaseId() + ", index=" + this.getIndex() + ")";
        }

        public static final class ArtifactLocationBuilder {
            private String uri;
            private String uriBaseId;
            private Integer index;

            private ArtifactLocationBuilder() {
            }

            public ArtifactLocationBuilder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public ArtifactLocationBuilder uriBaseId(String uriBaseId) {
                this.uriBaseId = uriBaseId;
                return this;
            }

            public ArtifactLocationBuilder index(Integer index) {
                this.index = index;
                return this;
            }

            public ArtifactLocation build() {
                return new ArtifactLocation(this.uri, this.uriBaseId, this.index);
            }

            public String toString() {
                return "SarifLog.ArtifactLocation.ArtifactLocationBuilder(uri=" + this.uri + ", uriBaseId=" + this.uriBaseId + ", index=" + this.index + ")";
            }
        }
    }

    public static final class Location {
        private Integer id;
        private PhysicalLocation physicalLocation;

        private Location(Integer id, PhysicalLocation physicalLocation) {
            this.id = id;
            this.physicalLocation = physicalLocation;
        }

        public static LocationBuilder builder() {
            return new LocationBuilder();
        }

        public Integer getId() {
            return this.id;
        }

        public PhysicalLocation getPhysicalLocation() {
            return this.physicalLocation;
        }

        public Location setId(Integer id) {
            this.id = id;
            return this;
        }

        public Location setPhysicalLocation(PhysicalLocation physicalLocation) {
            this.physicalLocation = physicalLocation;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            return Objects.equals(this.id, location.id) && Objects.equals(this.physicalLocation, location.physicalLocation);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.physicalLocation);
        }

        public String toString() {
            return "SarifLog.Location(id=" + this.getId() + ", physicalLocation=" + this.getPhysicalLocation() + ")";
        }

        public static final class LocationBuilder {
            private Integer id;
            private PhysicalLocation physicalLocation;

            private LocationBuilder() {
            }

            public LocationBuilder id(Integer id) {
                this.id = id;
                return this;
            }

            public LocationBuilder physicalLocation(PhysicalLocation physicalLocation) {
                this.physicalLocation = physicalLocation;
                return this;
            }

            public Location build() {
                return new Location(this.id, this.physicalLocation);
            }

            public String toString() {
                return "SarifLog.Location.LocationBuilder(id=" + this.id + ", physicalLocation=" + this.physicalLocation + ")";
            }
        }
    }
}

