/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Assignation
extends Expression
implements Binding {
    protected int slotNumber = -999;
    protected Expression sequence;
    protected Expression action;
    protected StructuredQName variableName;
    protected SequenceType requiredType;

    public void setRequiredType(SequenceType requiredType) {
        this.requiredType = requiredType;
    }

    public void setVariableQName(StructuredQName variableName) {
        this.variableName = variableName;
    }

    @Override
    public StructuredQName getVariableQName() {
        return this.variableName;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.variableName;
    }

    @Override
    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    @Override
    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    @Override
    public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
        ValueRepresentation actual = context.evaluateLocalVariable(this.slotNumber);
        if (actual instanceof MemoClosure && ((MemoClosure)actual).isFullyRead()) {
            actual = ((MemoClosure)actual).materialize();
            context.setLocalVariable(this.slotNumber, actual);
        }
        return actual;
    }

    public void setAction(Expression action) {
        this.action = action;
        this.adoptChildExpression(action);
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }

    @Override
    public final boolean isAssignable() {
        return false;
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        this.sequence.checkForUpdatingSubexpressions();
        if (this.sequence.isUpdatingExpression()) {
            XPathException err = new XPathException("An updating expression cannot be used to initialize a variable", "XUST0001");
            err.setLocator(this.sequence);
            throw err;
        }
        this.action.checkForUpdatingSubexpressions();
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.action.isUpdatingExpression();
    }

    public Expression getAction() {
        return this.action;
    }

    public void setSequence(Expression sequence) {
        this.sequence = sequence;
        this.adoptChildExpression(sequence);
    }

    public Expression getSequence() {
        return this.sequence;
    }

    public void setSlotNumber(int nr) {
        this.slotNumber = nr;
    }

    public int getRequiredSlots() {
        return 1;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.sequence = visitor.simplify(this.sequence);
        this.action = visitor.simplify(this.action);
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.sequence = this.doPromotion(this, this.sequence, offer);
        if (offer.action == 12 || offer.action == 13 || offer.action == 14) {
            this.action = this.doPromotion(this, this.action, offer);
        } else if (offer.action == 11 || offer.action == 10) {
            Binding[] savedBindingList = offer.bindingList;
            offer.bindingList = this.extendBindingList(offer.bindingList);
            this.action = this.doPromotion(this, this.action, offer);
            offer.bindingList = savedBindingList;
        }
        return this;
    }

    @Override
    public void suppressValidation(int validationMode) {
        this.action.suppressValidation(validationMode);
    }

    public Binding[] extendBindingList(Binding[] in) {
        Binding[] newBindingList;
        if (in == null) {
            newBindingList = new Binding[1];
        } else {
            newBindingList = new Binding[in.length + 1];
            System.arraycopy(in, 0, newBindingList, 0, in.length);
        }
        newBindingList[newBindingList.length - 1] = this;
        return newBindingList;
    }

    protected Expression promoteWhereClause(Binding positionBinding) {
        if (Choose.isSingleBranchChoice(this.action)) {
            Expression condition = ((Choose)this.action).getConditions()[0];
            Binding[] bindingList = positionBinding == null ? new Binding[]{this} : new Binding[]{this, positionBinding};
            ArrayList list = new ArrayList(5);
            Expression promotedCondition = null;
            BooleanExpression.listAndComponents(condition, list);
            for (int i = list.size() - 1; i >= 0; --i) {
                Expression term = (Expression)list.get(i);
                if (ExpressionTool.dependsOnVariable(term, bindingList)) continue;
                promotedCondition = promotedCondition == null ? term : new BooleanExpression(term, 10, promotedCondition);
                list.remove(i);
            }
            if (promotedCondition != null) {
                if (list.isEmpty()) {
                    Expression oldThen = ((Choose)this.action).getActions()[0];
                    this.setAction(oldThen);
                    return Choose.makeConditional(condition, this);
                }
                Expression retainedCondition = (Expression)list.get(0);
                for (int i = 1; i < list.size(); ++i) {
                    retainedCondition = new BooleanExpression(retainedCondition, 10, (Expression)list.get(i));
                }
                ((Choose)this.action).getConditions()[0] = retainedCondition;
                Expression newIf = Choose.makeConditional(promotedCondition, this, Literal.makeEmptySequence());
                ExpressionTool.copyLocationInfo(this, newIf);
                return newIf;
            }
        }
        return null;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator(this.sequence, this.action);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.sequence == original) {
            this.sequence = replacement;
            found = true;
        }
        if (this.action == original) {
            this.action = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet varPath = this.sequence.addToPathMap(pathMap, pathMapNodeSet);
        pathMap.registerPathForVariable(this, varPath);
        return this.action.addToPathMap(pathMap, pathMapNodeSet);
    }

    public String getVariableName() {
        if (this.variableName == null) {
            return "zz:var" + this.hashCode();
        }
        return this.variableName.getDisplayName();
    }

    public void refineTypeInformation(ItemType type, int cardinality, Value constantValue, int properties, ExpressionVisitor visitor, Assignation currentExpression) {
        ArrayList references = new ArrayList();
        ExpressionTool.gatherVariableReferences(currentExpression.getAction(), this, references);
        for (BindingReference ref : references) {
            if (!(ref instanceof VariableReference)) continue;
            ((VariableReference)ref).refineVariableType(type, cardinality, constantValue, properties, visitor);
            visitor.resetStaticProperties();
        }
    }
}

