/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashSet;
import java.util.Properties;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ResultDocument;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.Validation;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Whitespace;

public class XSLResultDocument
extends StyleElement {
    private static final HashSet fans = new HashSet(25);
    private Expression href;
    private StructuredQName formatQName;
    private Expression formatExpression;
    private int validationAction = 4;
    private SchemaType schemaType = null;
    private IntHashMap<Expression> serializationAttributes = new IntHashMap(10);

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return null;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String formatAttribute = null;
        String hrefAttribute = null;
        String validationAtt = null;
        String typeAtt = null;
        String useCharacterMapsAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("format")) {
                formatAttribute = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("href")) {
                hrefAttribute = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("validation")) {
                validationAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("type")) {
                typeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("use-character-maps")) {
                useCharacterMapsAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (fans.contains(f) || f.startsWith("{")) {
                String val = Whitespace.trim(atts.getValue(a));
                Expression exp = this.makeAttributeValueTemplate(val);
                this.serializationAttributes.put(nc & 0xFFFFF, exp);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (hrefAttribute != null) {
            this.href = this.makeAttributeValueTemplate(hrefAttribute);
        }
        if (formatAttribute != null) {
            this.formatExpression = this.makeAttributeValueTemplate(formatAttribute);
            if (this.formatExpression instanceof StringLiteral) {
                try {
                    this.formatQName = this.makeQName(((StringLiteral)this.formatExpression).getStringValue());
                    this.formatExpression = null;
                }
                catch (NamespaceException err) {
                    this.compileError(err.getMessage(), "XTSE0280");
                }
                catch (XPathException err) {
                    this.compileError(err.getMessage(), "XTDE1460");
                }
            }
        }
        if (validationAtt == null) {
            this.validationAction = this.getContainingStylesheet().getDefaultValidation();
        } else {
            this.validationAction = Validation.getCode(validationAtt);
            if (this.validationAction != 4 && !this.getExecutable().isSchemaAware()) {
                this.validationAction = 4;
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
            if (this.validationAction == -1) {
                this.compileError("Invalid value of @validation attribute", "XTSE0020");
            }
        }
        if (typeAtt != null) {
            if (!this.getExecutable().isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.schemaType = this.getSchemaType(typeAtt);
            this.validationAction = 8;
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if (useCharacterMapsAtt != null) {
            String s = XSLOutput.prepareCharacterMaps(this, useCharacterMapsAtt, new Properties());
            this.serializationAttributes.put(this.getNamePool().allocate("", "", "use-character-maps"), new StringLiteral(s));
        }
    }

    public void validate() throws XPathException {
        if (this.href != null && !this.getPreparedStylesheet().getConfiguration().isAllowExternalFunctions()) {
            this.compileError("xsl:result-document is disabled when extension functions are disabled");
        }
        this.href = this.typeCheck("href", this.href);
        this.formatExpression = this.typeCheck("format", this.formatExpression);
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            Expression exp2;
            int fp = it.next();
            String displayName = this.getNamePool().getDisplayName(fp);
            Expression exp1 = this.serializationAttributes.get(fp);
            if (exp1 == (exp2 = this.typeCheck(displayName, exp1))) continue;
            this.serializationAttributes.put(fp, exp2);
        }
        this.getExecutable().setCreatesSecondaryResult(true);
    }

    public Expression compile(Executable exec) throws XPathException {
        AxisIterator kids;
        NodeInfo first;
        Properties globalProps;
        if (this.formatExpression == null) {
            try {
                globalProps = this.getPrincipalStylesheet().gatherOutputProperties(this.formatQName);
            }
            catch (XPathException err) {
                this.compileError("Named output format has not been defined", "XTDE1460");
                return null;
            }
        } else {
            globalProps = new Properties();
            this.getPrincipalStylesheet().setNeedsDynamicOutputProperties(true);
        }
        int key = this.getNamePool().allocate("", "", "method");
        if (this.formatExpression == null && globalProps.getProperty("method") == null && this.serializationAttributes.get(key) == null && (first = (NodeInfo)(kids = this.iterateAxis((byte)3)).next()) instanceof LiteralResultElement) {
            if (first.getFingerprint() == this.getNamePool().allocate("", "http://www.w3.org/1999/xhtml", "html")) {
                globalProps.setProperty("method", "xhtml");
            } else if (first.getLocalPart().equalsIgnoreCase("html") && first.getURI().length() == 0) {
                globalProps.setProperty("method", "html");
            } else {
                globalProps.setProperty("method", "xml");
            }
        }
        Properties localProps = new Properties();
        IntHashSet fixed = new IntHashSet(10);
        boolean needsNamespaceContext = this.formatExpression != null;
        NamespaceResolver namespaceResolver = this.getStaticContext().getNamespaceResolver();
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int fp = it.next();
            Expression exp = this.serializationAttributes.get(fp);
            if (exp instanceof StringLiteral) {
                String s = ((StringLiteral)exp).getStringValue();
                String lname = this.getNamePool().getLocalName(fp);
                String uri = this.getNamePool().getURI(fp);
                try {
                    ResultDocument.setSerializationProperty(localProps, uri, lname, s, namespaceResolver, false, exec.getConfiguration());
                    fixed.add(fp);
                }
                catch (XPathException e) {
                    if ("http://saxon.sf.net/".equals(e.getErrorCodeNamespace())) {
                        this.compileWarning(e.getMessage(), e.getErrorCodeQName());
                        continue;
                    }
                    this.compileError(e);
                }
                continue;
            }
            String lname = this.getNamePool().getLocalName(fp);
            if (!lname.equals("method") && !lname.equals("cdata-section-elements") && !lname.equals("suppress-indentation")) continue;
            needsNamespaceContext = true;
        }
        it = fixed.iterator();
        while (it.hasNext()) {
            this.serializationAttributes.remove(it.next());
        }
        ResultDocument inst = new ResultDocument(globalProps, localProps, this.href, this.formatExpression, this.getBaseURI(), this.validationAction, this.schemaType, this.serializationAttributes, needsNamespaceContext ? namespaceResolver : null);
        Expression b = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        if (b == null) {
            b = new Literal(EmptySequence.getInstance());
        }
        inst.setContentExpression(b);
        return inst;
    }

    static {
        fans.add("method");
        fans.add("output-version");
        fans.add("byte-order-mark");
        fans.add("indent");
        fans.add("encoding");
        fans.add("media-type");
        fans.add("doctype-system");
        fans.add("doctype-public");
        fans.add("omit-xml-declaration");
        fans.add("standalone");
        fans.add("cdata-section-elements");
        fans.add("include-content-type");
        fans.add("escape-uri-attributes");
        fans.add("undeclare-prefixes");
        fans.add("normalization-form");
        fans.add("{http://saxon.sf.net/}next-in-chain");
        fans.add("{http://saxon.sf.net/}character-representation");
        fans.add("{http://saxon.sf.net/}indent-spaces");
        fans.add("{http://saxon.sf.net/}require-well-formed");
        fans.add("{http://saxon.sf.net/}suppress-indentation");
    }
}

