/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.auth;

import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.AuthThread;
import net.spy.memcached.compat.SpyObject;

public class AuthThreadMonitor
extends SpyObject {
    private Map<Object, AuthThread> nodeMap = new HashMap<Object, AuthThread>();

    public synchronized void authConnection(MemcachedConnection conn, OperationFactory opFact, AuthDescriptor authDescriptor, MemcachedNode node) {
        this.interruptOldAuth(node);
        AuthThread newSASLAuthenticator = new AuthThread(conn, opFact, authDescriptor, node);
        this.nodeMap.put(node, newSASLAuthenticator);
    }

    private void interruptOldAuth(MemcachedNode nodeToStop) {
        AuthThread toStop = this.nodeMap.get(nodeToStop);
        if (toStop != null) {
            if (toStop.isAlive()) {
                this.getLogger().warn("Incomplete authentication interrupted for node " + nodeToStop);
                toStop.interrupt();
            }
            this.nodeMap.remove(nodeToStop);
        }
    }
}

