/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.javaflow.spi.ClassMatcher;
import org.apache.commons.javaflow.spi.ClassMatchers;

class ClassMatcherFileParser {
    private static final Map<String, ClassMatcherFactory> FACTORIES;

    ClassMatcherFileParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassMatcher parse(URL url) throws IOException {
        ArrayList<ClassMatcher> matchers = new ArrayList<ClassMatcher>();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(url.openStream()));
        try {
            String s;
            while (null != (s = ((BufferedReader)reader).readLine())) {
                ClassMatcherFactory factory;
                if (s.length() == 0 || s.startsWith("#")) continue;
                int columnPos = s.indexOf(58);
                int equalsPos = s.indexOf(61);
                if (columnPos < 0 || equalsPos < 0) continue;
                String kind = s.substring(0, columnPos).trim();
                String variant = s.substring(columnPos + 1, equalsPos).trim();
                String target = s.substring(equalsPos + 1).trim();
                if (target.length() == 0 || null == (factory = FACTORIES.get(kind + ':' + variant))) continue;
                matchers.add(factory.create(target));
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return matchers.isEmpty() ? ClassMatchers.MATCH_NONE : ClassMatchers.whenAny(matchers);
    }

    static {
        HashMap<String, ClassMatcherFactory> map = new HashMap<String, ClassMatcherFactory>();
        map.put("class:name", new ClassMatcherFactory(){

            @Override
            public ClassMatcher create(String className) {
                return ClassMatchers.byClassName(className, false);
            }
        });
        map.put("class:name-part", new ClassMatcherFactory(){

            @Override
            public ClassMatcher create(String className) {
                return ClassMatchers.byClassName(className, true);
            }
        });
        map.put("class:name-pattern", new ClassMatcherFactory(){

            @Override
            public ClassMatcher create(String classNamePattern) {
                return ClassMatchers.byClassNamePattern(classNamePattern);
            }
        });
        map.put("extends-class:name", new ClassMatcherFactory(){

            @Override
            public ClassMatcher create(String superClassName) {
                return ClassMatchers.bySuperClassName(superClassName, false);
            }
        });
        map.put("extends-class:name-part", new ClassMatcherFactory(){

            @Override
            public ClassMatcher create(String superClassName) {
                return ClassMatchers.bySuperClassName(superClassName, true);
            }
        });
        map.put("extends-class:name-pattern", new ClassMatcherFactory(){

            @Override
            public ClassMatcher create(String superClassNamePattern) {
                return ClassMatchers.bySuperClassNamePattern(superClassNamePattern);
            }
        });
        map.put("implements-interface:name", new ClassMatcherFactory(){

            @Override
            public ClassMatcher create(String interfaceName) {
                return ClassMatchers.byInterfaceName(interfaceName, false);
            }
        });
        map.put("implements-interface:name-part", new ClassMatcherFactory(){

            @Override
            public ClassMatcher create(String interfaceName) {
                return ClassMatchers.byInterfaceName(interfaceName, true);
            }
        });
        map.put("implements-interface:name-pattern", new ClassMatcherFactory(){

            @Override
            public ClassMatcher create(String interfaceNamePattern) {
                return ClassMatchers.byInterfaceNamePattern(interfaceNamePattern);
            }
        });
        FACTORIES = Collections.unmodifiableMap(map);
    }

    static interface ClassMatcherFactory {
        public ClassMatcher create(String var1);
    }
}

